/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.entity.projectile;

import java.util.HashSet;
import java.util.Set;
import moriyashiine.enchancement.client.payload.PlayBrimstoneTravelSoundPayload;
import moriyashiine.enchancement.common.init.ModComponentTypes;
import moriyashiine.enchancement.common.init.ModDamageTypes;
import moriyashiine.enchancement.common.init.ModEntityTypes;
import moriyashiine.enchancement.common.init.ModParticleTypes;
import moriyashiine.enchancement.common.tag.ModEntityTypeTags;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class BrimstoneEntity
extends class_1665 {
    public static final class_1799 BRIMSTONE_STACK = new class_1799((class_1935)class_1802.field_8187);
    public static final int DISTANCE_PER_TICK = 6;
    public static final class_2940<Float> DAMAGE;
    public static final class_2940<Float> FORCED_PITCH;
    public static final class_2940<Float> FORCED_YAW;
    private static final class_2390 PARTICLE;
    public int distanceTraveled = 0;
    public int ticksExisted = 0;
    private final Set<class_1297> hitEntities = new HashSet<class_1297>();
    private final Set<class_1297> killedEntities = new HashSet<class_1297>();

    public static int getMaxTicks() {
        return class_3532.method_15375((float)42.666668f);
    }

    public BrimstoneEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
    }

    public BrimstoneEntity(class_1937 world, class_1309 owner, @Nullable class_1799 shotFrom) {
        super(ModEntityTypes.BRIMSTONE, owner, world, class_1799.field_8037, shotFrom);
        this.method_5814(owner.method_23317(), owner.method_23320() - 0.3, owner.method_23321());
    }

    protected class_1799 method_57314() {
        return class_1799.field_8037;
    }

    public void method_5773() {
        if (!this.method_73183().method_8608() && this.ticksExisted == 0) {
            PlayerLookup.all((MinecraftServer)this.method_73183().method_8503()).forEach(foundPlayer -> PlayBrimstoneTravelSoundPayload.send(foundPlayer, (class_1297)this));
        }
        if (this.method_7443()) {
            this.method_7439(false);
        }
        this.method_18799(class_243.field_1353);
        for (int i = 0; i < 6; ++i) {
            float min = Math.min(this.distanceTraveled, this.ticksExisted);
            if (min > 0.0f && min == (float)this.distanceTraveled) {
                this.method_31472();
            }
            class_243 start = this.method_73189().method_1019(this.method_5720().method_1021((double)(this.distanceTraveled + (this.ticksExisted > 0 ? -1 : 0))));
            class_243 end = start.method_1019(this.method_5720());
            class_3965 hitResult = this.method_73183().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            if (hitResult.method_17783() == class_239.class_240.field_1332) {
                if (this.method_73183().method_8608()) {
                    this.addParticles((class_2394)PARTICLE, hitResult.method_17784().method_10216(), hitResult.method_17784().method_10214(), hitResult.method_17784().method_10215());
                    break;
                }
                this.method_73183().method_32888((class_6880)class_5712.field_28162, hitResult.method_17784(), class_5712.class_7397.method_43285((class_1297)this));
                break;
            }
            class_1297 owner = this.method_24921();
            this.method_73183().method_8333(owner, class_238.method_29968((class_243)hitResult.method_17784()).method_1014(0.5), class_1301.field_6155.and(entity -> this.canEntityBeHit(owner, (class_1297)entity))).forEach(entity -> {
                class_1937 patt0$temp = this.method_73183();
                if (patt0$temp instanceof class_3218) {
                    class_1309 living;
                    class_3218 world = (class_3218)patt0$temp;
                    double damage = this.getDamage();
                    if (entity instanceof class_1309) {
                        living = (class_1309)entity;
                        damage *= (double)(living.method_6063() / 20.0f);
                    }
                    damage *= (double)this.getDamageMultiplier(this.distanceTraveled);
                    damage = Math.min(50.0, damage);
                    entity.method_64397(world, world.method_48963().method_48797(ModDamageTypes.BRIMSTONE, (class_1297)this, owner), (float)damage);
                    this.hitEntities.add((class_1297)entity);
                    if (entity instanceof class_1309 && (living = (class_1309)entity).method_29504()) {
                        this.killedEntities.add((class_1297)living);
                    }
                } else {
                    this.addParticles((class_2394)PARTICLE, entity.method_23317(), entity.method_23319(), entity.method_23321());
                }
            });
            ++this.distanceTraveled;
        }
        if (this.method_73183().method_8608()) {
            class_243 particlePos = this.method_73189().method_1019(this.method_5720().method_1021((double)this.distanceTraveled));
            this.addParticles((class_2394)PARTICLE, particlePos.method_10216(), particlePos.method_10214(), particlePos.method_10215());
            this.addParticles((class_2394)ModParticleTypes.BRIMSTONE_BUBBLE, particlePos.method_10216(), particlePos.method_10214(), particlePos.method_10215());
        } else if (this.ticksExisted > BrimstoneEntity.getMaxTicks()) {
            this.method_31472();
        }
        ++this.ticksExisted;
    }

    protected void method_7454(class_3966 entityHitResult) {
    }

    protected void method_24920(class_3965 blockHitResult) {
    }

    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        this.method_7438(view.method_71423("Damage", 0.0f));
        this.field_6011.method_12778(FORCED_PITCH, (Object)Float.valueOf(view.method_71423("ForcedPitch", 0.0f)));
        this.field_6011.method_12778(FORCED_YAW, (Object)Float.valueOf(view.method_71423("ForcedYaw", 0.0f)));
        this.distanceTraveled = view.method_71424("DistanceTraveled", 0);
        this.ticksExisted = view.method_71424("TicksExisted", 0);
    }

    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71464("Damage", this.getDamage());
        view.method_71464("ForcedPitch", this.method_36455());
        view.method_71464("ForcedYaw", this.method_36454());
        view.method_71465("DistanceTraveled", this.distanceTraveled);
        view.method_71465("TicksExisted", this.ticksExisted);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DAMAGE, (Object)Float.valueOf(0.0f));
        builder.method_56912(FORCED_PITCH, (Object)Float.valueOf(0.0f));
        builder.method_56912(FORCED_YAW, (Object)Float.valueOf(0.0f));
    }

    public float method_36455() {
        return ((Float)this.field_6011.method_12789(FORCED_PITCH)).floatValue();
    }

    public float method_36454() {
        return ((Float)this.field_6011.method_12789(FORCED_YAW)).floatValue();
    }

    public void method_7438(double damage) {
        this.field_6011.method_12778(DAMAGE, (Object)Float.valueOf((float)damage));
    }

    public float getDamage() {
        return ((Float)this.field_6011.method_12789(DAMAGE)).floatValue();
    }

    public void method_5650(class_1297.class_5529 reason) {
        class_1297 class_12972;
        super.method_5650(reason);
        if (reason.method_31486() && (class_12972 = this.method_24921()) instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            class_174.field_54206.method_8980(player, this.killedEntities, this.method_59958());
        }
    }

    public float getDamageMultiplier(int distanceTraveled) {
        float threshold = 12.0f;
        if ((float)distanceTraveled < 12.0f) {
            return class_3532.method_16439((float)((float)distanceTraveled / 12.0f), (float)0.25f, (float)1.0f);
        }
        return Math.min(2.0f, class_3532.method_16439((float)(((float)distanceTraveled - 12.0f) / 200.0f), (float)1.0f, (float)2.0f));
    }

    private void addParticles(class_2394 particle, double x, double y, double z) {
        float range = class_3532.method_16439((float)(this.getDamage() / 12.0f), (float)0.0f, (float)0.5f);
        for (int i = 0; i < 8; ++i) {
            this.method_73183().method_17452(particle, true, x + (double)class_3532.method_15344((class_5819)this.field_5974, (float)(-range), (float)range), y + (double)class_3532.method_15344((class_5819)this.field_5974, (float)(-range), (float)range), z + (double)class_3532.method_15344((class_5819)this.field_5974, (float)(-range), (float)range), (double)class_3532.method_15344((class_5819)this.field_5974, (float)-1.0f, (float)1.0f), (double)class_3532.method_15344((class_5819)this.field_5974, (float)-1.0f, (float)1.0f), (double)class_3532.method_15344((class_5819)this.field_5974, (float)-1.0f, (float)1.0f));
        }
    }

    private boolean canEntityBeHit(class_1297 owner, class_1297 entity) {
        if (entity instanceof class_1309 || entity.method_5864().method_20210(ModEntityTypeTags.BRIMSTONE_HITTABLE)) {
            return !this.hitEntities.contains(entity) && entity.method_5805() && SLibUtils.shouldHurt((class_1297)owner, (class_1297)entity);
        }
        return false;
    }

    static {
        BRIMSTONE_STACK.method_57379(ModComponentTypes.BRIMSTONE_DAMAGE, (Object)Integer.MAX_VALUE);
        DAMAGE = class_2945.method_12791(BrimstoneEntity.class, (class_2941)class_2943.field_13320);
        FORCED_PITCH = class_2945.method_12791(BrimstoneEntity.class, (class_2941)class_2943.field_13320);
        FORCED_YAW = class_2945.method_12791(BrimstoneEntity.class, (class_2941)class_2943.field_13320);
        PARTICLE = new class_2390(0xFF0000, 1.0f);
    }
}

