/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.event.enchantmenteffectcomponenttype;

import java.util.ArrayList;
import java.util.List;
import moriyashiine.enchancement.common.component.entity.AirMobilityComponent;
import moriyashiine.enchancement.common.component.entity.BounceComponent;
import moriyashiine.enchancement.common.init.ModEnchantmentEffectComponentTypes;
import moriyashiine.enchancement.common.init.ModEntityComponents;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import moriyashiine.strawberrylib.api.event.PreventFallDamageEvent;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_8111;
import net.minecraft.server.MinecraftServer;

public class BounceEvent {
    private static final List<Entry> ENTRIES = new ArrayList<Entry>();

    private static void bounce(class_1297 entity, BounceComponent bounceComponent, double bounceStrength) {
        ((AirMobilityComponent)ModEntityComponents.AIR_MOBILITY.get((Object)entity)).enableResetBypass();
        bounceComponent.markBounced();
        entity.method_18800(entity.method_18798().method_10216(), bounceStrength, entity.method_18798().method_10215());
        entity.field_6037 = true;
    }

    private static void scheduleBounce(class_1297 entity, double bounceStrength) {
        ENTRIES.add(new Entry(entity, bounceStrength));
    }

    private record Entry(class_1297 entity, double bounceStrength) {
    }

    public static class DelayedBounce
    implements ServerTickEvents.EndTick {
        public void onEndTick(MinecraftServer minecraftServer) {
            for (int i = ENTRIES.size() - 1; i >= 0; --i) {
                class_1309 living;
                Entry entry = ENTRIES.get(i);
                class_1297 entity = entry.entity();
                if (entity instanceof class_1309 && (living = (class_1309)entity).method_5805()) {
                    BounceEvent.bounce(entity, (BounceComponent)ModEntityComponents.BOUNCE.get((Object)living), entry.bounceStrength());
                }
                ENTRIES.remove(i);
            }
        }
    }

    public static class Bounce
    implements PreventFallDamageEvent {
        public TriState preventsFallDamage(class_1937 world, class_1309 entity, double fallDistance, float damagePerDistance, class_1282 damageSource) {
            if (!damageSource.method_49708(class_8111.field_42355) && fallDistance > (double)entity.method_5850() && EnchancementUtil.hasAnyEnchantmentsWith((class_1297)entity, ModEnchantmentEffectComponentTypes.BOUNCE)) {
                SLibUtils.playSound((class_1297)entity, (class_3414)class_3417.field_14560);
                BounceComponent bounceComponent = (BounceComponent)ModEntityComponents.BOUNCE.get((Object)entity);
                if (Bounce.shouldBounce(entity, bounceComponent)) {
                    double bounceStrength = Math.log(fallDistance / 7.0 + 1.0) / Math.log(1.05) / 16.0;
                    if (entity.method_31747() || entity.method_65038()) {
                        BounceEvent.bounce((class_1297)entity, bounceComponent, bounceStrength);
                    } else {
                        BounceEvent.scheduleBounce((class_1297)entity, bounceStrength);
                    }
                }
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        }

        private static boolean shouldBounce(class_1309 entity, BounceComponent bounceComponent) {
            boolean bounce;
            boolean bl = bounce = !SLibUtils.isCrouching((class_1297)entity, (boolean)true);
            if (bounceComponent.hasInvertedBounce()) {
                bounce = !bounce;
            }
            return bounce;
        }
    }
}

