/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.event.enchantmenteffectcomponenttype;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import moriyashiine.enchancement.common.ModConfig;
import moriyashiine.enchancement.common.component.world.FellTreesComponent;
import moriyashiine.enchancement.common.init.ModEnchantmentEffectComponentTypes;
import moriyashiine.enchancement.common.init.ModWorldComponents;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import moriyashiine.strawberrylib.api.event.ModifyBlockBreakingSpeedEvent;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class FellTreesEvent {
    public static final List<Entry> ENTRIES = new ArrayList<Entry>();

    public static List<class_2338> gatherTree(List<class_2338> tree, class_1922 world, class_2338.class_2339 pos, class_2248 original) {
        if (tree.size() < ModConfig.maxFellTreesBlocks) {
            int originalX = pos.method_10263();
            int originalY = pos.method_10264();
            int originalZ = pos.method_10260();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        class_2680 state;
                        class_1937 borderWorld;
                        pos.method_10103(originalX + x, originalY + y, originalZ + z);
                        if (world instanceof class_1937 && !(borderWorld = (class_1937)world).method_8621().method_11952((class_2338)pos) || !(state = world.method_8320((class_2338)pos)).method_26164(class_3481.field_15475) || tree.contains(pos) || state.method_26204() != original) continue;
                        tree.add(pos.method_10062());
                        FellTreesEvent.gatherTree(tree, world, pos, original);
                    }
                }
            }
        }
        return tree;
    }

    public static boolean isWithinHorizontalBounds(List<class_2338> tree) {
        Integer minX = null;
        Integer maxX = null;
        Integer minZ = null;
        Integer maxZ = null;
        for (class_2338 pos : tree) {
            if (minX == null || pos.method_10263() < minX) {
                minX = pos.method_10263();
            }
            if (maxX == null || pos.method_10263() > maxX) {
                maxX = pos.method_10263();
            }
            if (minZ == null || pos.method_10260() < minZ) {
                minZ = pos.method_10260();
            }
            if (maxZ != null && pos.method_10260() <= maxZ) continue;
            maxZ = pos.method_10260();
        }
        if (minX == null) {
            return false;
        }
        return Math.abs(maxX - minX) < ModConfig.maxFellTreesHorizontalLength && Math.abs(maxZ - minZ) < ModConfig.maxFellTreesHorizontalLength;
    }

    public static boolean canActivate(class_1657 player, class_1799 stack, class_2680 state) {
        return !player.method_5715() && class_1890.method_60142((class_1799)stack, ModEnchantmentEffectComponentTypes.FELL_TREES) && state.method_26164(class_3481.field_15475) && player.method_7305(state);
    }

    public static boolean isValid(List<class_2338> tree, class_1799 stack) {
        if (!stack.method_7963() || stack.method_7919() + tree.size() <= stack.method_7936()) {
            return tree.size() > 1 && tree.size() <= ModConfig.maxFellTreesBlocks && FellTreesEvent.isWithinHorizontalBounds(tree);
        }
        return false;
    }

    public record Entry(class_1657 player, List<class_2338> tree) {
        @Nullable
        public static Entry get(class_1657 player) {
            for (Entry entry : ENTRIES) {
                if (entry.player != player) continue;
                return entry;
            }
            return null;
        }
    }

    public static class FellTree
    implements PlayerBlockBreakEvents.Before {
        public boolean beforeBlockBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity) {
            Entry entry;
            class_1799 stack = player.method_6047();
            if (FellTreesEvent.canActivate(player, stack, state) && (entry = Entry.get(player)) != null && FellTreesEvent.isValid(entry.tree(), stack)) {
                entry.tree().sort(Comparator.comparingInt(class_2382::method_10264).reversed());
                ((FellTreesComponent)ModWorldComponents.FELL_TREES.get((Object)world)).addTree(FellTreesComponent.Tree.of(entry.tree(), pos, stack));
                ENTRIES.remove(entry);
                stack.method_7970(entry.tree().size(), (class_1309)player, class_1304.field_6173);
                return false;
            }
            return true;
        }
    }

    public static class BreakSpeed
    implements ModifyBlockBreakingSpeedEvent {
        public float modify(float breakSpeed, class_1657 player, class_2680 state, class_1922 world, class_2338 pos) {
            if (FellTreesEvent.canActivate(player, player.method_6047(), state)) {
                Entry entry = Entry.get(player);
                if (entry == null) {
                    entry = new Entry(player, FellTreesEvent.gatherTree(new ArrayList<class_2338>(), world, new class_2338.class_2339().method_10101((class_2382)pos), state.method_26204()));
                    ENTRIES.add(entry);
                }
                if (FellTreesEvent.isValid(entry.tree(), player.method_6047())) {
                    float fellTreesSpeed = EnchancementUtil.getValue(ModEnchantmentEffectComponentTypes.FELL_TREES, player.method_59922(), player.method_6047(), 0.0f);
                    return class_3532.method_16439((float)Math.min(1.0f, (float)entry.tree().size() / 32.0f), (float)fellTreesSpeed, (float)(fellTreesSpeed * 0.05f));
                }
            }
            return 1.0f;
        }
    }
}

