/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.event.enchantmenteffectcomponenttype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import moriyashiine.enchancement.common.ModConfig;
import moriyashiine.enchancement.common.init.ModEnchantmentEffectComponentTypes;
import moriyashiine.enchancement.common.init.ModSoundEvents;
import moriyashiine.enchancement.common.tag.ModBlockTags;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import moriyashiine.strawberrylib.api.event.ModifyBlockBreakingSpeedEvent;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class MineOreVeinsEvent {
    public static final Map<class_2248, class_2248> BASE_BLOCK_MAP = new HashMap<class_2248, class_2248>();

    public static Set<class_2338> gatherOres(Set<class_2338> ores, class_1937 world, class_2338.class_2339 pos, class_2248 original) {
        if (ores.size() < ModConfig.maxMineOreVeinsBlocks) {
            int originalX = pos.method_10263();
            int originalY = pos.method_10264();
            int originalZ = pos.method_10260();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        class_2680 state;
                        if (!world.method_8621().method_11952((class_2338)pos.method_10103(originalX + x, originalY + y, originalZ + z)) || !(state = world.method_8320((class_2338)pos)).method_26164(ConventionalBlockTags.ORES) || ores.contains(pos) || state.method_26204() != original) continue;
                        ores.add(pos.method_10062());
                        MineOreVeinsEvent.gatherOres(ores, world, pos, original);
                    }
                }
            }
        }
        return ores;
    }

    public static boolean canActivate(class_1657 player, class_1799 stack, class_2680 state) {
        return !player.method_5715() && class_1890.method_60142((class_1799)stack, ModEnchantmentEffectComponentTypes.MINE_ORE_VEINS) && state.method_26164(ConventionalBlockTags.ORES) && player.method_7305(state);
    }

    public static boolean isValid(Set<class_2338> ores, class_1799 stack) {
        if (!stack.method_7963() || stack.method_7919() + ores.size() <= stack.method_7936()) {
            return !ores.isEmpty() && ores.size() <= ModConfig.maxMineOreVeinsBlocks;
        }
        return false;
    }

    private static class_2248 getBaseBlock(class_2680 state) {
        class_2248 baseBlock = BASE_BLOCK_MAP.get(state.method_26204());
        if (baseBlock != null) {
            return baseBlock;
        }
        if (state.method_26164(ModBlockTags.NETHER_ORES)) {
            return class_2246.field_10515;
        }
        if (state.method_26164(ModBlockTags.END_ORES)) {
            return class_2246.field_10471;
        }
        if (state.method_26164(ConventionalBlockTags.ORES_IN_GROUND_DEEPSLATE)) {
            return class_2246.field_28888;
        }
        return class_2246.field_10340;
    }

    public static class MineOres
    implements PlayerBlockBreakEvents.Before {
        public boolean beforeBlockBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity) {
            Set<class_2338> ores;
            class_1799 stack = player.method_6047();
            if (MineOreVeinsEvent.canActivate(player, stack, state) && MineOreVeinsEvent.isValid(ores = MineOreVeinsEvent.gatherOres(new HashSet<class_2338>(), world, new class_2338.class_2339().method_10101((class_2382)pos), state.method_26204()), stack)) {
                class_2680 replace = MineOreVeinsEvent.getBaseBlock(state).method_9564();
                ArrayList drops = new ArrayList();
                ores.forEach(ore -> {
                    class_2680 oreState = world.method_8320(ore);
                    drops.addAll(class_2248.method_9609((class_2680)oreState, (class_3218)((class_3218)world), (class_2338)ore, (class_2586)world.method_8321(ore), (class_1297)player, (class_1799)stack));
                    oreState.method_26180((class_3218)world, player.method_24515(), stack, true);
                    world.method_22352(ore, false);
                    world.method_8501(ore, replace);
                });
                world.method_8396(null, pos, ModSoundEvents.BLOCK_ORE_EXTRACT, class_3419.field_15245, 1.0f, 1.0f);
                if (!drops.isEmpty()) {
                    EnchancementUtil.mergeItemEntities(drops.stream().map(drop -> new class_1542(world, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), drop)).collect(Collectors.toList())).forEach(arg_0 -> ((class_1937)world).method_8649(arg_0));
                }
                stack.method_7970(ores.size(), (class_1309)player, class_1304.field_6173);
                return false;
            }
            return true;
        }
    }

    public static class BreakSpeed
    implements ModifyBlockBreakingSpeedEvent {
        public float modify(float breakSpeed, class_1657 player, class_2680 state, class_1922 world, class_2338 pos) {
            Set<class_2338> ores;
            if (MineOreVeinsEvent.canActivate(player, player.method_6047(), state) && MineOreVeinsEvent.isValid(ores = MineOreVeinsEvent.gatherOres(new HashSet<class_2338>(), player.method_73183(), new class_2338.class_2339().method_10101((class_2382)pos), state.method_26204()), player.method_6047())) {
                float mineOreVeinsSpeed = EnchancementUtil.getValue(ModEnchantmentEffectComponentTypes.MINE_ORE_VEINS, player.method_59922(), player.method_6047(), 0.0f);
                return class_3532.method_16439((float)Math.min(1.0f, (float)ores.size() / 12.0f), (float)mineOreVeinsSpeed, (float)(mineOreVeinsSpeed * 0.1f));
            }
            return 1.0f;
        }
    }
}

