/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import moriyashiine.enchancement.common.ModConfig;
import moriyashiine.enchancement.common.component.entity.LightningDashComponent;
import moriyashiine.enchancement.common.component.entity.OwnedTridentComponent;
import moriyashiine.enchancement.common.init.ModEnchantmentEffectComponentTypes;
import moriyashiine.enchancement.common.init.ModEnchantments;
import moriyashiine.enchancement.common.init.ModEntityComponents;
import moriyashiine.enchancement.common.tag.ModItemTags;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_10192;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1685;
import net.minecraft.class_1740;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7417;
import net.minecraft.class_7876;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9698;
import net.minecraft.class_9723;
import net.minecraft.class_9851;
import net.minecraft.class_9886;
import net.minecraft.class_9889;
import net.minecraft.class_9890;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;

public class EnchancementUtil {
    public static class_7876<?> ENCHANTMENT_REGISTRY_OWNER = null;
    public static final List<class_6880.class_6883<class_1887>> ENCHANTMENTS = new ArrayList<class_6880.class_6883<class_1887>>();
    public static class_5819 SERVER_RANDOM = null;
    public static final Map<class_1887, Integer> ORIGINAL_MAX_LEVELS = new ConcurrentHashMap<class_1887, Integer>();
    public static final Map<class_6862<class_1792>, class_9851> VANILLA_ENCHANTMENT_STRENGTH_TAGS = new Object2ObjectArrayMap();
    public static class_1799 cachedApplyStack;

    public static List<class_1542> mergeItemEntities(List<class_1542> drops) {
        for (int i = drops.size() - 1; i >= 0; --i) {
            if (i >= drops.size() - 1) continue;
            class_1542 itemEntity = drops.get(i);
            class_1542 other = drops.get(i + 1);
            itemEntity.method_6972(other);
            if (itemEntity.method_6983().method_7960()) {
                drops.remove(i);
            }
            if (!other.method_6983().method_7960()) continue;
            drops.remove(i + 1);
        }
        return drops;
    }

    public static String getTranslationKey(class_6880<class_1887> enchantment) {
        class_7417 class_74172 = ((class_1887)enchantment.comp_349()).comp_2686().method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatable = (class_2588)class_74172;
            return translatable.method_11022();
        }
        return ((class_1887)enchantment.comp_349()).comp_2686().getString();
    }

    @Nullable
    public static class_6880<class_1887> getRandomEnchantment(class_1799 stack, class_6862<class_1887> checkedTag, @Nullable class_5819 random) {
        ArrayList<class_6880> enchantments = new ArrayList<class_6880>();
        for (class_6880 class_68802 : ENCHANTMENTS) {
            if (!class_68802.method_40220(checkedTag) || !stack.method_31574(class_1802.field_8529) && !stack.method_31574(class_1802.field_8598) && !stack.canBeEnchantedWith(class_68802, EnchantingContext.ACCEPTABLE)) continue;
            enchantments.add(class_68802);
        }
        if (!enchantments.isEmpty()) {
            if (random == null) {
                random = SERVER_RANDOM;
            }
            return (class_6880)enchantments.get(random.method_43048(enchantments.size()));
        }
        return null;
    }

    public static boolean isEnchantmentAllowed(class_6880<class_1887> enchantment) {
        if (enchantment.method_40230().isPresent()) {
            return EnchancementUtil.isEnchantmentAllowed(((class_5321)enchantment.method_40230().get()).method_29177());
        }
        return false;
    }

    public static boolean isEnchantmentAllowed(class_2960 identifier) {
        if (identifier.equals((Object)ModEnchantments.EMPTY_KEY.method_29177())) {
            return false;
        }
        if (ModConfig.invertedList) {
            return ModConfig.disallowedEnchantments.contains(identifier.toString());
        }
        return !ModConfig.disallowedEnchantments.contains(identifier.toString());
    }

    public static boolean hasWeakEnchantments(class_1799 stack) {
        if (stack.method_31573(ModItemTags.STRONGLY_ENCHANTED)) {
            return false;
        }
        if (stack.method_31573(ModItemTags.WEAKLY_ENCHANTED)) {
            return true;
        }
        int enchantmentValue = EnchancementUtil.getEnchantmentValue(stack);
        if (enchantmentValue > 0) {
            class_9851 triState;
            class_6862 repairTag;
            class_6862 class_68622 = repairTag = stack.method_57826(class_9334.field_53696) ? (class_6862)((class_9890)stack.method_58694(class_9334.field_53696)).comp_2939().method_45925().orElse(null) : null;
            if (repairTag != null && (triState = VANILLA_ENCHANTMENT_STRENGTH_TAGS.getOrDefault(repairTag, class_9851.field_52396)) != class_9851.field_52396) {
                return triState.method_61348(false);
            }
            return enchantmentValue <= (stack.method_31573(class_3489.field_48303) ? class_1740.field_7892.comp_3167() : class_9886.field_52587.comp_2934());
        }
        return false;
    }

    public static int alterLevel(class_1799 stack, class_6880<class_1887> enchantment) {
        if (ModConfig.singleLevelMode && enchantment.method_40225(class_1893.field_50159)) {
            return 1;
        }
        return EnchancementUtil.getModifiedMaxLevel(stack, EnchancementUtil.getOriginalMaxLevel(enchantment));
    }

    public static int getEnchantmentValue(class_1799 stack) {
        if (stack.method_57826(class_9334.field_53695)) {
            int value = ((class_9889)stack.method_58694(class_9334.field_53695)).comp_2938();
            if (value == 1) {
                value = (stack.method_31573(class_3489.field_48303) ? class_1740.field_7892.comp_3167() : class_9886.field_52587.comp_2934()) + 1;
            }
            return value;
        }
        return 0;
    }

    public static int getModifiedMaxLevel(class_1799 stack, int maxLevel) {
        if (EnchancementUtil.hasWeakEnchantments(stack)) {
            return class_3532.method_15386((float)((float)maxLevel / 2.0f));
        }
        return maxLevel;
    }

    public static int getOriginalMaxLevel(class_6880<class_1887> enchantment) {
        return ORIGINAL_MAX_LEVELS.getOrDefault(enchantment.comp_349(), ((class_1887)enchantment.comp_349()).method_8183());
    }

    public static boolean isDefaultEnchantment(class_1799 stack, class_6880<class_1887> enchantment) {
        class_9304 defaultEnchantments = (class_9304)stack.method_7909().method_57347().method_58695(class_9334.field_49633, (Object)class_9304.field_49385);
        for (class_6880 foundEnchantment : defaultEnchantments.method_57534()) {
            int level;
            if (foundEnchantment != enchantment || (level = ModConfig.singleLevelMode ? 1 : class_1890.method_8225(enchantment, (class_1799)stack)) != defaultEnchantments.method_57536(enchantment)) continue;
            return true;
        }
        return false;
    }

    public static boolean exceedsLimit(class_1799 stack, int size) {
        if (ModConfig.enchantmentLimit == 0) {
            return false;
        }
        for (class_6880 enchantment : class_1890.method_57532((class_1799)stack).method_57534()) {
            if (!EnchancementUtil.isDefaultEnchantment(stack, (class_6880<class_1887>)enchantment)) continue;
            --size;
        }
        return size > ModConfig.enchantmentLimit;
    }

    public static boolean isUnbreakable(class_1799 stack) {
        return ModConfig.disableDurability && !stack.method_7960() && stack.method_57826(class_9334.field_50072) && !stack.method_31573(ModItemTags.RETAINS_DURABILITY);
    }

    public static boolean insertToCorrectTridentSlot(class_1665 projectile, class_1661 inventory, class_1799 stack) {
        int slot;
        if (ModConfig.rebalanceEquipment && projectile instanceof class_1685 && (slot = ((OwnedTridentComponent)ModEntityComponents.OWNED_TRIDENT.get((Object)projectile)).getSlot()) >= 0 && slot < inventory.method_5439() && inventory.method_5438(slot).method_7960()) {
            inventory.method_5447(slot, stack);
            return true;
        }
        return false;
    }

    public static int getTridentChargeTime() {
        return 10 * (ModConfig.rebalanceEquipment ? 2 : 1);
    }

    public static List<class_1799> getArmorItems(class_1309 entity) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (class_1304 slot : class_1304.values()) {
            if (!slot.method_46643()) continue;
            stacks.add(entity.method_6118(slot));
        }
        return stacks;
    }

    public static List<class_1799> getHeldItems(class_1309 entity) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        for (class_1304 slot : class_1304.values()) {
            if (slot.method_5925() != class_1304.class_1305.field_6177) continue;
            stacks.add(entity.method_6118(slot));
        }
        return stacks;
    }

    public static boolean isBodyArmor(class_1799 stack) {
        return stack.method_57826(class_9334.field_54196) && ((class_10192)stack.method_58694(class_9334.field_54196)).comp_3174() == class_1304.field_48824;
    }

    public static int getFlooredHealth(class_1309 living) {
        float percentage = living.method_6032() / living.method_6063();
        return (int)Math.floor((double)(percentage * 10.0f) + 0.5);
    }

    public static void resetFallDistance(class_1297 entity) {
        entity.method_38785();
        ModEntityComponents.LIGHTNING_DASH.maybeGet((Object)entity).ifPresent(LightningDashComponent::cancel);
    }

    public static boolean hasAnyEnchantmentsIn(class_1297 entity, class_6862<class_1887> tag) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            for (class_1799 stack : EnchancementUtil.getArmorItems(living)) {
                if (!class_1890.method_60138((class_1799)stack, tag)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAnyEnchantmentsWith(class_1297 entity, class_9331<?> componentType) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            for (class_1799 stack : EnchancementUtil.getArmorItems(living)) {
                if (!class_1890.method_60142((class_1799)stack, componentType)) continue;
                return true;
            }
        }
        return false;
    }

    public static float getValue(class_9331<class_9723> component, class_5819 random, class_1799 stack, float base) {
        MutableFloat mutableFloat = new MutableFloat(base);
        class_1890.method_8220((class_1799)stack, (enchantment, level) -> ((class_1887)enchantment.comp_349()).method_60506(component, random, level, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static float getValue(class_9331<class_9723> component, class_1309 entity, float base) {
        MutableFloat mutableFloat = new MutableFloat(base);
        for (class_1799 stack : EnchancementUtil.getArmorItems(entity)) {
            class_1890.method_8220((class_1799)stack, (enchantment, level) -> ((class_1887)enchantment.comp_349()).method_60506(component, entity.method_59922(), level, mutableFloat));
        }
        return mutableFloat.floatValue();
    }

    public static float getValue(class_9331<List<class_9698<class_9723>>> component, class_3218 world, class_1799 stack, float base) {
        MutableFloat mutableFloat = new MutableFloat(base);
        class_1890.method_8220((class_1799)stack, (enchantment, level) -> ((class_1887)enchantment.comp_349()).method_60037(component, world, level, stack, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static boolean shouldFluidWalk(class_1297 entity) {
        return !SLibUtils.isCrouching((class_1297)entity, (boolean)true) && EnchancementUtil.hasAnyEnchantmentsWith(entity, ModEnchantmentEffectComponentTypes.FLUID_WALKING);
    }

    static {
        VANILLA_ENCHANTMENT_STRENGTH_TAGS.put((class_6862<class_1792>)class_3489.field_54059, class_9851.field_52394);
        VANILLA_ENCHANTMENT_STRENGTH_TAGS.put((class_6862<class_1792>)class_3489.field_61217, class_9851.field_52394);
        VANILLA_ENCHANTMENT_STRENGTH_TAGS.put((class_6862<class_1792>)class_3489.field_54060, class_9851.field_52395);
        VANILLA_ENCHANTMENT_STRENGTH_TAGS.put((class_6862<class_1792>)class_3489.field_54061, class_9851.field_52394);
        VANILLA_ENCHANTMENT_STRENGTH_TAGS.put((class_6862<class_1792>)class_3489.field_54062, class_9851.field_52395);
        VANILLA_ENCHANTMENT_STRENGTH_TAGS.put((class_6862<class_1792>)class_3489.field_54063, class_9851.field_52395);
        VANILLA_ENCHANTMENT_STRENGTH_TAGS.put((class_6862<class_1792>)class_3489.field_54064, class_9851.field_52395);
        VANILLA_ENCHANTMENT_STRENGTH_TAGS.put((class_6862<class_1792>)class_3489.field_54065, class_9851.field_52395);
        VANILLA_ENCHANTMENT_STRENGTH_TAGS.put((class_6862<class_1792>)class_3489.field_54066, class_9851.field_52395);
        VANILLA_ENCHANTMENT_STRENGTH_TAGS.put((class_6862<class_1792>)class_3489.field_52381, class_9851.field_52394);
        VANILLA_ENCHANTMENT_STRENGTH_TAGS.put((class_6862<class_1792>)class_3489.field_23802, class_9851.field_52394);
        VANILLA_ENCHANTMENT_STRENGTH_TAGS.put((class_6862<class_1792>)class_3489.field_61216, class_9851.field_52394);
        VANILLA_ENCHANTMENT_STRENGTH_TAGS.put((class_6862<class_1792>)class_3489.field_52382, class_9851.field_52394);
        VANILLA_ENCHANTMENT_STRENGTH_TAGS.put((class_6862<class_1792>)class_3489.field_52385, class_9851.field_52395);
        VANILLA_ENCHANTMENT_STRENGTH_TAGS.put((class_6862<class_1792>)class_3489.field_52386, class_9851.field_52395);
        VANILLA_ENCHANTMENT_STRENGTH_TAGS.put((class_6862<class_1792>)class_3489.field_52387, class_9851.field_52395);
        cachedApplyStack = null;
    }
}

