/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.client.gui.tooltip;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import moriyashiine.enchancement.client.event.config.EnchantmentDescriptionsEvent;
import moriyashiine.enchancement.common.Enchancement;
import moriyashiine.enchancement.common.ModConfig;
import moriyashiine.enchancement.common.util.config.OverhaulMode;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_6880;
import net.minecraft.class_8000;
import net.minecraft.class_9304;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2ic;

public final class StoredEnchantmentsTooltipComponent
implements class_5684,
class_5632 {
    private static final Map<class_1799, class_2960> TEXTURE_MAP = new LinkedHashMap<class_1799, class_2960>();
    private static final Map<class_6880<class_1887>, List<class_2960>> ICON_CACHE = new Reference2ObjectOpenHashMap();
    private final class_9304 enchantments;
    private int width = 0;
    private int height = 0;

    public StoredEnchantmentsTooltipComponent(class_9304 enchantments) {
        this.enchantments = enchantments;
    }

    public static void clearIconCache() {
        ICON_CACHE.clear();
    }

    public int method_32664(class_327 textRenderer) {
        return this.width;
    }

    public int method_32661(class_327 textRenderer) {
        return this.height;
    }

    public void cacheDimensions(class_327 textRenderer, int x, int y, class_332 context, @Nullable class_8000 positioner) {
        this.height = 0;
        this.width = 0;
        int screenWidth = context.method_51421();
        for (class_6880 enchantment : this.enchantments.method_57534()) {
            class_2561 name = class_1887.method_8179((class_6880)enchantment, (int)this.enchantments.method_57536(enchantment));
            this.width = Math.max(this.width, (StoredEnchantmentsTooltipComponent.getIcons((class_6880<class_1887>)enchantment).isEmpty() ? 0 : 18) + textRenderer.method_27525((class_5348)name));
            this.height += 18;
            List<class_2561> description = EnchantmentDescriptionsEvent.getDescription(name, (class_6880<class_1887>)enchantment);
            if (description == null) continue;
            for (class_2561 text : description) {
                this.width = Math.max(this.width, textRenderer.method_27525((class_5348)text));
                this.height += 9;
            }
        }
        if (positioner != null) {
            Vector2ic pos = positioner.method_47944(screenWidth, context.method_51443(), x, y, this.width, this.height);
            this.cacheDimensions(textRenderer, pos.x(), pos.y(), context, null);
        }
    }

    public void method_32665(class_332 context, class_327 textRenderer, int x, int y) {
        for (class_6880<class_1887> enchantment : this.getSortedEnchantments()) {
            boolean hasIcon = StoredEnchantmentsTooltipComponent.renderIcons(enchantment, x, y, context);
            class_2561 name = class_1887.method_8179(enchantment, (int)this.enchantments.method_57536(enchantment));
            context.method_51439(textRenderer, name, x + (hasIcon ? 18 : 0), y + 5, -1, true);
            y += 18;
            List<class_2561> description = EnchantmentDescriptionsEvent.getDescription(name, enchantment);
            if (description == null) continue;
            for (class_2561 text : description) {
                context.method_51439(textRenderer, text, x, y, -1, true);
                y += 9;
            }
        }
    }

    private List<class_6880<class_1887>> getSortedEnchantments() {
        ArrayList<class_6880<class_1887>> enchantments = new ArrayList<class_6880<class_1887>>(this.enchantments.method_57534());
        enchantments.sort((e1, e2) -> {
            if (e1.method_40230().isPresent()) {
                if (e2.method_40230().isPresent()) {
                    return ((class_5321)e1.method_40230().get()).method_29177().method_12833(((class_5321)e2.method_40230().get()).method_29177());
                }
                return 1;
            }
            return 0;
        });
        return enchantments;
    }

    private static List<class_2960> getIcons(class_6880<class_1887> registryEntry) {
        return ICON_CACHE.computeIfAbsent(registryEntry, enchantment -> {
            HashSet<class_2960> icons = new HashSet<class_2960>();
            for (Map.Entry<class_1799, class_2960> entry : TEXTURE_MAP.entrySet()) {
                if (ModConfig.overhaulEnchanting == OverhaulMode.CHISELED && !entry.getKey().method_7923() || !entry.getKey().canBeEnchantedWith(enchantment, EnchantingContext.ACCEPTABLE)) continue;
                icons.add(entry.getValue());
            }
            return List.copyOf(icons);
        });
    }

    private static boolean renderIcons(class_6880<class_1887> enchantment, int x, int y, class_332 context) {
        List<class_2960> icons = StoredEnchantmentsTooltipComponent.getIcons(enchantment);
        if (icons.isEmpty()) {
            return false;
        }
        int size = icons.size();
        if (size == 1) {
            context.method_52706(class_10799.field_56883, icons.getFirst(), x, y, 16, 16);
            return true;
        }
        double time = (double)class_156.method_658() / 1500.0;
        double i = class_3532.method_15367((double)time, (double)size);
        float alpha = (float)(Math.min(class_3532.method_15385((double)i), 0.25) / 0.25);
        context.method_52707(class_10799.field_56883, icons.get((int)i), x, y, 16, 16, class_9848.method_71346((float)alpha, (int)-1));
        if (alpha < 1.0f) {
            class_2960 icon = i - 1.0 < 0.0 ? icons.getLast() : icons.get((int)(i - 1.0));
            context.method_52707(class_10799.field_56883, icon, x, y, 16, 16, class_9848.method_71346((float)(1.0f - alpha), (int)-1));
        }
        return true;
    }

    static {
        TEXTURE_MAP.put(class_1802.field_8743.method_7854(), class_2960.method_60654((String)"container/slot/helmet"));
        TEXTURE_MAP.put(class_1802.field_8523.method_7854(), class_2960.method_60654((String)"container/slot/chestplate"));
        TEXTURE_MAP.put(class_1802.field_8396.method_7854(), class_2960.method_60654((String)"container/slot/leggings"));
        TEXTURE_MAP.put(class_1802.field_8660.method_7854(), class_2960.method_60654((String)"container/slot/boots"));
        TEXTURE_MAP.put(class_1802.field_8578.method_7854(), Enchancement.id("container/slot/animal"));
        TEXTURE_MAP.put(class_1802.field_8255.method_7854(), class_2960.method_60654((String)"container/slot/shield"));
        TEXTURE_MAP.put(class_1802.field_8371.method_7854(), class_2960.method_60654((String)"container/slot/sword"));
        TEXTURE_MAP.put(class_1802.field_8102.method_7854(), Enchancement.id("container/slot/bow"));
        TEXTURE_MAP.put(class_1802.field_8399.method_7854(), Enchancement.id("container/slot/crossbow"));
        TEXTURE_MAP.put(class_1802.field_8547.method_7854(), Enchancement.id("container/slot/trident"));
        TEXTURE_MAP.put(class_1802.field_49814.method_7854(), Enchancement.id("container/slot/mace"));
        TEXTURE_MAP.put(class_1802.field_8403.method_7854(), class_2960.method_60654((String)"container/slot/pickaxe"));
        TEXTURE_MAP.put(class_1802.field_8475.method_7854(), class_2960.method_60654((String)"container/slot/axe"));
        TEXTURE_MAP.put(class_1802.field_8699.method_7854(), class_2960.method_60654((String)"container/slot/shovel"));
        TEXTURE_MAP.put(class_1802.field_8609.method_7854(), class_2960.method_60654((String)"container/slot/hoe"));
        TEXTURE_MAP.put(class_1802.field_8378.method_7854(), Enchancement.id("container/slot/fishing_rod"));
        TEXTURE_MAP.put(class_1802.field_8255.method_7854(), class_2960.method_60654((String)"container/slot/shield"));
        TEXTURE_MAP.put(class_1802.field_8175.method_7854(), Enchancement.id("container/slot/saddle"));
        TEXTURE_MAP.put(class_1802.field_8833.method_7854(), Enchancement.id("container/slot/elytra"));
        TEXTURE_MAP.put(class_1802.field_8884.method_7854(), Enchancement.id("container/slot/flint_and_steel"));
        TEXTURE_MAP.put(class_1802.field_8868.method_7854(), Enchancement.id("container/slot/shears"));
        TEXTURE_MAP.put(class_1802.field_42716.method_7854(), Enchancement.id("container/slot/brush"));
        TEXTURE_MAP.put(class_1802.field_8251.method_7854(), Enchancement.id("container/slot/compass"));
    }
}

