/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import moriyashiine.enchancement.common.enchantment.effect.GlideEffect;
import moriyashiine.enchancement.common.payload.GlideC2SPayload;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import moriyashiine.strawberrylib.api.module.SLibClientUtils;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import moriyashiine.strawberrylib.api.objects.enums.ParticleAnchor;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class GlideComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1309 obj;
    private boolean gliding = false;
    private int airTicks = 0;
    private int minDuration = 0;

    public GlideComponent(class_1309 obj) {
        this.obj = obj;
    }

    public void readData(class_11368 readView) {
        this.gliding = readView.method_71433("Gliding", false);
        this.airTicks = readView.method_71424("AirTicks", 0);
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71472("Gliding", this.gliding);
        writeView.method_71465("AirTicks", this.airTicks);
    }

    public void tick() {
        this.minDuration = GlideEffect.getMinDuration(this.obj);
        if (this.canGlide()) {
            if (this.gliding) {
                EnchancementUtil.resetFallDistance((class_1297)this.obj);
            }
            if (this.obj.method_24828()) {
                this.airTicks = 0;
            } else if (this.airTicks < this.minDuration || this.obj.field_6282) {
                ++this.airTicks;
            }
        } else {
            this.gliding = false;
            this.airTicks = 0;
        }
    }

    public void clientTick() {
        boolean shouldBeGliding;
        this.tick();
        boolean bl = shouldBeGliding = this.obj.field_6282 && this.airTicks >= this.minDuration && this.airTicks <= GlideEffect.getMaxDuration(this.obj) && this.canGlide();
        if (this.gliding != shouldBeGliding && SLibClientUtils.isHost((class_1297)this.obj)) {
            this.gliding = shouldBeGliding;
            GlideC2SPayload.send(this.gliding);
        }
        if (this.isGliding()) {
            SLibClientUtils.addParticles((class_1297)this.obj, (class_2396)class_2398.field_50252, (int)4, (ParticleAnchor)ParticleAnchor.BASE);
        }
    }

    public boolean isGliding() {
        return this.gliding;
    }

    public void setGliding(boolean gliding) {
        this.gliding = gliding;
    }

    public boolean canGlide() {
        return this.minDuration > 0 && SLibUtils.isGroundedOrAirborne((class_1309)this.obj);
    }
}

