/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import java.util.List;
import moriyashiine.enchancement.client.payload.AddLightningDashParticlesPayload;
import moriyashiine.enchancement.common.component.entity.UsingMaceComponent;
import moriyashiine.enchancement.common.enchantment.effect.LightningDashEffect;
import moriyashiine.enchancement.common.init.ModEntityComponents;
import moriyashiine.enchancement.common.init.ModSoundEvents;
import moriyashiine.enchancement.common.particle.SparkParticleEffect;
import moriyashiine.strawberrylib.api.module.SLibClientUtils;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class LightningDashComponent
extends UsingMaceComponent
implements CommonTickingComponent {
    private final class_1657 obj;
    private double cachedHeight = 0.0;
    private int floatTicks = 0;
    private int smashTicks = 0;
    private int ticksUsing = 0;
    private double nextTickFallDistance = 0.0;

    public LightningDashComponent(class_1657 obj) {
        this.obj = obj;
    }

    @Override
    public void readData(class_11368 readView) {
        super.readData(readView);
        this.floatTicks = readView.method_71424("FloatTicks", 0);
        this.smashTicks = readView.method_71424("SmashTicks", 0);
    }

    @Override
    public void writeData(class_11372 writeView) {
        super.writeData(writeView);
        writeView.method_71465("FloatTicks", this.floatTicks);
        writeView.method_71465("SmashTicks", this.smashTicks);
    }

    public void tick() {
        boolean hasLightningDash;
        boolean bl = hasLightningDash = LightningDashEffect.getFloatTime(this.obj.method_59922(), this.obj.method_6047()) != 0;
        if ((this.isFloating() || this.isSmashing()) && !hasLightningDash) {
            this.cancel();
        }
        if (this.isFloating()) {
            --this.floatTicks;
            this.obj.method_38785();
            this.obj.method_18799(this.obj.method_18798().method_1021(0.9));
            this.obj.method_32876((class_6880)class_5712.field_45148);
            if (this.obj.field_6252 && this.obj.method_36455() > -15.0f) {
                this.cachedHeight = this.obj.method_23318();
                this.smashTicks = 30;
                this.floatTicks = 0;
                this.obj.method_18799(this.obj.method_5720().method_1021((double)LightningDashEffect.getSmashStrength(this.obj.method_59922(), this.obj.method_6047())));
                this.obj.method_5783(ModSoundEvents.ENTITY_GENERIC_ZAP, 2.0f, 1.0f);
            }
        }
        if (this.isSmashing()) {
            --this.smashTicks;
            if (this.obj.method_24828()) {
                if (this.smashTicks > 1) {
                    this.smashTicks = 1;
                }
                if (this.smashTicks == 1) {
                    this.obj.method_5783(class_3417.field_49924, 1.0f, 1.0f);
                }
            }
        }
        if (hasLightningDash && class_1799.method_7973((class_1799)this.obj.method_6030(), (class_1799)this.obj.method_6047())) {
            if (this.ticksUsing % 18 == 0) {
                this.obj.method_5783(ModSoundEvents.ITEM_GENERIC_WHOOSH, 0.5f, 1.0f);
            }
            ++this.ticksUsing;
        } else {
            this.ticksUsing = 0;
        }
        if (this.nextTickFallDistance != 0.0) {
            this.obj.method_5747(this.nextTickFallDistance, 1.0f, this.obj.method_48923().method_48827());
            this.nextTickFallDistance = 0.0;
        }
    }

    public void serverTick() {
        this.tick();
        if (this.isFloating() && !SLibUtils.isSufficientlyHigh((class_1297)this.obj, (double)0.25)) {
            this.cancel();
            this.sync();
        }
        if (this.smashTicks == 1 && this.obj.method_24828()) {
            class_3218 world = (class_3218)this.obj.method_73183();
            PlayerLookup.tracking((class_1297)this.obj).forEach(foundPlayer -> AddLightningDashParticlesPayload.send(foundPlayer, (class_1297)this.obj));
            this.obj.field_6017 = (float)Math.max(0.0, this.cachedHeight - this.obj.method_23318());
            float base = (float)this.obj.method_45325(class_5134.field_23721);
            boolean[] hurt = new boolean[]{true};
            this.getNearby(3).forEach(entity -> {
                class_1282 class_12822;
                class_1657 patt0$temp = this.obj;
                if (patt0$temp instanceof class_1657) {
                    class_1657 player = patt0$temp;
                    class_12822 = entity.method_48923().method_48802(player);
                } else {
                    class_12822 = entity.method_48923().method_48812((class_1309)this.obj);
                }
                class_1282 source = class_12822;
                float damage = class_1890.method_60120((class_3218)world, (class_1799)this.obj.method_6047(), (class_1297)entity, (class_1282)source, (float)base) + this.obj.method_6047().method_7909().method_58403((class_1297)entity, base, source);
                if (entity.method_64397(world, source, damage * LightningDashEffect.getSmashDamageMultiplier(this.obj.method_59922(), this.obj.method_6047()))) {
                    entity.method_6005(1.5, this.obj.method_23317() - entity.method_23317(), this.obj.method_23321() - entity.method_23321());
                    hurt[0] = false;
                }
            });
            if (hurt[0] && !this.obj.method_5799()) {
                this.nextTickFallDistance = this.obj.field_6017;
            }
            this.obj.field_6017 = 0.0;
        }
    }

    public void clientTick() {
        this.tick();
        if (this.isFloating() && SLibClientUtils.shouldAddParticles((class_1297)this.obj)) {
            for (int i = 0; i <= 4; ++i) {
                this.obj.method_73183().method_8406((class_2394)new SparkParticleEffect(this.obj.method_73189().method_49272(this.obj.method_59922(), 1.0f)), this.obj.method_23322(1.0), this.obj.method_23319(), this.obj.method_23325(1.0), 0.0, 0.0, 0.0);
            }
        }
        if (this.smashTicks == 1 && this.obj.method_24828()) {
            AddLightningDashParticlesPayload.addParticles((class_1297)this.obj);
        }
    }

    public void sync() {
        ModEntityComponents.LIGHTNING_DASH.sync((Object)this.obj);
    }

    public void setFloatTicks(int floatTicks) {
        this.floatTicks = floatTicks;
    }

    public boolean isFloating() {
        return this.floatTicks > 0;
    }

    public boolean isSmashing() {
        return this.smashTicks > 0;
    }

    public void cancel() {
        this.smashTicks = 0;
        this.floatTicks = 0;
    }

    private List<class_1309> getNearby(int range) {
        return this.obj.method_73183().method_8390(class_1309.class, new class_238(this.obj.method_23317() - 0.5 - (double)range, this.obj.method_23318() - 1.5, this.obj.method_23321() - 0.5 - (double)range, this.obj.method_23317() + 0.5 + (double)range, this.obj.method_23318() + 0.5 + (double)range, this.obj.method_23321() + 0.5 + (double)range), foundEntity -> foundEntity.method_5805() && foundEntity.method_5739((class_1297)this.obj) < 10.0f && SLibUtils.shouldHurt((class_1297)this.obj, (class_1297)foundEntity) && SLibUtils.canSee((class_1297)this.obj, (class_1297)foundEntity, (int)range));
    }
}

