/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import moriyashiine.enchancement.api.event.MultiplyMovementSpeedEvent;
import moriyashiine.enchancement.client.EnchancementClient;
import moriyashiine.enchancement.common.enchantment.effect.RotationBurstEffect;
import moriyashiine.enchancement.common.init.ModEntityComponents;
import moriyashiine.enchancement.common.init.ModSoundEvents;
import moriyashiine.enchancement.common.payload.RotationBurstPayload;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import moriyashiine.strawberrylib.api.module.SLibClientUtils;
import moriyashiine.strawberrylib.api.module.SLibUtils;
import moriyashiine.strawberrylib.api.objects.enums.ParticleAnchor;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class RotationBurstComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1657 obj;
    private boolean shouldRefresh = false;
    private int cooldown = 0;
    private int lastCooldown = 0;
    private int wavedashTicks = 0;
    private boolean hasRotationBurst = false;
    private boolean wasPressingKey = false;
    private int resetDelayTicks = 0;
    private int ticksPressingJump = 0;

    public RotationBurstComponent(class_1657 obj) {
        this.obj = obj;
    }

    public void readData(class_11368 readView) {
        this.shouldRefresh = readView.method_71433("ShouldRefresh", false);
        this.cooldown = readView.method_71424("Cooldown", 0);
        this.lastCooldown = readView.method_71424("LastCooldown", 0);
        this.wavedashTicks = readView.method_71424("WavedashTicks", 0);
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71472("ShouldRefresh", this.shouldRefresh);
        writeView.method_71465("Cooldown", this.cooldown);
        writeView.method_71465("LastCooldown", this.lastCooldown);
        writeView.method_71465("WavedashTicks", this.wavedashTicks);
    }

    public void tick() {
        int entityCooldown = RotationBurstEffect.getCooldown((class_1309)this.obj);
        boolean bl = this.hasRotationBurst = entityCooldown > 0;
        if (this.hasRotationBurst) {
            if (!this.shouldRefresh) {
                if (this.obj.method_24828()) {
                    this.shouldRefresh = true;
                }
            } else if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.wavedashTicks > 0) {
                --this.wavedashTicks;
            }
            if (this.resetDelayTicks > 0) {
                --this.resetDelayTicks;
            }
        } else {
            this.shouldRefresh = false;
            this.setCooldown(0);
            this.wavedashTicks = 0;
        }
    }

    public void clientTick() {
        this.tick();
        if (this.hasRotationBurst && !this.obj.method_7325() && SLibClientUtils.isHost((class_1297)this.obj)) {
            this.ticksPressingJump = this.obj.field_6282 ? Math.min(2, ++this.ticksPressingJump) : 0;
            boolean pressingKey = EnchancementClient.ROTATION_BURST_KEYBINDING.method_1434();
            if (pressingKey && !this.wasPressingKey && this.canUse()) {
                this.use();
                SLibClientUtils.addParticles((class_1297)this.obj, (class_2396)class_2398.field_11204, (int)8, (ParticleAnchor)ParticleAnchor.BODY);
                RotationBurstPayload.send();
            }
            this.wasPressingKey = pressingKey;
        } else {
            this.wasPressingKey = false;
            this.ticksPressingJump = 0;
        }
    }

    public void sync() {
        ModEntityComponents.ROTATION_BURST.sync((Object)this.obj);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
        this.lastCooldown = cooldown;
    }

    public int getLastCooldown() {
        return this.lastCooldown;
    }

    public boolean hasRotationBurst() {
        return this.hasRotationBurst;
    }

    public boolean shouldWavedash() {
        return this.ticksPressingJump < 2 && this.wavedashTicks > 0 && this.obj.method_24828();
    }

    public boolean canUse() {
        return Math.max(this.cooldown, this.resetDelayTicks) == 0 && !this.obj.method_24828() && SLibUtils.isGroundedOrAirborne((class_1309)this.obj);
    }

    public void use() {
        this.reset();
        this.wavedashTicks = RotationBurstEffect.getWavedashTicks((class_1309)this.obj);
        class_243 velocity = this.obj.method_5720().method_1029().method_1021((double)RotationBurstEffect.getStrength((class_1309)this.obj)).method_1021((double)MultiplyMovementSpeedEvent.getMovementMultiplier((class_1309)this.obj));
        this.obj.method_18800(velocity.method_10216(), velocity.method_10214(), velocity.method_10215());
        this.obj.method_5783(ModSoundEvents.ENTITY_GENERIC_DASH, 1.0f, 1.0f);
        this.obj.method_32876((class_6880)class_5712.field_45148);
        EnchancementUtil.resetFallDistance((class_1297)this.obj);
    }

    public void reset() {
        this.setCooldown(RotationBurstEffect.getCooldown((class_1309)this.obj));
        this.shouldRefresh = false;
    }

    public void markDelay() {
        this.resetDelayTicks = 3;
    }
}

