/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class FellTreesComponent
implements ServerTickingComponent {
    private final class_1937 obj;
    private final List<Tree> treesToCut = new ArrayList<Tree>();

    public FellTreesComponent(class_1937 obj) {
        this.obj = obj;
    }

    public void readData(class_11368 readView) {
        this.treesToCut.clear();
        for (Tree tree : readView.method_71426("TreesToCut", Tree.CODEC.listOf()).orElse(List.of())) {
            this.treesToCut.add(new Tree(new ArrayList<class_2338>(tree.logs), new ArrayList<class_1799>(tree.drops), tree.originalPos, tree.stack.method_7972()));
        }
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71468("TreesToCut", Tree.CODEC.listOf(), this.treesToCut);
    }

    public void serverTick() {
        for (int i = this.treesToCut.size() - 1; i >= 0; --i) {
            Tree tree = this.treesToCut.get(i);
            if (tree.logs.isEmpty()) {
                EnchancementUtil.mergeItemEntities(tree.drops.stream().map(drop -> new class_1542(this.obj, (double)tree.originalPos.method_10263() + 0.5, (double)tree.originalPos.method_10264() + 0.5, (double)tree.originalPos.method_10260() + 0.5, drop)).collect(Collectors.toList())).forEach(arg_0 -> ((class_1937)this.obj).method_8649(arg_0));
                this.treesToCut.remove(i);
                continue;
            }
            class_2338 pos = tree.logs.removeLast();
            tree.drops.addAll(class_2248.method_9609((class_2680)this.obj.method_8320(pos), (class_3218)((class_3218)this.obj), (class_2338)pos, (class_2586)this.obj.method_8321(pos), null, (class_1799)tree.stack));
            this.obj.method_22352(pos, false);
        }
    }

    public void addTree(Tree tree) {
        this.treesToCut.add(tree);
    }

    public record Tree(List<class_2338> logs, List<class_1799> drops, class_2338 originalPos, class_1799 stack) {
        public static final Codec<Tree> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.listOf().fieldOf("logs").forGetter(Tree::logs), (App)class_1799.field_24671.listOf().fieldOf("drops").forGetter(Tree::drops), (App)class_2338.field_25064.fieldOf("original_pos").forGetter(Tree::originalPos), (App)class_1799.field_24671.fieldOf("stack").forGetter(Tree::stack)).apply((Applicative)instance, Tree::new));

        public static Tree of(List<class_2338> logs, class_2338 originalPos, class_1799 stack) {
            return new Tree(logs, new ArrayList<class_1799>(), originalPos, stack.method_7972());
        }
    }
}

