/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import moriyashiine.enchancement.common.particle.HoneyBubbleParticleEffect;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_4844;
import net.minecraft.class_5819;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class HoneyTrailComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1937 obj;
    private final List<HoneySpot> honeySpots = new ArrayList<HoneySpot>();
    private final class_2338.class_2339 mutablePos = new class_2338.class_2339();

    public HoneyTrailComponent(class_1937 obj) {
        this.obj = obj;
    }

    public void readData(class_11368 readView) {
        this.honeySpots.clear();
        this.honeySpots.addAll(readView.method_71426("HoneySpots", HoneySpot.CODEC.listOf()).orElse(List.of()));
    }

    public void writeData(class_11372 writeView) {
        writeView.method_71468("HoneySpots", HoneySpot.CODEC.listOf(), this.honeySpots);
    }

    public void tick() {
        for (int i = this.honeySpots.size() - 1; i >= 0; --i) {
            HoneySpot spot = this.honeySpots.get(i);
            if (++spot.age < spot.maxAge && !this.isInFluid(spot.blockPos)) continue;
            this.honeySpots.remove(i);
        }
    }

    public void clientTick() {
        this.tick();
        class_1297 cameraEntity = class_310.method_1551().method_1560();
        if (cameraEntity != null) {
            for (HoneySpot spot : this.honeySpots) {
                if (!(spot.pos.method_1022(cameraEntity.method_73189()) < 128.0)) continue;
                for (int j = 0; j < 3; ++j) {
                    this.obj.method_8406((class_2394)new HoneyBubbleParticleEffect(spot.ownerId), class_3532.method_15366((class_5819)this.obj.field_9229, (double)spot.getBox().field_1323, (double)spot.getBox().field_1320), class_3532.method_15366((class_5819)this.obj.field_9229, (double)spot.getBox().field_1322, (double)spot.getBox().field_1325), class_3532.method_15366((class_5819)this.obj.field_9229, (double)spot.getBox().field_1321, (double)spot.getBox().field_1324), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public List<HoneySpot> getHoneySpots() {
        return this.honeySpots;
    }

    public void addHoneySpot(class_1309 owner, int maxAge) {
        class_243 adjustedPos = HoneyTrailComponent.getAdjustedPos(owner);
        for (HoneySpot honeySpot : this.honeySpots) {
            if (!owner.method_5667().equals(honeySpot.getOwnerId()) || !honeySpot.box.method_1011(0.7).method_1006(adjustedPos)) continue;
            honeySpot.age = 0;
            return;
        }
        class_2338 blockPos = class_2338.method_49638((class_2374)adjustedPos);
        if (!this.isInFluid(blockPos)) {
            this.honeySpots.add(new HoneySpot(owner.method_5667(), adjustedPos, blockPos, 0, maxAge));
        }
    }

    private boolean isInFluid(class_2338 pos) {
        for (int i = 0; i <= 1; ++i) {
            if (this.obj.method_8316((class_2338)this.mutablePos.method_10103(pos.method_10263(), pos.method_10264() + i, pos.method_10260())).method_15769()) continue;
            return true;
        }
        return false;
    }

    private static class_243 getAdjustedPos(class_1309 owner) {
        return owner.method_73183().method_17742(new class_3959(owner.method_73189(), owner.method_73189().method_1023(0.0, 2.0, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)owner)).method_17784();
    }

    public static class HoneySpot {
        public static final Codec<HoneySpot> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4844.field_40825.fieldOf("owner_id").forGetter(HoneySpot::getOwnerId), (App)class_243.field_38277.fieldOf("pos").forGetter(HoneySpot::getPos), (App)class_2338.field_25064.fieldOf("block_pos").forGetter(HoneySpot::getBlockPos), (App)Codec.INT.fieldOf("age").forGetter(HoneySpot::getAge), (App)Codec.INT.fieldOf("max_age").forGetter(HoneySpot::getMaxAge)).apply((Applicative)instance, HoneySpot::new));
        private final UUID ownerId;
        private final class_243 pos;
        private final class_2338 blockPos;
        private final class_238 box;
        private int age;
        private final int maxAge;

        public HoneySpot(UUID ownerId, class_243 pos, class_2338 blockPos, int age, int maxAge) {
            this.ownerId = ownerId;
            this.pos = pos;
            this.blockPos = blockPos;
            this.box = new class_238(pos.method_1031(-0.5, 0.0, -0.5), pos.method_1031(0.5, 0.2, 0.5));
            this.age = age;
            this.maxAge = maxAge;
        }

        public UUID getOwnerId() {
            return this.ownerId;
        }

        private class_243 getPos() {
            return this.pos;
        }

        private class_2338 getBlockPos() {
            return this.blockPos;
        }

        public class_238 getBox() {
            return this.box;
        }

        private int getAge() {
            return this.age;
        }

        private int getMaxAge() {
            return this.maxAge;
        }
    }
}

