/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.screenhandler;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import moriyashiine.enchancement.client.payload.SyncBookshelvesPayload;
import moriyashiine.enchancement.client.payload.SyncEnchantingTableCostPayload;
import moriyashiine.enchancement.common.ModConfig;
import moriyashiine.enchancement.common.init.ModEnchantments;
import moriyashiine.enchancement.common.init.ModScreenHandlerTypes;
import moriyashiine.enchancement.common.tag.ModEnchantmentTags;
import moriyashiine.enchancement.common.tag.ModItemTags;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import moriyashiine.enchancement.common.util.config.OverhaulMode;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3914;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7716;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import net.minecraft.class_9890;

public class EnchantingTableScreenHandler
extends class_1703 {
    public static final Map<class_1792, EnchantingMaterial> ENCHANTING_MATERIAL_MAP = new HashMap<class_1792, EnchantingMaterial>();
    public static final int PAGE_SIZE = 4;
    public final List<class_6880<class_1887>> validEnchantments = new ArrayList<class_6880<class_1887>>();
    public final List<class_6880<class_1887>> selectedEnchantments = new ArrayList<class_6880<class_1887>>();
    public final Set<class_6880<class_1887>> chiseledEnchantments = new HashSet<class_6880<class_1887>>();
    public int viewIndex = 0;
    private class_1799 enchantingStack = class_1799.field_8037;
    private EnchantingMaterial enchantingMaterial = EnchantingMaterial.EMPTY;
    private int bookshelfCount = 0;
    private int cost = 0;
    private final class_1263 inventory = new class_1277(3){

        public void method_5431() {
            super.method_5431();
            EnchantingTableScreenHandler.this.method_7609((class_1263)this);
        }
    };
    private final class_3914 context;
    private final class_1937 world;

    public EnchantingTableScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304, playerInventory.field_7546.method_73183());
    }

    public EnchantingTableScreenHandler(int syncId, class_1661 playerInventory, class_3914 context, class_1937 world) {
        super(ModScreenHandlerTypes.ENCHANTING_TABLE, syncId);
        this.context = context;
        this.world = world;
        class_1657 class_16572 = playerInventory.field_7546;
        if (class_16572 instanceof class_3222) {
            class_3222 player = (class_3222)class_16572;
            this.collectBookshelves(player);
        }
        this.method_7621(new class_1735(this.inventory, 0, 15, 31){

            public boolean method_7680(class_1799 stack) {
                if (stack.method_7923()) {
                    for (class_6880 class_68802 : EnchantingTableScreenHandler.this.getAllEnchantments()) {
                        if (!EnchantingTableScreenHandler.this.isEnchantmentAllowed((class_6880<class_1887>)class_68802, stack)) continue;
                        return true;
                    }
                }
                return false;
            }

            public int method_7675() {
                return 1;
            }

            public void method_7667(class_1657 player, class_1799 stack) {
                EnchantingTableScreenHandler.this.validEnchantments.clear();
                EnchantingTableScreenHandler.this.selectedEnchantments.clear();
                EnchantingTableScreenHandler.this.viewIndex = 0;
                EnchantingTableScreenHandler.this.enchantingStack = class_1799.field_8037;
                EnchantingTableScreenHandler.this.enchantingMaterial = EnchantingMaterial.EMPTY;
                EnchantingTableScreenHandler.this.cost = 0;
                player.method_31548().method_7398(((class_1735)EnchantingTableScreenHandler.this.field_7761.get(2)).method_7677().method_51164());
                super.method_7667(player, stack);
            }
        });
        this.method_7621(new class_1735(this, this.inventory, 1, 35, 31){

            public boolean method_7680(class_1799 stack) {
                return stack.method_31574(class_1802.field_8759);
            }
        });
        this.method_7621(new class_1735(this.inventory, 2, 25, 51){

            public boolean method_7680(class_1799 stack) {
                return EnchantingTableScreenHandler.this.getEnchantingMaterial(((class_1735)EnchantingTableScreenHandler.this.field_7761.getFirst()).method_7677()).test(stack);
            }
        });
        this.method_61624((class_1263)playerInventory, 8, 84);
    }

    public boolean method_7597(class_1657 player) {
        return EnchantingTableScreenHandler.method_17695((class_3914)this.context, (class_1657)player, (class_2248)class_2246.field_10485);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 stack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot.method_7681()) {
            class_1799 stackInSlot = slot.method_7677();
            stack = stackInSlot.method_7972();
            if (index == 0 || index == 1 || index == 2) {
                if (!this.method_7616(stackInSlot, 3, 38, false)) {
                    return class_1799.field_8037;
                }
            } else if (this.getEnchantingMaterial().test(stackInSlot)) {
                if (!this.method_7616(stackInSlot, 2, 3, false)) {
                    return class_1799.field_8037;
                }
            } else if (stackInSlot.method_31574(class_1802.field_8759)) {
                if (!this.method_7616(stackInSlot, 1, 2, false)) {
                    return class_1799.field_8037;
                }
            } else if (!((class_1735)this.field_7761.getFirst()).method_7681() && ((class_1735)this.field_7761.getFirst()).method_7680(stackInSlot)) {
                ((class_1735)this.field_7761.getFirst()).method_53512(stackInSlot.method_7971(1));
            } else {
                return class_1799.field_8037;
            }
            if (stackInSlot.method_7960()) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (stackInSlot.method_7947() == stack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, stackInSlot);
        }
        return stack;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.context.method_17393((world, pos) -> this.method_7607(player, this.inventory));
    }

    public boolean method_7604(class_1657 player, int id) {
        if (id == 0) {
            if (this.canEnchant(player, player.method_68878())) {
                this.context.method_17393((world, pos) -> {
                    class_1799 stack = ((class_1735)this.field_7761.getFirst()).method_7677();
                    for (class_6880<class_1887> enchantment : this.selectedEnchantments) {
                        stack.method_7978(enchantment, EnchancementUtil.alterLevel(stack, enchantment));
                    }
                    if (!player.method_68878() && this.cost > 0) {
                        player.method_7286(stack, this.cost);
                    }
                    player.method_7281(class_3468.field_15420);
                    class_174.field_1181.method_8870((class_3222)player, stack, this.cost);
                    world.method_8396(null, pos, class_3417.field_15119, class_3419.field_15245, 1.0f, world.field_9229.method_43057() * 0.1f + 0.9f);
                    if (!player.method_68878() && this.cost > 0) {
                        ((class_1735)this.field_7761.get(1)).method_7677().method_7934(this.cost);
                        if (!this.getEnchantingMaterial(((class_1735)this.field_7761.get(0)).method_7677()).isEmpty()) {
                            ((class_1735)this.field_7761.get(2)).method_7677().method_7934(this.cost);
                        }
                    }
                    this.inventory.method_5431();
                    this.method_7609(this.inventory);
                });
                return true;
            }
        } else {
            if (id == 1) {
                this.updateViewIndex(true);
                return true;
            }
            if (id == 2) {
                this.updateViewIndex(false);
                return true;
            }
            if (id > 2 && id < 8) {
                class_6880<class_1887> enchantment = this.getEnchantmentFromViewIndex(id - 4);
                if (this.selectedEnchantments.contains(enchantment)) {
                    this.selectedEnchantments.remove(enchantment);
                } else {
                    this.selectedEnchantments.add(enchantment);
                }
                this.cost = this.getCost(((class_1735)this.field_7761.getFirst()).method_7677());
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    SyncEnchantingTableCostPayload.send(serverPlayer, this.cost);
                }
                return true;
            }
        }
        return false;
    }

    public void method_7609(class_1263 inventory) {
        class_1799 stack;
        if (inventory == this.inventory && this.enchantingStack != (stack = ((class_1735)this.field_7761.getFirst()).method_7677())) {
            this.validEnchantments.clear();
            this.selectedEnchantments.clear();
            this.viewIndex = 0;
            this.enchantingStack = stack;
            this.enchantingMaterial = this.getEnchantingMaterial(stack);
            this.cost = 0;
            for (class_6880 class_68802 : this.getAllEnchantments()) {
                if (!this.isEnchantmentAllowed((class_6880<class_1887>)class_68802, stack) || EnchancementUtil.isDefaultEnchantment(stack, (class_6880<class_1887>)class_68802)) continue;
                this.validEnchantments.add((class_6880<class_1887>)class_68802);
            }
            this.validEnchantments.sort(Comparator.comparing(e -> e.method_40230().orElse(ModEnchantments.EMPTY_KEY).method_29177().method_12832()));
            super.method_7609(inventory);
        }
    }

    public class_6880<class_1887> getEnchantmentFromViewIndex(int index) {
        if (this.validEnchantments.size() <= 4) {
            return this.validEnchantments.get(index);
        }
        return this.validEnchantments.get((index + this.viewIndex) % this.validEnchantments.size());
    }

    public boolean canEnchant(class_1657 player, boolean simulate) {
        if (((class_1735)this.field_7761.get(0)).method_7681()) {
            if (!((class_1735)this.field_7761.get(0)).method_7677().method_7923()) {
                return false;
            }
            if (simulate) {
                return true;
            }
            if (player.field_7520 >= this.cost && ((class_1735)this.field_7761.get(1)).method_7677().method_7947() >= this.cost) {
                if (!this.getEnchantingMaterial(((class_1735)this.field_7761.get(0)).method_7677()).isEmpty()) {
                    return ((class_1735)this.field_7761.get(2)).method_7677().method_7947() >= this.cost;
                }
                return true;
            }
        }
        return false;
    }

    public EnchantingMaterial getEnchantingMaterial() {
        return this.enchantingMaterial;
    }

    private EnchantingMaterial getEnchantingMaterial(class_1799 stack) {
        EnchantingMaterial material = ENCHANTING_MATERIAL_MAP.getOrDefault(stack.method_7909(), EnchantingMaterial.EMPTY);
        if (material.isEmpty()) {
            HashSet items = new HashSet();
            if (stack.method_57826(class_9334.field_53696)) {
                ((class_9890)stack.method_58694(class_9334.field_53696)).comp_2939().forEach(item -> items.add(item.comp_349() == class_1802.field_22020 ? class_1802.field_8477 : (class_1935)item.comp_349()));
            }
            material = items.isEmpty() ? new EnchantingMaterial(class_1856.method_8106((class_6885)this.world.method_30349().method_30530(class_7924.field_41197).method_46735(ModItemTags.DEFAULT_ENCHANTING_MATERIAL))) : new EnchantingMaterial(class_1856.method_8091((class_1935[])items.toArray(new class_1935[0])));
        }
        return material;
    }

    private void collectBookshelves(class_3222 player) {
        this.context.method_17393((world, pos) -> {
            this.chiseledEnchantments.clear();
            this.bookshelfCount = 0;
            for (class_2338 offset : class_2331.field_36535) {
                if (!class_2331.method_40445((class_1937)world, (class_2338)pos, (class_2338)offset)) continue;
                class_2586 patt0$temp = world.method_8321(pos.method_10081((class_2382)offset));
                if (patt0$temp instanceof class_7716) {
                    class_7716 chiseledBookshelfBlockEntity = (class_7716)patt0$temp;
                    this.bookshelfCount += chiseledBookshelfBlockEntity.method_72663() / 3;
                    if (ModConfig.overhaulEnchanting != OverhaulMode.CHISELED || player.method_68878()) continue;
                    for (class_1799 stack : chiseledBookshelfBlockEntity) {
                        this.chiseledEnchantments.addAll(class_1890.method_57532((class_1799)stack).method_57534());
                    }
                    continue;
                }
                ++this.bookshelfCount;
            }
            this.bookshelfCount = Math.min(15, this.bookshelfCount);
            if (ModConfig.overhaulEnchanting == OverhaulMode.CHISELED && player.method_68878()) {
                class_2378 enchantmentRegistry = world.method_30349().method_30530(class_7924.field_41265);
                enchantmentRegistry.forEach(enchantment -> this.chiseledEnchantments.add((class_6880<class_1887>)enchantmentRegistry.method_47983(enchantment)));
            }
            SyncBookshelvesPayload.send(player, this.chiseledEnchantments, this.bookshelfCount);
        });
    }

    public int getCost() {
        return this.cost;
    }

    private int getCost(class_1799 stack) {
        double cost = 60.0f / (float)Math.max(1, EnchancementUtil.getEnchantmentValue(stack) + this.bookshelfCount);
        cost = this.bookshelfCount == 15 ? (double)class_3532.method_15357((double)cost) : (double)class_3532.method_15384((double)cost);
        return (int)(cost * (double)this.selectedEnchantments.size());
    }

    public void updateViewIndex(boolean up) {
        this.viewIndex = (this.viewIndex + (up ? -1 : 1)) % this.validEnchantments.size();
        if (this.viewIndex < 0) {
            this.viewIndex += this.validEnchantments.size();
        }
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    private List<class_6880.class_6883<class_1887>> getAllEnchantments() {
        return this.world.method_30349().method_30530(class_7924.field_41265).method_42017().toList();
    }

    private boolean isEnchantmentAllowed(class_6880<class_1887> enchantment, class_1799 stack) {
        if (stack.method_7960() || enchantment.method_40220(ModEnchantmentTags.UNSELECTABLE)) {
            return false;
        }
        if (stack.canBeEnchantedWith(enchantment, EnchantingContext.ACCEPTABLE)) {
            if (enchantment.method_40220(ModEnchantmentTags.ALWAYS_SELECTABLE)) {
                return true;
            }
            if (ModConfig.overhaulEnchanting != OverhaulMode.CHISELED || this.chiseledEnchantments.contains(enchantment)) {
                if (ModConfig.overhaulEnchanting.allowsTreasure() && enchantment.method_40220(class_9636.field_51557)) {
                    return true;
                }
                return enchantment.method_40220(class_9636.field_51547);
            }
        }
        return false;
    }

    public record EnchantingMaterial(class_1856 ingredient) {
        public static final class_9139<class_9129, EnchantingMaterial> PACKET_CODEC = class_1856.field_48355.method_56432(EnchantingMaterial::new, EnchantingMaterial::ingredient);
        public static final EnchantingMaterial EMPTY = new EnchantingMaterial(null);

        public class_6880<class_1792> get(int index) {
            return (class_6880)this.ingredient().method_8105().toList().get(index);
        }

        public int size() {
            if (this.ingredient() == null) {
                return 0;
            }
            return this.ingredient().method_8105().toList().size();
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        public boolean test(class_1799 stack) {
            if (this.ingredient() == null) {
                return false;
            }
            return this.ingredient().method_8093(stack);
        }
    }
}

