/*
 * Decompiled with CFR 0.152.
 */
package synth_cat.escapethebackrooms.Shader;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class ShaderInstaller {
    private static final String SHADER_ZIP = "Shaders.zip";
    private static final String SHADER_TXT = "Shaders.zip.txt";

    public static void installShader() {
        try {
            Path mcDir = Paths.get(System.getProperty("user.dir"), new String[0]);
            Path shaderpacksDir = mcDir.resolve("shaderpacks");
            if (!Files.exists(shaderpacksDir, new LinkOption[0])) {
                Files.createDirectories(shaderpacksDir, new FileAttribute[0]);
            }
            ShaderInstaller.installFile("/assets/escapethebackrooms/shaders/Shaders.zip", shaderpacksDir.resolve(SHADER_ZIP));
            ShaderInstaller.installFile("/assets/escapethebackrooms/shaders/Shaders.zip.txt", shaderpacksDir.resolve(SHADER_TXT));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void installFile(String resourcePath, Path destination) throws IOException {
        if (!Files.exists(destination, new LinkOption[0])) {
            try (InputStream in = ShaderInstaller.class.getResourceAsStream(resourcePath);){
                if (in != null) {
                    Files.copy(in, destination, new CopyOption[0]);
                    System.out.println("[ShaderInstaller] Installed: " + String.valueOf(destination.getFileName()));
                } else {
                    System.err.println("[ShaderInstaller] Missing resource: " + resourcePath);
                }
            }
        }
    }
}

