/*
 * Decompiled with CFR 0.152.
 */
package synth_cat.escapethebackrooms.Util;

import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import synth_cat.escapethebackrooms.Util.InventoryBackupHolder;

public final class DimensionInventorySwap {
    private static final class_5321<class_1937> CUSTOM_DIM = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60655((String)"backrooms", (String)"level_0"));
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"EscapeTheBackrooms");

    private DimensionInventorySwap() {
    }

    public static void register() {
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> {
            MinecraftServer srv = player.method_5682();
            boolean entering = destination.method_27983().equals(CUSTOM_DIM);
            boolean leaving = origin.method_27983().equals(CUSTOM_DIM);
            if (!(player instanceof InventoryBackupHolder)) {
                return;
            }
            InventoryBackupHolder holder = (InventoryBackupHolder)player;
            if (entering) {
                if (!holder.etb$hasBackup()) {
                    holder.etb$setBackup(DimensionInventorySwap.snapshot(player));
                }
                DimensionInventorySwap.clear(player);
            }
            if (leaving && holder.etb$hasBackup()) {
                DimensionInventorySwap.restore(player, holder.etb$getBackup());
                holder.etb$setBackup(null);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 p = handler.field_14140;
            if (!(p instanceof InventoryBackupHolder)) {
                return;
            }
            InventoryBackupHolder holder = (InventoryBackupHolder)p;
            if (p.method_37908().method_27983().equals(CUSTOM_DIM)) {
                if (!holder.etb$hasBackup()) {
                    holder.etb$setBackup(DimensionInventorySwap.snapshot(p));
                }
                DimensionInventorySwap.clear(p);
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 p : server.method_3760().method_14571()) {
                if (!(p instanceof InventoryBackupHolder)) continue;
                InventoryBackupHolder holder = (InventoryBackupHolder)p;
                boolean inDim = p.method_37908().method_27983().equals(CUSTOM_DIM);
                if (inDim) {
                    if (!holder.etb$hasBackup()) {
                        holder.etb$setBackup(DimensionInventorySwap.snapshot(p));
                    }
                    if (DimensionInventorySwap.isEmpty(p)) continue;
                    DimensionInventorySwap.clear(p);
                    continue;
                }
                if (!holder.etb$hasBackup()) continue;
                DimensionInventorySwap.restore(p, holder.etb$getBackup());
                holder.etb$setBackup(null);
            }
        });
    }

    private static boolean isEmpty(class_3222 p) {
        for (class_1799 s : p.method_31548().field_7547) {
            if (s.method_7960()) continue;
            return false;
        }
        for (class_1799 s : p.method_31548().field_7548) {
            if (s.method_7960()) continue;
            return false;
        }
        for (class_1799 s : p.method_31548().field_7544) {
            if (s.method_7960()) continue;
            return false;
        }
        return true;
    }

    private static void log(MinecraftServer srv, String msg) {
        LOGGER.info(msg);
    }

    private static class_2487 snapshot(class_3222 p) {
        class_2487 root = new class_2487();
        class_5455.class_6890 lookup = p.method_5682().method_30611();
        class_2371<class_1799> main = DimensionInventorySwap.copyList((class_2371<class_1799>)p.method_31548().field_7547);
        class_2371<class_1799> armor = DimensionInventorySwap.copyList((class_2371<class_1799>)p.method_31548().field_7548);
        class_2371<class_1799> off = DimensionInventorySwap.copyList((class_2371<class_1799>)p.method_31548().field_7544);
        class_2487 mainTag = new class_2487();
        class_2487 armorTag = new class_2487();
        class_2487 offTag = new class_2487();
        class_1262.method_5426((class_2487)mainTag, main, (class_7225.class_7874)lookup);
        class_1262.method_5426((class_2487)armorTag, armor, (class_7225.class_7874)lookup);
        class_1262.method_5426((class_2487)offTag, off, (class_7225.class_7874)lookup);
        root.method_10566("Main", (class_2520)mainTag);
        root.method_10566("Armor", (class_2520)armorTag);
        root.method_10566("Offhand", (class_2520)offTag);
        return root;
    }

    private static void restore(class_3222 p, class_2487 root) {
        int i;
        DimensionInventorySwap.clear(p);
        class_5455.class_6890 lookup = p.method_5682().method_30611();
        class_2371 main = class_2371.method_10213((int)p.method_31548().field_7547.size(), (Object)class_1799.field_8037);
        class_2371 armor = class_2371.method_10213((int)p.method_31548().field_7548.size(), (Object)class_1799.field_8037);
        class_2371 off = class_2371.method_10213((int)p.method_31548().field_7544.size(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)root.method_10562("Main"), (class_2371)main, (class_7225.class_7874)lookup);
        class_1262.method_5429((class_2487)root.method_10562("Armor"), (class_2371)armor, (class_7225.class_7874)lookup);
        class_1262.method_5429((class_2487)root.method_10562("Offhand"), (class_2371)off, (class_7225.class_7874)lookup);
        for (i = 0; i < main.size(); ++i) {
            p.method_31548().field_7547.set(i, (Object)((class_1799)main.get(i)));
        }
        for (i = 0; i < armor.size(); ++i) {
            p.method_31548().field_7548.set(i, (Object)((class_1799)armor.get(i)));
        }
        for (i = 0; i < off.size(); ++i) {
            p.method_31548().field_7544.set(i, (Object)((class_1799)off.get(i)));
        }
        p.method_31548().method_5431();
        p.field_7498.method_34252();
    }

    private static void clear(class_3222 p) {
        DimensionInventorySwap.fillEmpty((class_2371<class_1799>)p.method_31548().field_7547);
        DimensionInventorySwap.fillEmpty((class_2371<class_1799>)p.method_31548().field_7548);
        DimensionInventorySwap.fillEmpty((class_2371<class_1799>)p.method_31548().field_7544);
        p.method_31548().method_5431();
        p.field_7498.method_34252();
    }

    private static class_2371<class_1799> copyList(class_2371<class_1799> src) {
        class_2371 dst = class_2371.method_10213((int)src.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < src.size(); ++i) {
            dst.set(i, (Object)((class_1799)src.get(i)).method_7972());
        }
        return dst;
    }

    private static void fillEmpty(class_2371<class_1799> list) {
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, (Object)class_1799.field_8037);
        }
    }
}

