/*
 * Decompiled with CFR 0.152.
 */
package synth_cat.escapethebackrooms.Video;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.jcodec.api.FrameGrab;
import org.jcodec.common.io.FileChannelWrapper;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.Picture;
import org.jcodec.scale.AWTUtil;

public final class VideoLoopPlayer {
    private final String modId;
    private final String pathInAssets;
    private final int targetFps;
    private Thread worker;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private class_1043 currentTexture;
    private class_2960 currentTexId;
    private int videoW = 1920;
    private int videoH = 1080;
    private static final int TARGET_UPLOAD_W = 1280;
    private static final int TARGET_UPLOAD_H = 720;
    private static final int SKIP_EVERY_N_FRAMES = 0;
    private static final boolean DESATURATE_DARK_ENABLE = true;
    private static final int LUMA_FULL_TRANSPARENT = 10;
    private static final int LUMA_FULL_OPAQUE = 85;
    private static final int[] LUMA_TO_ALPHA = new int[256];

    public VideoLoopPlayer(String modId, String pathInAssets, int targetFps) {
        this.modId = modId;
        this.pathInAssets = pathInAssets;
        this.targetFps = Math.max(1, targetFps);
    }

    public class_2960 getTextureId() {
        return this.currentTexId;
    }

    public int getVideoW() {
        return this.videoW;
    }

    public int getVideoH() {
        return this.videoH;
    }

    public void start() {
        if (this.running.get()) {
            return;
        }
        this.running.set(true);
        this.worker = new Thread(this::runDecode, "VideoLoopPlayer-" + this.pathInAssets);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    public void stop() {
        this.running.set(false);
        if (this.worker != null) {
            try {
                this.worker.join(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.worker = null;
        }
        class_310.method_1551().execute(() -> {
            if (this.currentTexture != null && this.currentTexId != null) {
                class_310.method_1551().method_1531().method_4615(this.currentTexId);
            }
            this.currentTexture = null;
            this.currentTexId = null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDecode() {
        class_310 client = class_310.method_1551();
        long frameNanos = (long)(1.0E9 / (double)this.targetFps);
        while (this.running.get()) {
            try {
                byte[] bytes;
                class_3300 rm = client.method_1478();
                class_2960 id = class_2960.method_60655((String)this.modId, (String)this.pathInAssets);
                try (InputStream in = rm.open(id);){
                    bytes = in.readAllBytes();
                }
                File tmp = File.createTempFile("etb_", ".mp4");
                try (FileOutputStream fos = new FileOutputStream(tmp);){
                    fos.write(bytes);
                }
                try {
                    FileChannelWrapper ch = NIOUtils.readableFileChannel((String)tmp.getAbsolutePath());
                    try {
                        Picture pic;
                        FrameGrab grab = FrameGrab.createFrameGrab((SeekableByteChannel)ch);
                        try {
                            grab.seekToFramePrecise(0);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        long last = System.nanoTime();
                        boolean frameIndex = false;
                        while (this.running.get() && (pic = grab.getNativeFrame()) != null) {
                            BufferedImage rgb = AWTUtil.toBufferedImage((Picture)pic);
                            this.videoW = rgb.getWidth();
                            this.videoH = rgb.getHeight();
                            BufferedImage scaled = VideoLoopPlayer.scaleBilinear(rgb, 1280, 720);
                            client.execute(() -> this.uploadFrameFast(scaled));
                            long now = System.nanoTime();
                            long wait = frameNanos - (now - last);
                            if (wait > 0L) {
                                try {
                                    Thread.sleep(wait / 1000000L, (int)(wait % 1000000L));
                                }
                                catch (InterruptedException ie) {
                                    Thread.currentThread().interrupt();
                                    if (ch != null) {
                                        ch.close();
                                    }
                                    try {
                                        Files.deleteIfExists(tmp.toPath());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    return;
                                }
                            }
                            last = System.nanoTime();
                        }
                    }
                    finally {
                        if (ch == null) continue;
                        ch.close();
                    }
                }
                finally {
                    try {
                        Files.deleteIfExists(tmp.toPath());
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception e) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static BufferedImage scaleBilinear(BufferedImage src, int w, int h) {
        if (src.getWidth() == w && src.getHeight() == h) {
            return src;
        }
        BufferedImage dst = new BufferedImage(w, h, 2);
        Graphics2D g = dst.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.drawImage(src, 0, 0, w, h, null);
        g.dispose();
        return dst;
    }

    private void uploadFrameFast(BufferedImage img) {
        try {
            int w = img.getWidth();
            int h = img.getHeight();
            int[] argb = img.getType() == 2 ? ((DataBufferInt)img.getRaster().getDataBuffer()).getData() : img.getRGB(0, 0, w, h, null, 0, w);
            class_1011 ni = new class_1011(class_1011.class_1012.field_4997, w, h, false);
            int idx = 0;
            for (int y = 0; y < h; ++y) {
                int x = 0;
                while (x < w) {
                    int p = argb[idx];
                    int a = p >>> 24 & 0xFF;
                    int r = p >>> 16 & 0xFF;
                    int g = p >>> 8 & 0xFF;
                    int b = p & 0xFF;
                    int l = 54 * r + 183 * g + 18 * b >> 8;
                    int aL = LUMA_TO_ALPHA[l];
                    a = a * aL >> 8;
                    if (aL < 128) {
                        int gray = l;
                        int k = 128 - aL;
                        r = r * (128 - k) + gray * k >> 7;
                        g = g * (128 - k) + gray * k >> 7;
                        b = b * (128 - k) + gray * k >> 7;
                    }
                    int abgr = a << 24 | b << 16 | g << 8 | r;
                    ni.method_4305(x, y, abgr);
                    ++x;
                    ++idx;
                }
            }
            if (this.currentTexture == null) {
                this.currentTexture = new class_1043(ni);
                this.currentTexId = class_310.method_1551().method_1531().method_4617("video_loop_" + this.pathInAssets.hashCode(), this.currentTexture);
                this.currentTexture.method_4524();
            } else {
                this.currentTexture.method_4526(ni);
                this.currentTexture.method_4524();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        float lo = 10.0f;
        float hi = 85.0f;
        float span = Math.max(1.0f, 75.0f);
        for (int l = 0; l < 256; ++l) {
            float t = ((float)l - 10.0f) / span;
            if (t < 0.0f) {
                t = 0.0f;
            } else if (t > 1.0f) {
                t = 1.0f;
            }
            float s = t * t * (3.0f - 2.0f * t);
            VideoLoopPlayer.LUMA_TO_ALPHA[l] = Math.round(255.0f * s);
        }
    }
}

