/*
 * Decompiled with CFR 0.152.
 */
package synth_cat.escapethebackrooms.entity.custom;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1324;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import net.minecraft.class_7924;
import synth_cat.escapethebackrooms.Network.JumpscareNetworking;
import synth_cat.escapethebackrooms.Sound.ModSounds;

public class BacteriaEntity
extends class_1588 {
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 runAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    private static final class_2940<Boolean> CHASING = class_2945.method_12791(BacteriaEntity.class, (class_2941)class_2943.field_13323);
    public static final class_5321<class_1937> LEVEL_0 = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60655((String)"backrooms", (String)"level_0"));
    private static final int LOS_BREAK_TIME = 60;
    private static final int UNNOTICED_TIME = 2400;
    private static final double TRIGGER_RADIUS_H = 1.2;
    private static final double TRIGGER_RADIUS_Y = 1.8;
    private static final double SEARCH_RANGE = 3.5;
    private static final double STOP_AT_DIST = 4.0;
    private static final float MAX_YAW_CHANGE_PER_TICK = 4.0f;
    private static final double CHASE_FOV_DEG = 45.0;
    private static final double CHASE_AIM_RADIUS = 1.6;
    private static final int OUTRUN_TIME = 400;
    private static final double OUTRUN_DIST = 1.0;
    private Phase phase = Phase.DORMANT;
    private UUID targetUuid = null;
    private int losLostTicks = 0;
    private int unseenSinceSpawnTicks = 0;
    private double baseSpeed = 0.2;
    private double chaseSpeed = 0.25;
    private int ambushRecalcTicks = 0;
    private int flankSign = 1;
    private int spawnAmbushTicks = 0;
    private static final double NEARBY_CHASE_RADIUS = 10.0;
    private int outrunTicks = 0;
    private int jumpscareCooldown = 0;

    public BacteriaEntity(class_1299<? extends class_1588> type, class_1937 world) {
        super(type, world);
    }

    public void wakeAndTarget(class_1657 pick, class_2338 spawn) {
        this.method_5808((double)spawn.method_10263() + 0.5, spawn.method_10264(), (double)spawn.method_10260() + 0.5, this.method_36454(), this.method_36455());
        this.method_5648(false);
        this.method_5875(false);
        this.targetUuid = pick.method_5667();
        this.phase = Phase.STALKING;
        this.losLostTicks = 0;
        this.unseenSinceSpawnTicks = 0;
        this.field_6011.method_12778(CHASING, (Object)false);
        this.setMoveSpeed(this.baseSpeed);
        this.spawnAmbushTicks = 120;
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(CHASING, (Object)false);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 18.0).method_26868(class_5134.field_23719, 0.2).method_26868(class_5134.field_23717, 32.0);
    }

    public boolean method_5732() {
        return false;
    }

    public boolean method_5679(class_1282 source) {
        return true;
    }

    public boolean method_5643(class_1282 source, float amount) {
        return false;
    }

    public void method_6005(double strength, double x, double z) {
    }

    private void setupIdleAnimation() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 40;
            this.idleAnimationState.method_41322(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    private void setChasingVisuals(boolean chasing) {
        if (chasing) {
            if (!this.runAnimationState.method_41327()) {
                this.runAnimationState.method_41322(this.field_6012);
            }
            this.idleAnimationState.method_41325();
        } else {
            this.runAnimationState.method_41325();
            if (!this.idleAnimationState.method_41327()) {
                this.idleAnimationState.method_41322(this.field_6012);
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().method_8608()) {
            this.setupIdleAnimation();
            this.setChasingVisuals((Boolean)this.field_6011.method_12789(CHASING));
            return;
        }
        class_3218 sw = (class_3218)this.method_37908();
        if (!this.isInLevel0(sw)) {
            this.method_31472();
            return;
        }
        if (this.jumpscareCooldown > 0) {
            --this.jumpscareCooldown;
        } else {
            this.maybeJumpscareOnTouch(sw);
        }
        class_1324 inst = this.method_5996(class_5134.field_23719);
        if (inst != null) {
            this.baseSpeed = Math.max(0.01, inst.method_6201());
        }
        switch (this.phase.ordinal()) {
            case 0: {
                this.tickDormantSafety(sw);
                break;
            }
            case 1: {
                this.tickStalking(sw);
                break;
            }
            case 2: {
                this.tickChasing(sw);
            }
        }
    }

    private void maybeJumpscareOnTouch(class_3218 sw) {
        double HANDOFF_RADIUS = 15.0;
        double HANDOFF_R2 = 225.0;
        class_238 base = this.method_5829().method_1009(1.2, 0.9, 1.2);
        class_238 swept = base.method_991(base.method_997(this.method_18798()));
        List nearby = sw.method_8390(class_1657.class, this.method_5829().method_1014(3.5), p -> p.method_5805() && !p.method_7325());
        if (nearby.isEmpty()) {
            return;
        }
        for (class_1657 p2 : nearby) {
            boolean radial;
            double dy = Math.abs(p2.method_23318() + (double)p2.method_17682() * 0.5 - (this.method_23318() + (double)this.method_17682() * 0.5));
            if (dy > 1.8) continue;
            boolean intersects = p2.method_5829().method_994(swept);
            boolean bl = radial = !intersects && this.method_5858((class_1297)p2) <= 1.44;
            if (!intersects && !radial || !(p2 instanceof class_3222)) continue;
            class_3222 sp = (class_3222)p2;
            class_2960 pngOverlay = class_2960.method_60655((String)"escapethebackrooms", (String)"textures/jumpscare/jumpscare.png");
            int duration = 35;
            boolean fade = true;
            class_2960 sound = ModSounds.JUMPSCARE.method_14833();
            JumpscareNetworking.trigger(sp, pngOverlay, duration, fade, sound);
            class_3222 handoff = null;
            double bestD2 = 226.0;
            for (class_3222 other : sw.method_18766(pl -> pl.method_5805() && !pl.method_7325() && pl != sp)) {
                double d2 = this.method_5858((class_1297)other);
                if (!(d2 <= 225.0) || !(d2 < bestD2)) continue;
                handoff = other;
                bestD2 = d2;
            }
            if (handoff != null) {
                this.targetUuid = handoff.method_5667();
                this.phase = Phase.CHASING;
                this.losLostTicks = 0;
                this.outrunTicks = 0;
                this.field_6011.method_12778(CHASING, (Object)true);
                this.setMoveSpeed(this.chaseSpeed);
                this.method_5942().method_6337(handoff.method_23317(), this.method_23318(), handoff.method_23321(), 1.4);
            } else {
                this.method_31472();
            }
            this.jumpscareCooldown = 60;
            return;
        }
    }

    private void tickStalking(class_3218 sw) {
        class_1657 target = this.getTargetPlayer(sw);
        if (target == null || !target.method_5805() || target.method_7325() || target.method_37908() != sw) {
            this.method_31472();
            return;
        }
        class_1657 close = this.findNearestPlayerWithin(sw, 100.0);
        if (close != null && !close.method_5667().equals(this.targetUuid)) {
            this.targetUuid = close.method_5667();
        }
        if (this.playerSeesEntityWide(target)) {
            this.startChase();
            return;
        }
        if (this.spawnAmbushTicks > 0) {
            this.pursueSpawnAmbushWhileUnseen(sw, target, 1.05);
            --this.spawnAmbushTicks;
        } else {
            this.pursueAmbushWhileUnseen(sw, target, 1.05);
        }
        ++this.unseenSinceSpawnTicks;
        if (this.unseenSinceSpawnTicks >= 2400) {
            this.method_31472();
        }
    }

    private void tickChasing(class_3218 sw) {
        boolean hasLoS;
        class_1657 target = this.getTargetPlayer(sw);
        if (target == null || !target.method_5805() || target.method_7325() || target.method_37908() != sw) {
            this.method_31472();
            return;
        }
        class_1657 close = this.findNearestPlayerWithin(sw, 100.0);
        if (close != null && !close.method_5667().equals(this.targetUuid)) {
            this.targetUuid = close.method_5667();
            this.losLostTicks = 0;
            this.outrunTicks = 0;
            this.field_6011.method_12778(CHASING, (Object)true);
        }
        this.method_5942().method_6337(target.method_23317(), this.method_23318(), target.method_23321(), 1.4);
        class_243 facePoint = new class_243(target.method_23317(), this.method_23318(), target.method_23321());
        this.smoothFace(facePoint, 4.0f);
        boolean bl = hasLoS = this.method_6057((class_1297)target) && target.method_6057((class_1297)this);
        if (hasLoS) {
            this.losLostTicks = 0;
        } else if (++this.losLostTicks >= 60) {
            this.method_31472();
            return;
        }
        double dist = this.method_5739((class_1297)target);
        if (dist > 1.0) {
            if (++this.outrunTicks >= 400) {
                this.method_31472();
                return;
            }
        } else {
            this.outrunTicks = 0;
        }
    }

    private void startChase() {
        this.phase = Phase.CHASING;
        this.losLostTicks = 0;
        this.outrunTicks = 0;
        this.field_6011.method_12778(CHASING, (Object)true);
        this.setMoveSpeed(this.chaseSpeed);
        this.playChaseSound();
    }

    private boolean isInLevel0(class_3218 sw) {
        return sw.method_27983().equals(LEVEL_0);
    }

    private void setMoveSpeed(double speed) {
        class_1324 inst = this.method_5996(class_5134.field_23719);
        if (inst != null) {
            inst.method_6192(speed);
        }
    }

    private void playChaseSound() {
        class_3414 evt = class_3417.field_14727;
        if (evt != null) {
            this.method_5783(evt, 1.0f, 1.0f);
        }
    }

    private class_1657 getTargetPlayer(class_3218 sw) {
        if (this.targetUuid == null) {
            return null;
        }
        return sw.method_8503().method_3760().method_14602(this.targetUuid);
    }

    private class_1657 findNearestPlayerWithin(class_3218 sw, double radiusSq) {
        class_3222 closest = null;
        double best = radiusSq;
        for (class_3222 p : sw.method_18766(pl -> !pl.method_7325() && pl.method_5805())) {
            double d2 = this.method_5858((class_1297)p);
            if (!(d2 <= best)) continue;
            best = d2;
            closest = p;
        }
        return closest;
    }

    private void pursueSpawnAmbushWhileUnseen(class_3218 sw, class_1657 target, double speed) {
        if (this.ambushRecalcTicks-- <= 0) {
            class_2338 ground;
            this.ambushRecalcTicks = 6 + sw.method_8409().method_43048(5);
            class_243 look = target.method_5828(1.0f).method_1029();
            double dist = Math.max(1.0, (double)this.method_5739((class_1297)target));
            double playerSpeed = target.method_18798().method_37267();
            double prediction = class_3532.method_15350((double)(playerSpeed * 20.0), (double)2.0, (double)8.0);
            double aheadDist = class_3532.method_15350((double)(dist * 0.9 + prediction), (double)10.0, (double)22.0);
            if (sw.method_8409().method_43057() < 0.25f) {
                this.flankSign *= -1;
            }
            double flankOffset = 4.0 + sw.method_8409().method_43058() * 3.0;
            class_243 perp = new class_243(-look.field_1350, 0.0, look.field_1352).method_1029();
            class_243 candidate = target.method_19538().method_1019(look.method_1021(aheadDist)).method_1019(perp.method_1021((double)this.flankSign * flankOffset));
            candidate = new class_243(candidate.field_1352, this.method_23318(), candidate.field_1350);
            if (this.isInPlayerFovAngle(target, candidate, 25.0)) {
                candidate = target.method_19538().method_1019(look.method_1021(aheadDist)).method_1019(perp.method_1021((double)(-this.flankSign) * (flankOffset + 3.0)));
                candidate = new class_243(candidate.field_1352, this.method_23318(), candidate.field_1350);
            }
            if (this.distanceFromLineXZ(target.method_19538(), look, candidate) < 2.5) {
                candidate = candidate.method_1019(perp.method_1021((double)this.flankSign * 2.0));
            }
            if ((ground = this.findGroundNear(sw, candidate, 4)) != null) {
                class_243 go = new class_243((double)ground.method_10263() + 0.5, this.method_23318(), (double)ground.method_10260() + 0.5);
                this.method_5942().method_6337(go.field_1352, go.field_1351, go.field_1350, speed);
                this.smoothFace(go, 4.0f);
                return;
            }
            class_243 orbit = target.method_19538().method_1019(perp.method_1021((double)this.flankSign * 4.0)).method_1019(look.method_1021(3.0));
            orbit = new class_243(orbit.field_1352, this.method_23318(), orbit.field_1350);
            this.method_5942().method_6337(orbit.field_1352, orbit.field_1351, orbit.field_1350, speed);
            this.smoothFace(orbit, 4.0f);
        } else {
            class_243 face = new class_243(target.method_23317(), this.method_23318(), target.method_23321());
            this.smoothFace(face, 4.0f);
        }
    }

    private void pursueAmbushWhileUnseen(class_3218 sw, class_1657 target, double speed) {
        if (this.ambushRecalcTicks-- <= 0) {
            class_2338 ground;
            this.ambushRecalcTicks = 10 + sw.method_8409().method_43048(6);
            class_243 look = target.method_5828(1.0f).method_1029();
            double dist = Math.max(1.0, (double)this.method_5739((class_1297)target));
            double aheadDist = class_3532.method_15350((double)(dist * 0.8), (double)8.0, (double)16.0);
            if (sw.method_8409().method_43057() < 0.2f) {
                this.flankSign *= -1;
            }
            double flankOffset = 3.0 + sw.method_8409().method_43058() * 3.0;
            class_243 perp = new class_243(-look.field_1350, 0.0, look.field_1352).method_1029();
            class_243 candidate = target.method_19538().method_1019(look.method_1021(aheadDist)).method_1019(perp.method_1021((double)this.flankSign * flankOffset));
            candidate = new class_243(candidate.field_1352, this.method_23318(), candidate.field_1350);
            if (this.isInPlayerFovAngle(target, candidate, 30.0)) {
                candidate = target.method_19538().method_1019(look.method_1021(aheadDist)).method_1019(perp.method_1021((double)(-this.flankSign) * (flankOffset + 2.5)));
                candidate = new class_243(candidate.field_1352, this.method_23318(), candidate.field_1350);
            }
            if (this.distanceFromLineXZ(target.method_19538(), look, candidate) < 2.0) {
                candidate = candidate.method_1019(perp.method_1021((double)this.flankSign * 2.0));
            }
            if ((ground = this.findGroundNear(sw, candidate, 4)) != null) {
                class_243 go = new class_243((double)ground.method_10263() + 0.5, this.method_23318(), this.method_23321() + 0.5);
                this.method_5942().method_6337(go.field_1352, go.field_1351, go.field_1350, speed);
                this.smoothFace(go, 4.0f);
                return;
            }
            class_243 orbit = target.method_19538().method_1019(perp.method_1021((double)this.flankSign * 4.0)).method_1019(look.method_1021(2.0));
            orbit = new class_243(orbit.field_1352, this.method_23318(), orbit.field_1350);
            this.method_5942().method_6337(orbit.field_1352, orbit.field_1351, orbit.field_1350, speed);
            this.smoothFace(orbit, 4.0f);
        } else {
            class_243 face = new class_243(target.method_23317(), this.method_23318(), target.method_23321());
            this.smoothFace(face, 4.0f);
        }
    }

    private boolean isInPlayerFov(class_1657 player, class_243 point) {
        return this.isInPlayerFovAngle(player, point, 30.0);
    }

    private boolean isInPlayerFovAngle(class_1657 player, class_243 point, double fovDeg) {
        class_243 toP;
        class_243 eye = player.method_33571();
        class_243 look = player.method_5828(1.0f).method_1029();
        double dot = look.method_1026(toP = point.method_1020(eye).method_1029());
        return dot > Math.cos(Math.toRadians(fovDeg));
    }

    private double distanceFromLineXZ(class_243 lineOrigin, class_243 lineDir, class_243 point) {
        class_243 p0 = new class_243(lineOrigin.field_1352, 0.0, lineOrigin.field_1350);
        class_243 d = new class_243(lineDir.field_1352, 0.0, lineDir.field_1350).method_1029();
        class_243 p = new class_243(point.field_1352, 0.0, point.field_1350);
        class_243 w = p.method_1020(p0);
        double t = w.method_1026(d);
        class_243 proj = p0.method_1019(d.method_1021(t));
        return proj.method_1022(p);
    }

    private class_2338 findGroundNear(class_3218 sw, class_243 around, int radius) {
        int y = class_3532.method_15357((double)this.method_23318());
        int cx = class_3532.method_15357((double)around.field_1352);
        int cz = class_3532.method_15357((double)around.field_1350);
        class_2338.class_2339 m = new class_2338.class_2339();
        m.method_10103(cx, y, cz);
        if (this.isWalkable(sw, (class_2338)m)) {
            return m.method_10062();
        }
        for (int r = 1; r <= radius; ++r) {
            for (int x = cx - r; x <= cx + r; ++x) {
                m.method_10103(x, y, cz - r);
                if (this.isWalkable(sw, (class_2338)m)) {
                    return m.method_10062();
                }
                m.method_10103(x, y, cz + r);
                if (!this.isWalkable(sw, (class_2338)m)) continue;
                return m.method_10062();
            }
            for (int z = cz - r + 1; z <= cz + r - 1; ++z) {
                m.method_10103(cx - r, y, z);
                if (this.isWalkable(sw, (class_2338)m)) {
                    return m.method_10062();
                }
                m.method_10103(cx + r, y, z);
                if (!this.isWalkable(sw, (class_2338)m)) continue;
                return m.method_10062();
            }
        }
        return null;
    }

    private boolean isWalkable(class_3218 sw, class_2338 pos) {
        class_2338 below = pos.method_10074();
        return sw.method_8320(pos).method_26215() && sw.method_8320(pos.method_10084()).method_26215() && sw.method_8320(below).method_26216((class_1922)sw, below);
    }

    private boolean playerSeesEntityWide(class_1657 playerEye) {
        if (!playerEye.method_6057((class_1297)this) || !this.method_6057((class_1297)playerEye)) {
            return false;
        }
        class_243 eye = playerEye.method_33571();
        class_243 dir = playerEye.method_5828(1.0f).method_1029();
        class_243 target = this.method_19538().method_1031(0.0, (double)this.method_5751() * 0.5, 0.0);
        class_243 to = target.method_1020(eye);
        double forward = to.method_1026(dir);
        if (forward <= 0.0) {
            return false;
        }
        double angleCos = dir.method_1026(to.method_1029());
        if (angleCos >= Math.cos(Math.toRadians(45.0))) {
            return true;
        }
        class_243 closest = eye.method_1019(dir.method_1021(forward));
        double radialDistance = target.method_1022(closest);
        return radialDistance <= 1.6;
    }

    private void smoothFace(class_243 target, float maxChangeDeg) {
        float targetYaw = (float)(class_3532.method_15349((double)(target.field_1350 - this.method_23321()), (double)(target.field_1352 - this.method_23317())) * 57.29577951308232) - 90.0f;
        float newYaw = BacteriaEntity.smoothYaw(this.method_36454(), targetYaw, maxChangeDeg);
        this.method_36456(newYaw);
        this.field_6283 = newYaw;
        this.field_6241 = BacteriaEntity.smoothYaw(this.field_6241, newYaw, maxChangeDeg);
    }

    private static float smoothYaw(float currentYaw, float targetYaw, float maxChangeDeg) {
        float delta = class_3532.method_15393((float)(targetYaw - currentYaw));
        float newYaw = currentYaw + class_3532.method_15363((float)delta, (float)(-maxChangeDeg), (float)maxChangeDeg);
        return newYaw;
    }

    public static class_2338 findSpawnPosOutOfSight(class_3218 sw, class_1657 player, int minDist, int maxDist, int tries) {
        class_5819 rng = sw.method_8409();
        class_243 look = player.method_5828(1.0f).method_1029();
        int fixedY = class_3532.method_15357((double)player.method_23318());
        for (int i = 0; i < tries; ++i) {
            class_2338 spawn;
            double dist = minDist + rng.method_43048(maxDist - minDist + 1);
            double angle = Math.atan2(-look.field_1350, -look.field_1352) + (rng.method_43058() - 0.5) * Math.toRadians(120.0);
            int dx = class_3532.method_15357((double)(player.method_23317() + Math.cos(angle) * dist));
            int dz = class_3532.method_15357((double)(player.method_23321() + Math.sin(angle) * dist));
            class_2338.class_2339 m = new class_2338.class_2339(dx, fixedY, dz);
            class_2338 below = m.method_10074();
            if (!sw.method_8320((class_2338)m).method_26215() || !sw.method_8320(below).method_26216((class_1922)sw, below) || BacteriaEntity.wouldPlayerSeePos(player, spawn = m.method_10062(), sw)) continue;
            return spawn;
        }
        return null;
    }

    private static boolean wouldPlayerSeePos(class_1657 player, class_2338 pos, class_3218 sw) {
        boolean inFov;
        class_243 eye = player.method_33571();
        class_243 toPos = class_243.method_24953((class_2382)pos).method_1020(eye).method_1029();
        class_243 look = player.method_5828(1.0f).method_1029();
        double dot = look.method_1026(toPos);
        boolean bl = inFov = dot > Math.cos(Math.toRadians(35.0));
        if (!inFov) {
            return false;
        }
        class_3965 hit = sw.method_17742(new class_3959(eye, class_243.method_24953((class_2382)pos), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        return hit.method_17784().method_1025(class_243.method_24953((class_2382)pos)) < 0.25;
    }

    private void tickDormantSafety(class_3218 sw) {
        this.method_31472();
    }

    private static enum Phase {
        DORMANT,
        STALKING,
        CHASING;

    }
}

