/*
 * Decompiled with CFR 0.152.
 */
package synth_cat.escapethebackrooms.entity.custom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2784;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import synth_cat.escapethebackrooms.Dimension.ModDimensions;
import synth_cat.escapethebackrooms.entity.ModEntities;
import synth_cat.escapethebackrooms.entity.custom.BacteriaEntity;

public final class BacteriaSpawner {
    private static final int ONE_MINUTE = 2400;
    private static final Map<class_3218, Long> nextPickTick = new HashMap<class_3218, Long>();

    private BacteriaSpawner() {
    }

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(BacteriaSpawner::onEndTick);
    }

    private static void onEndTick(MinecraftServer server) {
        boolean hasBacteria;
        class_3218 world = server.method_3847(ModDimensions.LEVEL_0);
        if (world == null) {
            return;
        }
        long now = world.method_8510();
        List players = world.method_18766(p -> !p.method_7325() && p.method_5805());
        if (players.isEmpty()) {
            nextPickTick.remove(world);
            return;
        }
        class_2784 border = world.method_8621();
        class_2874 dim = world.method_8597();
        int minY = dim.comp_651();
        int maxY = minY + dim.comp_652();
        class_238 borderBox = new class_238(border.method_11976(), (double)minY, border.method_11958(), border.method_11963(), (double)maxY, border.method_11977());
        boolean bl = hasBacteria = !world.method_8390(BacteriaEntity.class, borderBox, e -> true).isEmpty();
        if (hasBacteria) {
            return;
        }
        if (!nextPickTick.containsKey(world)) {
            nextPickTick.put(world, now + 2400L);
            return;
        }
        long fireAt = nextPickTick.get(world);
        if (now < fireAt) {
            return;
        }
        class_3222 pick = (class_3222)players.get(world.method_8409().method_43048(players.size()));
        class_2338 spawn = BacteriaSpawner.tryFindAheadSideSpawn(world, pick, 12, 24, 5, 8, 16);
        if (spawn == null) {
            spawn = BacteriaEntity.findSpawnPosOutOfSight(world, (class_1657)pick, 10, 20, 12);
        }
        if (spawn == null) {
            nextPickTick.put(world, now + 60L);
            return;
        }
        BacteriaEntity entity = (BacteriaEntity)ModEntities.BACTERIA.method_5883((class_1937)world);
        if (entity == null) {
            nextPickTick.put(world, now + 60L);
            return;
        }
        entity.method_23327((double)spawn.method_10263() + 0.5, spawn.method_10264(), (double)spawn.method_10260() + 0.5);
        world.method_8649((class_1297)entity);
        entity.wakeAndTarget((class_1657)pick, spawn);
        nextPickTick.remove(world);
    }

    private static class_2338 tryFindAheadSideSpawn(class_3218 world, class_3222 player, int minAhead, int maxAhead, int sideMin, int sideMax, int tries) {
        class_5819 rng = world.method_8409();
        class_243 look = player.method_5828(1.0f).method_1029();
        class_243 perp = new class_243(-look.field_1350, 0.0, look.field_1352).method_1029();
        int fixedY = class_3532.method_15357((double)player.method_23318());
        for (int i = 0; i < tries; ++i) {
            int z;
            double ahead = minAhead + rng.method_43048(maxAhead - minAhead + 1);
            int side = sideMin + rng.method_43048(sideMax - sideMin + 1);
            int sign = rng.method_43056() ? 1 : -1;
            double jitterA = (rng.method_43058() - 0.5) * 2.0;
            double jitterS = (rng.method_43058() - 0.5) * 1.5;
            class_243 aheadPos = player.method_19538().method_1019(look.method_1021(ahead + jitterA)).method_1019(perp.method_1021((double)sign * ((double)side + jitterS)));
            int x = class_3532.method_15357((double)aheadPos.field_1352);
            class_2338.class_2339 m = new class_2338.class_2339(x, fixedY, z = class_3532.method_15357((double)aheadPos.field_1350));
            if (!BacteriaSpawner.isWalkable(world, (class_2338)m)) continue;
            if (BacteriaSpawner.wouldPlayerSeePos(world, player, (class_2338)m)) {
                class_243 alt = player.method_19538().method_1019(look.method_1021(ahead + jitterA)).method_1019(perp.method_1021((double)(-sign) * ((double)side + 1.5 + jitterS)));
                int ax = class_3532.method_15357((double)alt.field_1352);
                int az = class_3532.method_15357((double)alt.field_1350);
                m.method_10103(ax, fixedY, az);
                if (!BacteriaSpawner.isWalkable(world, (class_2338)m) || BacteriaSpawner.wouldPlayerSeePos(world, player, (class_2338)m)) continue;
            }
            return m.method_10062();
        }
        return null;
    }

    private static boolean isWalkable(class_3218 sw, class_2338 pos) {
        class_2338 below = pos.method_10074();
        return sw.method_8320(pos).method_26215() && sw.method_8320(pos.method_10084()).method_26215() && sw.method_8320(below).method_26216((class_1922)sw, below);
    }

    private static boolean wouldPlayerSeePos(class_3218 world, class_3222 player, class_2338 pos) {
        boolean inFov;
        class_243 eye = player.method_33571();
        class_243 toPos = class_243.method_24953((class_2382)pos).method_1020(eye).method_1029();
        class_243 look = player.method_5828(1.0f).method_1029();
        double dot = look.method_1026(toPos);
        boolean bl = inFov = dot > Math.cos(Math.toRadians(35.0));
        if (!inFov) {
            return false;
        }
        class_3965 hit = world.method_17742(new class_3959(eye, class_243.method_24953((class_2382)pos), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        return hit.method_17784().method_1025(class_243.method_24953((class_2382)pos)) < 0.25;
    }
}

