/*
 * Decompiled with CFR 0.152.
 */
package evertech1.pingcounter;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import evertech1.pingcounter.Config;
import evertech1.pingcounter.PingCounter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigHandler {
    private static final Gson gson = new Gson();
    public static Config config = new Config();

    private static void createFile() {
        File f = new File("./config/pingcounter.json");
        try {
            if (f.createNewFile()) {
                ConfigHandler.updateValues();
            }
        }
        catch (IOException e) {
            PingCounter.LOGGER.error("Failed to create config file", (Throwable)e);
        }
    }

    public static void getValues() {
        ConfigHandler.createFile();
        try (FileReader file = new FileReader("./config/pingcounter.json");){
            try {
                config = (Config)gson.fromJson((Reader)file, Config.class);
            }
            catch (JsonSyntaxException ignored) {
                ConfigHandler.updateValues();
            }
        }
        catch (IOException e) {
            PingCounter.LOGGER.error("Failed to read config file", (Throwable)e);
        }
    }

    public static void updateValues() {
        ConfigHandler.createFile();
        try (FileWriter file = new FileWriter("./config/pingcounter.json");){
            gson.toJson((Object)config, (Appendable)file);
        }
        catch (IOException e) {
            PingCounter.LOGGER.error("Failed to update config file", (Throwable)e);
        }
    }

    static {
        ConfigHandler.createFile();
    }
}

