/*
 * Decompiled with CFR 0.152.
 */
package evertech1.pingcounter;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import evertech1.pingcounter.PingCounter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;

public class VersionChecker {
    private static final Gson gson = new Gson();
    private static final String updateUrl = "https://gist.githubusercontent.com/EverTech1/73f21b840a9309420c0c1b8156cc17e3/raw/updateFabric.json";
    public static Results result = Results.NOT_STARTED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readUrl() throws Exception {
        try (BufferedReader reader = null;){
            int read;
            URL url = URI.create(updateUrl).toURL();
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuilder buffer = new StringBuilder();
            char[] chars = new char[1024];
            while ((read = reader.read(chars)) != -1) {
                buffer.append(chars, 0, read);
            }
            String string = buffer.toString();
            return string;
        }
    }

    private static Results parseResults(Versions versions) {
        String[] current = PingCounter.MOD_VERSION.split("\\.");
        String[] lastImportant = versions.lastImportant.split("\\.");
        int diffMajor = Integer.parseInt(lastImportant[0]) - Integer.parseInt(current[0]);
        int diffMinor = Integer.parseInt(lastImportant[1]) - Integer.parseInt(current[1]);
        int diffPatch = Integer.parseInt(lastImportant[2]) - Integer.parseInt(current[2]);
        if (diffMajor > 0) {
            return Results.OLD;
        }
        if (diffMajor < 0) {
            return Results.AHEAD;
        }
        if (diffMinor > 0) {
            return Results.OLD;
        }
        if (diffMinor < 0) {
            return Results.AHEAD;
        }
        if (diffPatch > 0) {
            return Results.OLD;
        }
        if (diffPatch < 0) {
            return Results.AHEAD;
        }
        return Results.UP_TO_DATE;
    }

    public static void startCheck() {
        if (result != Results.STARTED) {
            PingCounter.LOGGER.info("Started version check");
            result = Results.STARTED;
            Thread checkThread = new Thread(() -> {
                try {
                    Versions versions = (Versions)gson.fromJson(VersionChecker.readUrl(), Versions.class);
                    result = VersionChecker.parseResults(versions);
                }
                catch (Exception e) {
                    PingCounter.LOGGER.error("Failed to check version", (Throwable)e);
                    result = Results.FAILED;
                }
                PingCounter.LOGGER.info("Version check complete: {}", (Object)result.toString());
            });
            checkThread.setName("VersionCheck");
            checkThread.start();
        }
    }

    private static class Versions {
        @SerializedName(value="1.21.6-latest")
        String latest;
        @SerializedName(value="1.21.6-lastImportant")
        String lastImportant;

        private Versions() {
        }
    }

    public static enum Results {
        NOT_STARTED,
        STARTED,
        FAILED,
        OLD,
        UP_TO_DATE,
        AHEAD;

    }
}

