/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.mixins;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.EnumMap;
import java.util.Map;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={WallSignBlock.class})
public abstract class WallSignMixin
extends Block {
    @Unique
    private static final EnumMap<Direction, VoxelShape> AMENDMENTS_VISUAL_SHAPE = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)0.0, (double)4.0, (double)14.0, (double)16.0, (double)13.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)13.0, (double)2.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)4.0, (double)0.0, (double)2.0, (double)13.0, (double)16.0), (Object)Direction.WEST, (Object)Block.box((double)14.0, (double)4.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0)));

    public WallSignMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @ModifyReturnValue(method={"getShape(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/BlockGetter;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/phys/shapes/CollisionContext;)Lnet/minecraft/world/phys/shapes/VoxelShape;"}, at={@At(value="RETURN")})
    public VoxelShape getShape(VoxelShape original, BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (level instanceof Level) {
            Level l = (Level)level;
            if (l.isClientSide && ClientConfigs.PIXEL_CONSISTENT_SIGNS.get().booleanValue()) {
                return AMENDMENTS_VISUAL_SHAPE.get(state.getValue((Property)WallSignBlock.FACING));
            }
        }
        return original;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

