/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.spelunkerstorch;

import games.alejandrocoria.spelunkerstorch.Constants;
import games.alejandrocoria.spelunkerstorch.Registry;
import games.alejandrocoria.spelunkerstorch.common.block.entity.TorchEntity;
import games.alejandrocoria.spelunkerstorch.common.mixin.server.ChunkMapAccessor;
import games.alejandrocoria.spelunkerstorch.common.pathfinding.PathFindingCache;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SpelunkersTorch {
    private static final int WAIT_TIME_TO_UPDATE = 100;
    private static final Object2ObjectMap<ServerLevel, LongSet> sectionsToUpdate = new Object2ObjectAVLTreeMap(Comparator.comparingInt(Object::hashCode));
    private static long lastAddedSectionToUpdate = 9223372036854775707L;
    private static final Object2ObjectMap<ServerLevel, LongSet> sectionsToMonitor = new Object2ObjectAVLTreeMap(Comparator.comparingInt(Object::hashCode));

    public static void init() {
    }

    public static void updateNearbyOnRemove(Level level, BlockPos blockPos) {
        TorchEntity torchTarget;
        List<TorchEntity> nearbyTorches = SpelunkersTorch.getNearbyTorchEntities(level, blockPos);
        nearbyTorches.stream().filter(t -> blockPos.equals((Object)t.getTarget())).forEach(TorchEntity::needNewTarget);
        TorchEntity torch = TorchEntity.getFromBlockPos(level, blockPos);
        if (torch != null && torch.hasTarget() && (torchTarget = TorchEntity.getFromBlockPos(level, torch.getTarget())) != null) {
            torchTarget.removeIncoming(blockPos);
        }
    }

    public static List<TorchEntity> getTorchesInNearbySections(Level level, SectionPos sectionPos) {
        ArrayList<ChunkAccess> chunks = new ArrayList<ChunkAccess>();
        for (int z = sectionPos.z() - 1; z < sectionPos.z() + 2; ++z) {
            for (int x = sectionPos.x() - 1; x < sectionPos.x() + 2; ++x) {
                ChunkAccess chunk = level.getChunk(x, z, ChunkStatus.FULL, false);
                if (chunk == null) continue;
                chunks.add(chunk);
            }
        }
        ArrayList<TorchEntity> torches = new ArrayList<TorchEntity>();
        for (ChunkAccess chunk : chunks) {
            Set entityPositions = chunk.getBlockEntitiesPos();
            for (BlockPos pos : entityPositions) {
                if (pos.getY() < sectionPos.minBlockY() - 16 || pos.getY() > sectionPos.maxBlockY() + 16) continue;
                Optional blockEntity = chunk.getBlockEntity(pos, Registry.TORCH_ENTITY.get());
                blockEntity.ifPresent(torches::add);
            }
        }
        return torches;
    }

    public static List<TorchEntity> getNearbyTorchEntities(Level level, BlockPos blockPos) {
        List<TorchEntity> torches = SpelunkersTorch.getTorchesInNearbySections(level, SectionPos.of((BlockPos)blockPos));
        torches.removeIf(t -> {
            double distance = t.getBlockPos().distSqr((Vec3i)blockPos);
            return distance > 256.0 || distance <= 0.5;
        });
        return torches;
    }

    public static Optional<TorchEntity> getTorchEntity(Level level, BlockPos blockPos) {
        return level.getChunkAt(blockPos).getBlockEntity(blockPos, Registry.TORCH_ENTITY.get());
    }

    public static int recalculateTorches(Level level) {
        try {
            int count = 0;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Long2ObjectLinkedOpenHashMap<ChunkHolder> chunks = ((ChunkMapAccessor)serverLevel.getChunkSource().chunkMap).getVisibleChunkMap();
                for (Long chunkPos : chunks.keySet()) {
                    count += SpelunkersTorch.recalculateTorches(level, new ChunkPos(chunkPos.longValue()));
                }
            }
            return count;
        }
        catch (Exception e) {
            Constants.LOG.error("Error in recalculateTorches", (Throwable)e);
            return 0;
        }
    }

    public static int recalculateTorches(Level level, ChunkPos chunkPos) {
        if (!SpelunkersTorch.allNeighborsChunksLoaded(level, chunkPos)) {
            return 0;
        }
        int count = 0;
        ChunkAccess chunk = level.getChunk(chunkPos.x, chunkPos.z, ChunkStatus.FULL, false);
        Set entityPositions = chunk.getBlockEntitiesPos();
        for (BlockPos pos : entityPositions) {
            Optional blockEntity = chunk.getBlockEntity(pos, Registry.TORCH_ENTITY.get());
            blockEntity.ifPresent(TorchEntity::needNewTarget);
            if (!blockEntity.isPresent()) continue;
            ++count;
        }
        return count;
    }

    public static int recalculateTorches(Level level, SectionPos sectionPos) {
        if (!SpelunkersTorch.allNeighborsChunksLoaded(level, sectionPos.chunk())) {
            return -1;
        }
        int count = 0;
        ChunkAccess chunk = level.getChunk(sectionPos.x(), sectionPos.z(), ChunkStatus.FULL, false);
        Set entityPositions = chunk.getBlockEntitiesPos();
        for (BlockPos pos : entityPositions) {
            if (pos.getY() / 16 != sectionPos.y()) continue;
            Optional blockEntity = chunk.getBlockEntity(pos, Registry.TORCH_ENTITY.get());
            blockEntity.ifPresent(TorchEntity::needNewTarget);
            if (!blockEntity.isPresent()) continue;
            ++count;
        }
        return count;
    }

    public static boolean recalculateTorch(Level level, BlockPos blockPos) {
        Optional blockEntity = level.getBlockEntity(blockPos, Registry.TORCH_ENTITY.get());
        blockEntity.ifPresent(TorchEntity::needNewTarget);
        return blockEntity.isPresent();
    }

    @Nullable
    public static BlockPos recalculateClosestTorch(Level level, BlockPos blockPos) {
        List<TorchEntity> nearbyTorches = SpelunkersTorch.getNearbyTorchEntities(level, blockPos);
        Optional closestTorch = nearbyTorches.stream().min((t1, t2) -> TorchEntity.distanceComparator(blockPos, t1, t2));
        closestTorch.ifPresent(TorchEntity::needNewTarget);
        return closestTorch.map(BlockEntity::getBlockPos).orElse(null);
    }

    public static boolean allNeighborsChunksLoaded(Level level, ChunkPos chunkPos) {
        Cursor3D cursor = new Cursor3D(chunkPos.x - 1, 0, chunkPos.z - 1, chunkPos.x + 1, 0, chunkPos.z + 1);
        while (cursor.advance()) {
            if (level.getChunk(cursor.nextX(), cursor.nextZ(), ChunkStatus.FULL, false) != null) continue;
            return false;
        }
        return true;
    }

    public static void onBlockUpdated(ServerLevel level, BlockPos pos, BlockState blockState) {
        SectionPos sectionPos = SectionPos.of((BlockPos)pos);
        LongSet sections = (LongSet)sectionsToMonitor.get((Object)level);
        if (sections == null || !sections.contains(sectionPos.asLong())) {
            return;
        }
        PathFindingCache.removeIfChanged(pos, blockState);
        SpelunkersTorch.addSectionAndNeighborsToMap(level, sectionPos, sectionsToUpdate);
        if (lastAddedSectionToUpdate - 100L > System.currentTimeMillis()) {
            lastAddedSectionToUpdate = System.currentTimeMillis();
        }
    }

    public static void serverTick() {
        if (lastAddedSectionToUpdate + 100L > System.currentTimeMillis()) {
            return;
        }
        ObjectIterator mapIterator = sectionsToUpdate.entrySet().iterator();
        while (mapIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)mapIterator.next();
            LongIterator setIterator = ((LongSet)entry.getValue()).iterator();
            while (setIterator.hasNext()) {
                int count = SpelunkersTorch.recalculateTorches((Level)entry.getKey(), SectionPos.of((long)setIterator.nextLong()));
                if (count <= -1) continue;
                setIterator.remove();
            }
            if (!((LongSet)entry.getValue()).isEmpty()) continue;
            mapIterator.remove();
        }
        lastAddedSectionToUpdate = sectionsToUpdate.isEmpty() ? 9223372036854775707L : System.currentTimeMillis();
    }

    public static void addSectionAndNeighborsToMonitor(ServerLevel level, SectionPos sectionPos) {
        SpelunkersTorch.addSectionAndNeighborsToMap(level, sectionPos, sectionsToMonitor);
    }

    public static void updateSectionAndNeighbors(ServerLevel level, SectionPos sectionPos) {
        SpelunkersTorch.addSectionAndNeighborsToMap(level, sectionPos, sectionsToUpdate);
    }

    private static void addSectionAndNeighborsToMap(ServerLevel level, SectionPos sectionPos, Object2ObjectMap<ServerLevel, LongSet> targetMap) {
        LongSet sections = (LongSet)targetMap.computeIfAbsent((Object)level, l -> new LongAVLTreeSet());
        Cursor3D cursor = new Cursor3D(sectionPos.x() - 1, Mth.clamp((int)(sectionPos.y() - 1), (int)level.getMinSectionY(), (int)level.getMaxSectionY()), sectionPos.z() - 1, sectionPos.x() + 1, Mth.clamp((int)(sectionPos.y() + 1), (int)level.getMinSectionY(), (int)level.getMaxSectionY()), sectionPos.z() + 1);
        while (cursor.advance()) {
            sections.add(SectionPos.asLong((int)cursor.nextX(), (int)cursor.nextY(), (int)cursor.nextZ()));
        }
    }
}

