/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.spelunkerstorch.client;

import games.alejandrocoria.spelunkerstorch.Constants;
import games.alejandrocoria.spelunkerstorch.Registry;
import games.alejandrocoria.spelunkerstorch.SpelunkersTorch;
import games.alejandrocoria.spelunkerstorch.client.renderer.TorchRenderer;
import games.alejandrocoria.spelunkerstorch.common.block.entity.TorchEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public class SpelunkersTorchClient {
    private static final SectionPos INVALID_PLAYER_POSITION;
    private static SectionPos lastPlayerPosition;
    private static List<TorchEntity> closestTorches;

    public static void registerBlockEntityRenderer() {
        BlockEntityRenderers.register(Registry.TORCH_ENTITY.get(), TorchRenderer::new);
    }

    public static List<TorchEntity> getTorchesInNearbySections(ClientLevel level, SectionPos playerPosition) {
        if (!level.isClientSide()) {
            Constants.LOG.error("SpelunkersTorchClient.getTorchesInNearbySections should be called only in the client.");
            return new ArrayList<TorchEntity>();
        }
        if (lastPlayerPosition.equals((Object)playerPosition)) {
            return closestTorches;
        }
        closestTorches = SpelunkersTorch.getTorchesInNearbySections((Level)level, playerPosition);
        lastPlayerPosition = playerPosition;
        return closestTorches;
    }

    public static void torchEntityAddedOrRemoved(TorchEntity torchEntity) {
        if (torchEntity.getLevel() != null && !torchEntity.getLevel().isClientSide()) {
            Constants.LOG.error("SpelunkersTorchClient.torchEntityAddedOrRemoved should be called only in the client.");
            return;
        }
        lastPlayerPosition = INVALID_PLAYER_POSITION;
    }

    static {
        lastPlayerPosition = INVALID_PLAYER_POSITION = SectionPos.of((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE);
        closestTorches = new ArrayList<TorchEntity>();
    }
}

