/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.spelunkerstorch.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import games.alejandrocoria.spelunkerstorch.client.renderer.NeedleRenderType;
import games.alejandrocoria.spelunkerstorch.client.renderer.TorchRenderState;
import games.alejandrocoria.spelunkerstorch.common.block.WallTorch;
import games.alejandrocoria.spelunkerstorch.common.block.entity.TorchEntity;
import games.alejandrocoria.spelunkerstorch.common.util.Util;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TorchRenderer
implements BlockEntityRenderer<TorchEntity, TorchRenderState> {
    private static final float NEEDLE_HALF_WIDTH = 0.12f;
    private static final float NEEDLE_LENGTH = 0.23f;
    private static final Vector3f[] VERTICES = new Vector3f[]{new Vector3f(0.0f, 0.12f, 0.0f), new Vector3f(0.12f, 0.0f, 0.0f), new Vector3f(0.0f, -0.12f, 0.0f), new Vector3f(-0.12f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.23f)};
    private static final Vector3f[] NORMALS = new Vector3f[]{Util.getNormal(VERTICES[0], VERTICES[4], VERTICES[1]), Util.getNormal(VERTICES[1], VERTICES[4], VERTICES[2]), Util.getNormal(VERTICES[2], VERTICES[4], VERTICES[3]), Util.getNormal(VERTICES[3], VERTICES[4], VERTICES[0]), Util.getNormal(VERTICES[0], VERTICES[1], VERTICES[2]), Util.getNormal(VERTICES[2], VERTICES[3], VERTICES[0])};

    public TorchRenderer(BlockEntityRendererProvider.Context context) {
    }

    public TorchRenderState createRenderState() {
        return new TorchRenderState();
    }

    public void extractRenderState(TorchEntity torchEntity, TorchRenderState torchRenderState, float partialTick, Vec3 vec3, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase((BlockEntity)torchEntity, (BlockEntityRenderState)torchRenderState, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        torchRenderState.rotation = torchEntity.getRotation();
    }

    public void submit(TorchRenderState torchRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState) {
        if (torchRenderState.rotation == null) {
            return;
        }
        poseStack.pushPose();
        Optional<Direction> direction = torchRenderState.blockState.getOptionalValue((Property)WallTorch.FACING).map(Direction::getOpposite);
        direction.ifPresent(value -> poseStack.translate((double)value.getStepX() * 0.27, 0.22, (double)value.getStepZ() * 0.27));
        TorchRenderer.renderNeedle(poseStack, torchRenderState.rotation, torchRenderState.lightCoords, submitNodeCollector);
        poseStack.popPose();
    }

    public static void renderNeedle(PoseStack poseStack, Quaternionf rotation, int light, SubmitNodeCollector submitNodeCollector) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.75, 0.5);
        poseStack.rotateAround((Quaternionfc)rotation, 0.0f, 0.0f, 0.0f);
        poseStack.translate(0.0, 0.0, 0.125);
        submitNodeCollector.submitCustomGeometry(poseStack, NeedleRenderType.getRenderType(), (pose, vertexConsumer) -> {
            vertexConsumer.addVertex(pose, VERTICES[0]).setColor(-1).setUv(0.25f, 0.25f).setNormal(pose, NORMALS[0]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[4]).setColor(-1).setUv(0.75f, 0.25f).setNormal(pose, NORMALS[0]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[1]).setColor(-1).setUv(0.25f, 0.25f).setNormal(pose, NORMALS[0]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[1]).setColor(-1).setUv(0.25f, 0.25f).setNormal(pose, NORMALS[1]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[4]).setColor(-1).setUv(0.75f, 0.25f).setNormal(pose, NORMALS[1]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[2]).setColor(-1).setUv(0.25f, 0.25f).setNormal(pose, NORMALS[1]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[2]).setColor(-1).setUv(0.25f, 0.25f).setNormal(pose, NORMALS[2]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[4]).setColor(-1).setUv(0.75f, 0.25f).setNormal(pose, NORMALS[2]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[3]).setColor(-1).setUv(0.25f, 0.25f).setNormal(pose, NORMALS[2]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[3]).setColor(-1).setUv(0.25f, 0.25f).setNormal(pose, NORMALS[3]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[4]).setColor(-1).setUv(0.75f, 0.25f).setNormal(pose, NORMALS[3]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[0]).setColor(-1).setUv(0.25f, 0.25f).setNormal(pose, NORMALS[3]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[0]).setColor(-1).setUv(0.25f, 0.25f).setNormal(pose, NORMALS[4]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[1]).setColor(-1).setUv(0.25f, 0.25f).setNormal(pose, NORMALS[4]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[2]).setColor(-1).setUv(0.25f, 0.25f).setNormal(pose, NORMALS[4]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[2]).setColor(-1).setUv(0.25f, 0.25f).setNormal(pose, NORMALS[5]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[3]).setColor(-1).setUv(0.25f, 0.25f).setNormal(pose, NORMALS[5]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
            vertexConsumer.addVertex(pose, VERTICES[0]).setColor(-1).setUv(0.25f, 0.25f).setNormal(pose, NORMALS[5]).setLight(light).setOverlay(OverlayTexture.NO_OVERLAY);
        });
        poseStack.popPose();
    }
}

