/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.spelunkerstorch.common.block;

import com.mojang.serialization.MapCodec;
import games.alejandrocoria.spelunkerstorch.common.block.entity.TorchEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class Torch
extends TorchBlock
implements EntityBlock {
    public static final BooleanProperty HAS_TARGET = BooleanProperty.create((String)"has_target");
    public static final MapCodec<Torch> CODEC = Torch.simpleCodec(Torch::new);

    public Torch(BlockBehaviour.Properties properties) {
        super(ParticleTypes.FLAME, properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HAS_TARGET, (Comparable)Boolean.valueOf(false)));
    }

    public MapCodec<? extends Torch> codec() {
        return CODEC;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState state) {
        return new TorchEntity(blockPos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return TorchEntity.createTicker(level, blockEntityType);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HAS_TARGET});
    }
}

