/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.spelunkerstorch.common.block.entity;

import games.alejandrocoria.spelunkerstorch.Constants;
import games.alejandrocoria.spelunkerstorch.Registry;
import games.alejandrocoria.spelunkerstorch.SpelunkersTorch;
import games.alejandrocoria.spelunkerstorch.client.SpelunkersTorchClient;
import games.alejandrocoria.spelunkerstorch.common.block.Torch;
import games.alejandrocoria.spelunkerstorch.common.pathfinding.Path;
import games.alejandrocoria.spelunkerstorch.common.pathfinding.PathFinder;
import games.alejandrocoria.spelunkerstorch.common.util.Util;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@FieldsAreNonnullByDefault
public class TorchEntity
extends BlockEntity {
    private static final BlockPos TARGET_NOT_CALCULATED = new BlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private static final int DATA_VERSION = 1;
    private int dataVersion = 1;
    private long date;
    @Nullable
    private BlockPos target = TARGET_NOT_CALCULATED;
    private List<BlockPos> incoming = new ArrayList<BlockPos>();
    private List<BlockPos> path = new ArrayList<BlockPos>();
    @Nullable
    private Quaternionf cachedRotation;

    public TorchEntity(BlockPos blockPos, BlockState state) {
        super(Registry.TORCH_ENTITY.get(), blockPos, state);
        this.date = Instant.now().toEpochMilli();
    }

    public long getDate() {
        return this.date;
    }

    @Nullable
    public BlockPos getTarget() {
        return this.target;
    }

    public List<BlockPos> getIncoming() {
        return this.incoming;
    }

    public List<BlockPos> getPath() {
        return this.path;
    }

    @Nullable
    public Quaternionf getRotation() {
        if (this.cachedRotation == null) {
            this.recalculateRotation();
        }
        return this.cachedRotation;
    }

    public void needNewTarget() {
        this.target = TARGET_NOT_CALCULATED;
    }

    public void recalculateTargetIfNeeded() {
        if (this.level == null || !TARGET_NOT_CALCULATED.equals((Object)this.target)) {
            return;
        }
        this.setBlock();
        PathFinder pathFinder = new PathFinder(this.level, this.worldPosition);
        Path result = pathFinder.calculateMinPath();
        if (result != null) {
            this.path = result.positions;
            this.target = this.path.getLast();
            this.setBlock();
            SpelunkersTorch.getTorchEntity(this.level, this.target).ifPresent(t -> t.addIncoming(this.worldPosition));
        } else {
            this.target = null;
            this.path.clear();
        }
    }

    private void addIncoming(BlockPos torch) {
        if (!this.incoming.contains(torch)) {
            this.incoming.add(torch);
            this.setBlock(true);
        }
    }

    public void removeIncoming(BlockPos torch) {
        if (this.incoming.remove(torch)) {
            this.setBlock(true);
        }
    }

    private void setBlock() {
        this.setBlock(false);
    }

    private void setBlock(boolean forceChange) {
        if (this.level != null && this.level.getBlockState(this.worldPosition) == this.getBlockState()) {
            if (forceChange) {
                this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)Torch.HAS_TARGET, (Comparable)Boolean.valueOf(!this.hasTarget())), 2);
            }
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)Torch.HAS_TARGET, (Comparable)Boolean.valueOf(this.hasTarget())), 2);
        }
    }

    public int distanceComparator(TorchEntity t1, TorchEntity t2) {
        int distance2;
        int distance1 = this.worldPosition.distManhattan((Vec3i)t1.worldPosition);
        if (distance1 == (distance2 = this.worldPosition.distManhattan((Vec3i)t2.worldPosition))) {
            return Long.compare(t1.date, t2.date);
        }
        return distance1 - distance2;
    }

    public boolean hasTarget() {
        return this.target != null && !TARGET_NOT_CALCULATED.equals((Object)this.target);
    }

    private void recalculateRotation() {
        if (!this.hasTarget()) {
            this.cachedRotation = null;
            return;
        }
        BlockPos toTarget = this.target.subtract((Vec3i)this.worldPosition);
        this.cachedRotation = Util.getRotation(Vec3.atLowerCornerOf((Vec3i)toTarget));
    }

    public void setLevel(Level level) {
        super.setLevel(level);
        if (this.level != null) {
            if (this.level.isClientSide()) {
                SpelunkersTorchClient.torchEntityAddedOrRemoved(this);
            } else {
                SpelunkersTorch.addSectionAndNeighborsToMonitor((ServerLevel)this.level, SectionPos.of((BlockPos)this.worldPosition));
                if (this.dataVersion < 1) {
                    SpelunkersTorch.updateSectionAndNeighbors((ServerLevel)this.level, SectionPos.of((BlockPos)this.worldPosition));
                }
            }
        }
    }

    public void setRemoved() {
        super.setRemoved();
        if (this.level != null && this.level.isClientSide()) {
            SpelunkersTorchClient.torchEntityAddedOrRemoved(this);
        }
    }

    public void clearRemoved() {
        super.clearRemoved();
        if (this.level != null && this.level.isClientSide()) {
            SpelunkersTorchClient.torchEntityAddedOrRemoved(this);
        }
    }

    public void preRemoveSideEffects(BlockPos blockPos, BlockState blockState) {
        super.preRemoveSideEffects(blockPos, blockState);
        if (this.level != null && !this.level.isClientSide()) {
            SpelunkersTorch.updateNearbyOnRemove(this.level, blockPos);
        }
    }

    protected void saveAdditional(ValueOutput valueOutput) {
        try {
            ValueOutput.TypedOutputList outputList;
            super.saveAdditional(valueOutput);
            valueOutput.putLong("Date", this.date);
            valueOutput.putInt("DataVersion", 1);
            if (this.hasTarget()) {
                valueOutput.store("Target", BlockPos.CODEC, (Object)this.target);
            }
            if (!this.incoming.isEmpty()) {
                outputList = valueOutput.list("Incoming", BlockPos.CODEC);
                this.incoming.forEach(arg_0 -> ((ValueOutput.TypedOutputList)outputList).add(arg_0));
            }
            if (!this.path.isEmpty()) {
                outputList = valueOutput.list("Path", BlockPos.CODEC);
                this.path.forEach(arg_0 -> ((ValueOutput.TypedOutputList)outputList).add(arg_0));
            }
        }
        catch (Exception e) {
            Constants.LOG.error("Error in TorchEntity.saveAdditional", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAdditional(ValueInput valueInput) {
        try {
            super.loadAdditional(valueInput);
            this.date = valueInput.getLongOr("Date", 0L);
            int version = valueInput.getIntOr("DataVersion", 0);
            if (version < 1) {
                this.dataVersion = version;
                this.target = TARGET_NOT_CALCULATED;
                this.incoming.clear();
                this.path.clear();
                this.cachedRotation = null;
                return;
            }
            this.target = valueInput.read("Target", BlockPos.CODEC).orElse(null);
            this.incoming.clear();
            Optional incomingList = valueInput.list("Incoming", BlockPos.CODEC);
            incomingList.ifPresent(blockPos -> blockPos.stream().forEach(this.incoming::add));
            this.path.clear();
            Optional pathList = valueInput.list("Path", BlockPos.CODEC);
            pathList.ifPresent(blockPos -> blockPos.stream().forEach(this.path::add));
        }
        catch (Exception e) {
            this.target = TARGET_NOT_CALCULATED;
            this.incoming.clear();
            this.path.clear();
            Constants.LOG.error("Error in TorchEntity.load", (Throwable)e);
        }
        finally {
            this.cachedRotation = null;
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Nullable
    public static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockEntityType<T> blockEntityType) {
        if (!level.isClientSide() && blockEntityType == Registry.TORCH_ENTITY.get()) {
            return (l, p, s, blockEntity) -> ((TorchEntity)blockEntity).recalculateTargetIfNeeded();
        }
        return null;
    }

    @Nullable
    public static TorchEntity getFromBlockPos(Level level, BlockPos blockPos) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity != null && blockEntity.getType() == Registry.TORCH_ENTITY.get()) {
            return (TorchEntity)blockEntity;
        }
        return null;
    }

    public static int distanceComparator(BlockPos position, TorchEntity t1, TorchEntity t2) {
        int distance = (int)(position.distSqr((Vec3i)t1.getBlockPos()) - position.distSqr((Vec3i)t2.getBlockPos()));
        if (distance == 0) {
            return Long.compare(t1.getDate(), t2.getDate());
        }
        return distance;
    }
}

