/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.spelunkerstorch.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import games.alejandrocoria.spelunkerstorch.SpelunkersTorch;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class CommandRecalculate {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spelunkerstorch").requires(commandSource -> commandSource.hasPermission(2))).then(Commands.literal((String)"loaded").executes(CommandRecalculate::recalculateLoaded))).then(Commands.literal((String)"chunk").executes(CommandRecalculate::recalculateChunk))).then(Commands.literal((String)"section").executes(CommandRecalculate::recalculateSection))).then(Commands.literal((String)"single").executes(CommandRecalculate::recalculateClosest))).then(Commands.literal((String)"single").then(Commands.argument((String)"location", (ArgumentType)Vec3Argument.vec3()).executes(commandSource -> CommandRecalculate.recalculateSingle((CommandContext<CommandSourceStack>)commandSource, Vec3Argument.getCoordinates((CommandContext)commandSource, (String)"location"))))));
    }

    private static int recalculateLoaded(CommandContext<CommandSourceStack> ctx) {
        int count = SpelunkersTorch.recalculateTorches((Level)((CommandSourceStack)ctx.getSource()).getLevel());
        if (count > 0 && ((CommandSourceStack)ctx.getSource()).isPlayer()) {
            ((CommandSourceStack)ctx.getSource()).getPlayer().sendSystemMessage((Component)Component.translatable((String)"chat.spelunkerstorch.recalculated_loaded", (Object[])new Object[]{count}));
        }
        return count;
    }

    private static int recalculateChunk(CommandContext<CommandSourceStack> ctx) {
        ChunkPos chunkPos = new ChunkPos(BlockPos.containing((Position)((CommandSourceStack)ctx.getSource()).getPosition()));
        int count = SpelunkersTorch.recalculateTorches((Level)((CommandSourceStack)ctx.getSource()).getLevel(), chunkPos);
        if (count > 0 && ((CommandSourceStack)ctx.getSource()).isPlayer()) {
            ((CommandSourceStack)ctx.getSource()).getPlayer().sendSystemMessage((Component)Component.translatable((String)"chat.spelunkerstorch.recalculated_chunk", (Object[])new Object[]{chunkPos.toString(), count}));
        }
        return count;
    }

    private static int recalculateSection(CommandContext<CommandSourceStack> ctx) {
        SectionPos sectionPos = SectionPos.of((Position)((CommandSourceStack)ctx.getSource()).getPosition());
        int count = SpelunkersTorch.recalculateTorches((Level)((CommandSourceStack)ctx.getSource()).getLevel(), sectionPos);
        if (count > 0 && ((CommandSourceStack)ctx.getSource()).isPlayer()) {
            ((CommandSourceStack)ctx.getSource()).getPlayer().sendSystemMessage((Component)Component.translatable((String)"chat.spelunkerstorch.recalculated_section", (Object[])new Object[]{sectionPos.toShortString(), count}));
        }
        return count;
    }

    private static int recalculateSingle(CommandContext<CommandSourceStack> ctx, Coordinates location) {
        BlockPos torchPos = location.getBlockPos((CommandSourceStack)ctx.getSource());
        boolean result = SpelunkersTorch.recalculateTorch((Level)((CommandSourceStack)ctx.getSource()).getLevel(), torchPos);
        if (result && ((CommandSourceStack)ctx.getSource()).isPlayer()) {
            ((CommandSourceStack)ctx.getSource()).getPlayer().sendSystemMessage((Component)Component.translatable((String)"chat.spelunkerstorch.recalculated_single", (Object[])new Object[]{torchPos.toShortString()}));
        }
        return result ? 1 : 0;
    }

    private static int recalculateClosest(CommandContext<CommandSourceStack> ctx) {
        if (((CommandSourceStack)ctx.getSource()).getPlayer() != null) {
            BlockPos torchPos = SpelunkersTorch.recalculateClosestTorch((Level)((CommandSourceStack)ctx.getSource()).getLevel(), ((CommandSourceStack)ctx.getSource()).getPlayer().blockPosition());
            if (torchPos != null && ((CommandSourceStack)ctx.getSource()).isPlayer()) {
                ((CommandSourceStack)ctx.getSource()).getPlayer().sendSystemMessage((Component)Component.translatable((String)"chat.spelunkerstorch.recalculated_single", (Object[])new Object[]{torchPos.toShortString()}));
            }
            return torchPos == null ? 0 : 1;
        }
        return 0;
    }
}

