/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.spelunkerstorch;

import games.alejandrocoria.spelunkerstorch.Constants;
import games.alejandrocoria.spelunkerstorch.Registry;
import games.alejandrocoria.spelunkerstorch.common.block.entity.TorchEntity;
import games.alejandrocoria.spelunkerstorch.common.mixin.server.ChunkMapAccessor;
import games.alejandrocoria.spelunkerstorch.common.pathfinding.PathFindingCache;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongAVLTreeSet;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3193;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3980;
import net.minecraft.class_4076;
import net.minecraft.class_6328;

@class_6328
@ParametersAreNonnullByDefault
public class SpelunkersTorch {
    private static final int WAIT_TIME_TO_UPDATE = 100;
    private static final Object2ObjectMap<class_3218, LongSet> sectionsToUpdate = new Object2ObjectAVLTreeMap(Comparator.comparingInt(Object::hashCode));
    private static long lastAddedSectionToUpdate = 9223372036854775707L;
    private static final Object2ObjectMap<class_3218, LongSet> sectionsToMonitor = new Object2ObjectAVLTreeMap(Comparator.comparingInt(Object::hashCode));

    public static void init() {
    }

    public static void updateNearbyOnRemove(class_1937 level, class_2338 blockPos) {
        TorchEntity torchTarget;
        List<TorchEntity> nearbyTorches = SpelunkersTorch.getNearbyTorchEntities(level, blockPos);
        nearbyTorches.stream().filter(t -> blockPos.equals((Object)t.getTarget())).forEach(TorchEntity::needNewTarget);
        TorchEntity torch = TorchEntity.getFromBlockPos(level, blockPos);
        if (torch != null && torch.hasTarget() && (torchTarget = TorchEntity.getFromBlockPos(level, torch.getTarget())) != null) {
            torchTarget.removeIncoming(blockPos);
        }
    }

    public static List<TorchEntity> getTorchesInNearbySections(class_1937 level, class_4076 sectionPos) {
        ArrayList<class_2791> chunks = new ArrayList<class_2791>();
        for (int z = sectionPos.method_18687() - 1; z < sectionPos.method_18687() + 2; ++z) {
            for (int x = sectionPos.method_18674() - 1; x < sectionPos.method_18674() + 2; ++x) {
                class_2791 chunk = level.method_8402(x, z, class_2806.field_12803, false);
                if (chunk == null) continue;
                chunks.add(chunk);
            }
        }
        ArrayList<TorchEntity> torches = new ArrayList<TorchEntity>();
        for (class_2791 chunk : chunks) {
            Set entityPositions = chunk.method_12021();
            for (class_2338 pos : entityPositions) {
                if (pos.method_10264() < sectionPos.method_19528() - 16 || pos.method_10264() > sectionPos.method_19531() + 16) continue;
                Optional blockEntity = chunk.method_35230(pos, Registry.TORCH_ENTITY.get());
                blockEntity.ifPresent(torches::add);
            }
        }
        return torches;
    }

    public static List<TorchEntity> getNearbyTorchEntities(class_1937 level, class_2338 blockPos) {
        List<TorchEntity> torches = SpelunkersTorch.getTorchesInNearbySections(level, class_4076.method_18682((class_2338)blockPos));
        torches.removeIf(t -> {
            double distance = t.method_11016().method_10262((class_2382)blockPos);
            return distance > 256.0 || distance <= 0.5;
        });
        return torches;
    }

    public static Optional<TorchEntity> getTorchEntity(class_1937 level, class_2338 blockPos) {
        return level.method_8500(blockPos).method_35230(blockPos, Registry.TORCH_ENTITY.get());
    }

    public static int recalculateTorches(class_1937 level) {
        try {
            int count = 0;
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                Long2ObjectLinkedOpenHashMap<class_3193> chunks = ((ChunkMapAccessor)serverLevel.method_14178().field_17254).getVisibleChunkMap();
                for (Long chunkPos : chunks.keySet()) {
                    count += SpelunkersTorch.recalculateTorches(level, new class_1923(chunkPos.longValue()));
                }
            }
            return count;
        }
        catch (Exception e) {
            Constants.LOG.error("Error in recalculateTorches", (Throwable)e);
            return 0;
        }
    }

    public static int recalculateTorches(class_1937 level, class_1923 chunkPos) {
        if (!SpelunkersTorch.allNeighborsChunksLoaded(level, chunkPos)) {
            return 0;
        }
        int count = 0;
        class_2791 chunk = level.method_8402(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false);
        Set entityPositions = chunk.method_12021();
        for (class_2338 pos : entityPositions) {
            Optional blockEntity = chunk.method_35230(pos, Registry.TORCH_ENTITY.get());
            blockEntity.ifPresent(TorchEntity::needNewTarget);
            if (!blockEntity.isPresent()) continue;
            ++count;
        }
        return count;
    }

    public static int recalculateTorches(class_1937 level, class_4076 sectionPos) {
        if (!SpelunkersTorch.allNeighborsChunksLoaded(level, sectionPos.method_18692())) {
            return -1;
        }
        int count = 0;
        class_2791 chunk = level.method_8402(sectionPos.method_18674(), sectionPos.method_18687(), class_2806.field_12803, false);
        Set entityPositions = chunk.method_12021();
        for (class_2338 pos : entityPositions) {
            if (pos.method_10264() / 16 != sectionPos.method_18683()) continue;
            Optional blockEntity = chunk.method_35230(pos, Registry.TORCH_ENTITY.get());
            blockEntity.ifPresent(TorchEntity::needNewTarget);
            if (!blockEntity.isPresent()) continue;
            ++count;
        }
        return count;
    }

    public static boolean recalculateTorch(class_1937 level, class_2338 blockPos) {
        Optional blockEntity = level.method_35230(blockPos, Registry.TORCH_ENTITY.get());
        blockEntity.ifPresent(TorchEntity::needNewTarget);
        return blockEntity.isPresent();
    }

    @Nullable
    public static class_2338 recalculateClosestTorch(class_1937 level, class_2338 blockPos) {
        List<TorchEntity> nearbyTorches = SpelunkersTorch.getNearbyTorchEntities(level, blockPos);
        Optional closestTorch = nearbyTorches.stream().min((t1, t2) -> TorchEntity.distanceComparator(blockPos, t1, t2));
        closestTorch.ifPresent(TorchEntity::needNewTarget);
        return closestTorch.map(class_2586::method_11016).orElse(null);
    }

    public static boolean allNeighborsChunksLoaded(class_1937 level, class_1923 chunkPos) {
        class_3980 cursor = new class_3980(chunkPos.field_9181 - 1, 0, chunkPos.field_9180 - 1, chunkPos.field_9181 + 1, 0, chunkPos.field_9180 + 1);
        while (cursor.method_17963()) {
            if (level.method_8402(cursor.method_18671(), cursor.method_18673(), class_2806.field_12803, false) != null) continue;
            return false;
        }
        return true;
    }

    public static void onBlockUpdated(class_3218 level, class_2338 pos, class_2680 blockState) {
        class_4076 sectionPos = class_4076.method_18682((class_2338)pos);
        LongSet sections = (LongSet)sectionsToMonitor.get((Object)level);
        if (sections == null || !sections.contains(sectionPos.method_18694())) {
            return;
        }
        PathFindingCache.removeIfChanged(pos, blockState);
        SpelunkersTorch.addSectionAndNeighborsToMap(level, sectionPos, sectionsToUpdate);
        if (lastAddedSectionToUpdate - 100L > System.currentTimeMillis()) {
            lastAddedSectionToUpdate = System.currentTimeMillis();
        }
    }

    public static void serverTick() {
        if (lastAddedSectionToUpdate + 100L > System.currentTimeMillis()) {
            return;
        }
        ObjectIterator mapIterator = sectionsToUpdate.entrySet().iterator();
        while (mapIterator.hasNext()) {
            Map.Entry entry = (Map.Entry)mapIterator.next();
            LongIterator setIterator = ((LongSet)entry.getValue()).iterator();
            while (setIterator.hasNext()) {
                int count = SpelunkersTorch.recalculateTorches((class_1937)entry.getKey(), class_4076.method_18677((long)setIterator.nextLong()));
                if (count <= -1) continue;
                setIterator.remove();
            }
            if (!((LongSet)entry.getValue()).isEmpty()) continue;
            mapIterator.remove();
        }
        lastAddedSectionToUpdate = sectionsToUpdate.isEmpty() ? 9223372036854775707L : System.currentTimeMillis();
    }

    public static void addSectionAndNeighborsToMonitor(class_3218 level, class_4076 sectionPos) {
        SpelunkersTorch.addSectionAndNeighborsToMap(level, sectionPos, sectionsToMonitor);
    }

    public static void updateSectionAndNeighbors(class_3218 level, class_4076 sectionPos) {
        SpelunkersTorch.addSectionAndNeighborsToMap(level, sectionPos, sectionsToUpdate);
    }

    private static void addSectionAndNeighborsToMap(class_3218 level, class_4076 sectionPos, Object2ObjectMap<class_3218, LongSet> targetMap) {
        LongSet sections = (LongSet)targetMap.computeIfAbsent((Object)level, l -> new LongAVLTreeSet());
        class_3980 cursor = new class_3980(sectionPos.method_18674() - 1, class_3532.method_15340((int)(sectionPos.method_18683() - 1), (int)level.method_32891(), (int)level.method_31597()), sectionPos.method_18687() - 1, sectionPos.method_18674() + 1, class_3532.method_15340((int)(sectionPos.method_18683() + 1), (int)level.method_32891(), (int)level.method_31597()), sectionPos.method_18687() + 1);
        while (cursor.method_17963()) {
            sections.add(class_4076.method_18685((int)cursor.method_18671(), (int)cursor.method_18672(), (int)cursor.method_18673()));
        }
    }
}

