/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.spelunkerstorch.client.renderer;

import com.mojang.serialization.MapCodec;
import games.alejandrocoria.spelunkerstorch.Registry;
import games.alejandrocoria.spelunkerstorch.client.SpelunkersTorchClient;
import games.alejandrocoria.spelunkerstorch.client.renderer.TorchRenderer;
import games.alejandrocoria.spelunkerstorch.common.block.entity.TorchEntity;
import games.alejandrocoria.spelunkerstorch.common.util.Util;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_10508;
import net.minecraft.class_10515;
import net.minecraft.class_1087;
import net.minecraft.class_11659;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_4587;
import net.minecraft.class_4722;
import net.minecraft.class_6328;
import net.minecraft.class_746;
import net.minecraft.class_811;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@ParametersAreNonnullByDefault
@class_6328
public class TorchSpecialRenderer
implements class_10508 {
    public void method_65699(class_811 displayContext, class_4587 poseStack, class_11659 submitNodeCollector, int light, int overlay, boolean hasFoilType, int i) {
        if (displayContext.method_29998()) {
            poseStack.method_22903();
            poseStack.method_22904(0.0, -0.1, 0.0);
            Quaternionf rotation = new Quaternionf(new AxisAngle4f(-0.35f, 1.0f, 0.0f, 0.0f));
            poseStack.method_49278((Quaternionfc)rotation, 0.0f, 0.75f, 0.0f);
        }
        class_1087 blockStateModel = class_310.method_1551().method_1541().method_3349(Registry.TORCH_BLOCK.get().method_9564());
        submitNodeCollector.method_73484(poseStack, class_4722.method_24074(), blockStateModel, 1.0f, 1.0f, 0.0f, light, overlay, i);
        if (displayContext.method_29998()) {
            Quaternionf needleRotation;
            poseStack.method_22909();
            class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
            List<TorchEntity> nearbyTorches = SpelunkersTorchClient.getTorchesInNearbySections(class_310.method_1551().field_1687, class_4076.method_18682((class_2338)class_2338.method_49638((class_2374)cameraPos)));
            if (!nearbyTorches.isEmpty() && (needleRotation = TorchSpecialRenderer.calculateNeedleRotation(class_310.method_1551().field_1724, cameraPos, nearbyTorches)) != null) {
                TorchRenderer.renderNeedle(poseStack, needleRotation, light, submitNodeCollector);
            }
        } else {
            poseStack.method_22903();
            poseStack.method_22904(0.0, -0.1, 0.0);
            Quaternionf rotation = new Quaternionf(new AxisAngle4f(1.5707964f, 0.0f, 1.0f, 0.0f));
            rotation.mul((Quaternionfc)new Quaternionf(new AxisAngle4f(-0.7853982f, 1.0f, 0.0f, 0.0f)));
            TorchRenderer.renderNeedle(poseStack, rotation, light, submitNodeCollector);
            poseStack.method_22909();
        }
    }

    @Nullable
    private static Quaternionf calculateNeedleRotation(class_746 player, class_243 cameraPos, List<TorchEntity> nearbyTorches) {
        double LIMIT = 256.0;
        class_243 nodeSum = class_243.field_1353;
        class_243 pathSum = class_243.field_1353;
        double distanceToClosestPath = LIMIT;
        for (TorchEntity torchEntity : nearbyTorches) {
            if (!torchEntity.hasTarget() || torchEntity.getPath().isEmpty()) continue;
            double distanceToClosest = LIMIT;
            class_243 closest = null;
            List<class_2338> path = torchEntity.getPath();
            class_2338 prev = path.getFirst();
            for (int i = 1; i < path.size(); ++i) {
                class_2338 node = path.get(i);
                class_243 closestPoint = TorchSpecialRenderer.getClosestPoint(cameraPos, prev.method_46558(), node.method_46558());
                double distanceToPoint = closestPoint.method_1025(cameraPos);
                if (distanceToPoint < distanceToClosest) {
                    distanceToClosest = distanceToPoint;
                    closest = closestPoint;
                }
                class_243 toNextNode = class_243.method_24954((class_2382)node.method_10059((class_2382)prev));
                double factor = toNextNode.method_1033() * Math.max(1.0 / Math.clamp(distanceToPoint, 1.0, LIMIT) - 1.0 / LIMIT, 0.0);
                toNextNode = toNextNode.method_1021(factor);
                nodeSum = nodeSum.method_1019(toNextNode);
                prev = node;
            }
            if (closest == null) continue;
            closest = closest.method_1020(cameraPos);
            double factor = 1.0 / closest.method_1027();
            closest = closest.method_1021(factor);
            pathSum = pathSum.method_1019(closest);
            if (!(distanceToClosest < distanceToClosestPath)) continue;
            distanceToClosestPath = distanceToClosest;
        }
        if (nodeSum.equals((Object)class_243.field_1353) && pathSum.equals((Object)class_243.field_1353)) {
            return null;
        }
        nodeSum = nodeSum.method_1029();
        pathSum = pathSum.method_1029();
        double pathFactor = 1.0 / (1.0 + Math.pow(2.0, -Math.sqrt(distanceToClosestPath) + 4.0));
        class_243 averageSum = nodeSum.method_1021(1.0 - pathFactor).method_1019(pathSum.method_1021(pathFactor));
        float rotX = player.method_5695(1.0f) * ((float)Math.PI / 180);
        float rotY = player.method_5705(1.0f) * ((float)Math.PI / 180);
        averageSum = averageSum.method_1024(rotY);
        averageSum = averageSum.method_1037(rotX);
        averageSum = averageSum.method_1024(-1.5707964f);
        return Util.getRotation(averageSum);
    }

    private static class_243 getClosestPoint(class_243 p, class_243 a, class_243 b) {
        class_243 ab = b.method_1020(a);
        class_243 ap = p.method_1020(a);
        double dotApAb = ap.method_1026(ab);
        if (dotApAb <= 0.0) {
            return a;
        }
        class_243 bp = p.method_1020(b);
        if (bp.method_1026(ab) >= 0.0) {
            return b;
        }
        return a.method_1019(ab.method_1021(dotApAb / ab.method_1027()));
    }

    public void method_72175(Set<Vector3f> set) {
    }

    public record Unbaked() implements class_10515.class_10516
    {
        public static final MapCodec<Unbaked> MAP_CODEC = MapCodec.unit((Object)new Unbaked());

        public class_10515<?> method_65698(class_10515.class_11695 bakingContext) {
            return new TorchSpecialRenderer();
        }

        public MapCodec<Unbaked> method_65696() {
            return MAP_CODEC;
        }
    }
}

