/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.spelunkerstorch.common.block.entity;

import games.alejandrocoria.spelunkerstorch.Constants;
import games.alejandrocoria.spelunkerstorch.Registry;
import games.alejandrocoria.spelunkerstorch.SpelunkersTorch;
import games.alejandrocoria.spelunkerstorch.client.SpelunkersTorchClient;
import games.alejandrocoria.spelunkerstorch.common.block.Torch;
import games.alejandrocoria.spelunkerstorch.common.pathfinding.Path;
import games.alejandrocoria.spelunkerstorch.common.pathfinding.PathFinder;
import games.alejandrocoria.spelunkerstorch.common.util.Util;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_5558;
import net.minecraft.class_6319;
import net.minecraft.class_6328;
import net.minecraft.class_7225;
import org.joml.Quaternionf;

@class_6328
@ParametersAreNonnullByDefault
@class_6319
public class TorchEntity
extends class_2586 {
    private static final class_2338 TARGET_NOT_CALCULATED = new class_2338(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private static final int DATA_VERSION = 1;
    private int dataVersion = 1;
    private long date;
    @Nullable
    private class_2338 target = TARGET_NOT_CALCULATED;
    private List<class_2338> incoming = new ArrayList<class_2338>();
    private List<class_2338> path = new ArrayList<class_2338>();
    @Nullable
    private Quaternionf cachedRotation;

    public TorchEntity(class_2338 blockPos, class_2680 state) {
        super(Registry.TORCH_ENTITY.get(), blockPos, state);
        this.date = Instant.now().toEpochMilli();
    }

    public long getDate() {
        return this.date;
    }

    @Nullable
    public class_2338 getTarget() {
        return this.target;
    }

    public List<class_2338> getIncoming() {
        return this.incoming;
    }

    public List<class_2338> getPath() {
        return this.path;
    }

    @Nullable
    public Quaternionf getRotation() {
        if (this.cachedRotation == null) {
            this.recalculateRotation();
        }
        return this.cachedRotation;
    }

    public void needNewTarget() {
        this.target = TARGET_NOT_CALCULATED;
    }

    public void recalculateTargetIfNeeded() {
        if (this.field_11863 == null || !TARGET_NOT_CALCULATED.equals((Object)this.target)) {
            return;
        }
        this.setBlock();
        PathFinder pathFinder = new PathFinder(this.field_11863, this.field_11867);
        Path result = pathFinder.calculateMinPath();
        if (result != null) {
            this.path = result.positions;
            this.target = this.path.getLast();
            this.setBlock();
            SpelunkersTorch.getTorchEntity(this.field_11863, this.target).ifPresent(t -> t.addIncoming(this.field_11867));
        } else {
            this.target = null;
            this.path.clear();
        }
    }

    private void addIncoming(class_2338 torch) {
        if (!this.incoming.contains(torch)) {
            this.incoming.add(torch);
            this.setBlock(true);
        }
    }

    public void removeIncoming(class_2338 torch) {
        if (this.incoming.remove(torch)) {
            this.setBlock(true);
        }
    }

    private void setBlock() {
        this.setBlock(false);
    }

    private void setBlock(boolean forceChange) {
        if (this.field_11863 != null && this.field_11863.method_8320(this.field_11867) == this.method_11010()) {
            if (forceChange) {
                this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)Torch.HAS_TARGET, (Comparable)Boolean.valueOf(!this.hasTarget())), 2);
            }
            this.field_11863.method_8652(this.field_11867, (class_2680)this.method_11010().method_11657((class_2769)Torch.HAS_TARGET, (Comparable)Boolean.valueOf(this.hasTarget())), 2);
        }
    }

    public int distanceComparator(TorchEntity t1, TorchEntity t2) {
        int distance2;
        int distance1 = this.field_11867.method_19455((class_2382)t1.field_11867);
        if (distance1 == (distance2 = this.field_11867.method_19455((class_2382)t2.field_11867))) {
            return Long.compare(t1.date, t2.date);
        }
        return distance1 - distance2;
    }

    public boolean hasTarget() {
        return this.target != null && !TARGET_NOT_CALCULATED.equals((Object)this.target);
    }

    private void recalculateRotation() {
        if (!this.hasTarget()) {
            this.cachedRotation = null;
            return;
        }
        class_2338 toTarget = this.target.method_10059((class_2382)this.field_11867);
        this.cachedRotation = Util.getRotation(class_243.method_24954((class_2382)toTarget));
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        if (this.field_11863 != null) {
            if (this.field_11863.method_8608()) {
                SpelunkersTorchClient.torchEntityAddedOrRemoved(this);
            } else {
                SpelunkersTorch.addSectionAndNeighborsToMonitor((class_3218)this.field_11863, class_4076.method_18682((class_2338)this.field_11867));
                if (this.dataVersion < 1) {
                    SpelunkersTorch.updateSectionAndNeighbors((class_3218)this.field_11863, class_4076.method_18682((class_2338)this.field_11867));
                }
            }
        }
    }

    public void method_11012() {
        super.method_11012();
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            SpelunkersTorchClient.torchEntityAddedOrRemoved(this);
        }
    }

    public void method_10996() {
        super.method_10996();
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            SpelunkersTorchClient.torchEntityAddedOrRemoved(this);
        }
    }

    public void method_66473(class_2338 blockPos, class_2680 blockState) {
        super.method_66473(blockPos, blockState);
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            SpelunkersTorch.updateNearbyOnRemove(this.field_11863, blockPos);
        }
    }

    protected void method_11007(class_11372 valueOutput) {
        try {
            class_11372.class_11373 outputList;
            super.method_11007(valueOutput);
            valueOutput.method_71466("Date", this.date);
            valueOutput.method_71465("DataVersion", 1);
            if (this.hasTarget()) {
                valueOutput.method_71468("Target", class_2338.field_25064, (Object)this.target);
            }
            if (!this.incoming.isEmpty()) {
                outputList = valueOutput.method_71467("Incoming", class_2338.field_25064);
                this.incoming.forEach(arg_0 -> ((class_11372.class_11373)outputList).method_71484(arg_0));
            }
            if (!this.path.isEmpty()) {
                outputList = valueOutput.method_71467("Path", class_2338.field_25064);
                this.path.forEach(arg_0 -> ((class_11372.class_11373)outputList).method_71484(arg_0));
            }
        }
        catch (Exception e) {
            Constants.LOG.error("Error in TorchEntity.saveAdditional", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_11014(class_11368 valueInput) {
        try {
            super.method_11014(valueInput);
            this.date = valueInput.method_71425("Date", 0L);
            int version = valueInput.method_71424("DataVersion", 0);
            if (version < 1) {
                this.dataVersion = version;
                this.target = TARGET_NOT_CALCULATED;
                this.incoming.clear();
                this.path.clear();
                this.cachedRotation = null;
                return;
            }
            this.target = valueInput.method_71426("Target", class_2338.field_25064).orElse(null);
            this.incoming.clear();
            Optional incomingList = valueInput.method_71435("Incoming", class_2338.field_25064);
            incomingList.ifPresent(blockPos -> blockPos.method_71456().forEach(this.incoming::add));
            this.path.clear();
            Optional pathList = valueInput.method_71435("Path", class_2338.field_25064);
            pathList.ifPresent(blockPos -> blockPos.method_71456().forEach(this.path::add));
        }
        catch (Exception e) {
            this.target = TARGET_NOT_CALCULATED;
            this.incoming.clear();
            this.path.clear();
            Constants.LOG.error("Error in TorchEntity.load", (Throwable)e);
        }
        finally {
            this.cachedRotation = null;
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    @Nullable
    public static <T extends class_2586> class_5558<T> createTicker(class_1937 level, class_2591<T> blockEntityType) {
        if (!level.method_8608() && blockEntityType == Registry.TORCH_ENTITY.get()) {
            return (l, p, s, blockEntity) -> ((TorchEntity)blockEntity).recalculateTargetIfNeeded();
        }
        return null;
    }

    @Nullable
    public static TorchEntity getFromBlockPos(class_1937 level, class_2338 blockPos) {
        class_2586 blockEntity = level.method_8321(blockPos);
        if (blockEntity != null && blockEntity.method_11017() == Registry.TORCH_ENTITY.get()) {
            return (TorchEntity)blockEntity;
        }
        return null;
    }

    public static int distanceComparator(class_2338 position, TorchEntity t1, TorchEntity t2) {
        int distance = (int)(position.method_10262((class_2382)t1.method_11016()) - position.method_10262((class_2382)t2.method_11016()));
        if (distance == 0) {
            return Long.compare(t1.getDate(), t2.getDate());
        }
        return distance;
    }
}

