/*
 * Decompiled with CFR 0.152.
 */
package games.alejandrocoria.spelunkerstorch.common.pathfinding;

import games.alejandrocoria.spelunkerstorch.Registry;
import games.alejandrocoria.spelunkerstorch.SpelunkersTorch;
import games.alejandrocoria.spelunkerstorch.common.block.entity.TorchEntity;
import games.alejandrocoria.spelunkerstorch.common.pathfinding.Node;
import games.alejandrocoria.spelunkerstorch.common.pathfinding.Path;
import games.alejandrocoria.spelunkerstorch.common.pathfinding.PathFindingCache;
import games.alejandrocoria.spelunkerstorch.common.pathfinding.PathFindingSection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3980;
import net.minecraft.class_4076;

public class PathFinder {
    private static final double[] NEIGHBOR_DISTANCE = new double[]{0.0, 1.0, Math.sqrt(2.0), Math.sqrt(3.0)};
    private final class_2338 torchPos;
    private List<TorchEntity> targets;
    private final PathFindingSection[] sections = new PathFindingSection[27];
    private final Queue<Node> openSet = new PriorityQueue<Node>();
    private final Map<class_2338, Node> allNodes = new HashMap<class_2338, Node>();
    private final class_2338[] neighbors = new class_2338[28];
    private int neighborCount;

    public PathFinder(class_1937 level, class_2338 torchPos) {
        this.torchPos = torchPos;
        TorchEntity torch = level.method_35230(torchPos, Registry.TORCH_ENTITY.get()).orElse(null);
        if (torch == null) {
            return;
        }
        this.targets = SpelunkersTorch.getNearbyTorchEntities(level, torchPos).stream().filter(t -> t.getDate() < torch.getDate()).sorted(torch::distanceComparator).toList();
        if (this.targets.isEmpty()) {
            return;
        }
        class_4076 torchSection = class_4076.method_18682((class_2338)torchPos);
        class_3980 cursor = new class_3980(torchSection.method_18674() - 1, torchSection.method_18683() - 1, torchSection.method_18687() - 1, torchSection.method_18674() + 1, torchSection.method_18683() + 1, torchSection.method_18687() + 1);
        int index = 0;
        while (cursor.method_17963()) {
            this.sections[index++] = PathFindingCache.getSection(level, class_4076.method_18676((int)cursor.method_18671(), (int)cursor.method_18672(), (int)cursor.method_18673()));
        }
    }

    @Nullable
    public Path calculateMinPath() {
        Path bestPath = null;
        double bestDistance = 16.0;
        long bestDate = Long.MAX_VALUE;
        for (TorchEntity target : this.targets) {
            Path path;
            class_2338 targetPos = target.method_11016();
            if (targetPos.method_10262((class_2382)this.torchPos) > bestDistance * bestDistance || (path = this.calculatePath(targetPos, bestDistance)) == null || !(path.length < bestDistance) && (path.length != bestDistance || target.getDate() >= bestDate)) continue;
            bestDistance = path.length;
            bestDate = target.getDate();
            bestPath = path;
        }
        return bestPath;
    }

    private Path calculatePath(class_2338 target, double maxDistance) {
        this.openSet.clear();
        this.allNodes.clear();
        Node start = new Node(this.torchPos, null, 0.0, Math.sqrt(this.torchPos.method_10262((class_2382)target)));
        this.openSet.add(start);
        this.allNodes.put(this.torchPos, start);
        while (!this.openSet.isEmpty()) {
            Node theNode = this.openSet.poll();
            theNode.visited = true;
            if (theNode.pos.equals((Object)target)) {
                return new Path(this.allNodes, theNode);
            }
            if (theNode.routeDistance + Math.sqrt(theNode.pos.method_10262((class_2382)target)) >= maxDistance) continue;
            this.calculateNeighbors(theNode.pos);
            for (int i = 0; i < this.neighborCount; ++i) {
                double newDistance;
                class_2338 neighborPos = this.neighbors[i];
                Node next = this.allNodes.computeIfAbsent(neighborPos, Node::new);
                if (next.visited || !((newDistance = theNode.routeDistance + PathFinder.neighborsDistance(theNode.pos, neighborPos)) < next.routeDistance)) continue;
                next.previous = theNode.pos;
                next.routeDistance = newDistance;
                next.estimatedDistance = newDistance + Math.sqrt(neighborPos.method_10262((class_2382)target));
                if (this.openSet.contains(next)) continue;
                this.openSet.add(next);
            }
        }
        return null;
    }

    private void calculateNeighbors(class_2338 pos) {
        boolean wb;
        this.neighborCount = 0;
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        boolean n = this.maybeAddNeighbor(x, y, z - 1);
        boolean s = this.maybeAddNeighbor(x, y, z + 1);
        boolean e = this.maybeAddNeighbor(x + 1, y, z);
        boolean w = this.maybeAddNeighbor(x - 1, y, z);
        boolean a = this.maybeAddNeighbor(x, y + 1, z);
        boolean b = this.maybeAddNeighbor(x, y - 1, z);
        boolean ne = (n || e) && this.maybeAddNeighbor(x + 1, y, z - 1);
        boolean nw = (n || w) && this.maybeAddNeighbor(x - 1, y, z - 1);
        boolean se = (s || e) && this.maybeAddNeighbor(x + 1, y, z + 1);
        boolean sw = (s || w) && this.maybeAddNeighbor(x - 1, y, z + 1);
        boolean na = (n || a) && this.maybeAddNeighbor(x, y + 1, z - 1);
        boolean nb = (n || b) && this.maybeAddNeighbor(x, y - 1, z - 1);
        boolean sa = (s || a) && this.maybeAddNeighbor(x, y + 1, z + 1);
        boolean sb = (s || b) && this.maybeAddNeighbor(x, y - 1, z + 1);
        boolean ea = (e || a) && this.maybeAddNeighbor(x + 1, y + 1, z);
        boolean eb = (e || b) && this.maybeAddNeighbor(x + 1, y - 1, z);
        boolean wa = (w || a) && this.maybeAddNeighbor(x - 1, y + 1, z);
        boolean bl = wb = (w || b) && this.maybeAddNeighbor(x - 1, y - 1, z);
        if (ne || na || ea) {
            this.maybeAddNeighbor(x + 1, y + 1, z - 1);
        }
        if (nw || na || wa) {
            this.maybeAddNeighbor(x - 1, y + 1, z - 1);
        }
        if (ne || nb || eb) {
            this.maybeAddNeighbor(x + 1, y - 1, z - 1);
        }
        if (nw || nb || wb) {
            this.maybeAddNeighbor(x - 1, y - 1, z - 1);
        }
        if (se || sa || ea) {
            this.maybeAddNeighbor(x + 1, y + 1, z + 1);
        }
        if (sw || sa || wa) {
            this.maybeAddNeighbor(x - 1, y + 1, z + 1);
        }
        if (se || sb || eb) {
            this.maybeAddNeighbor(x + 1, y - 1, z + 1);
        }
        if (sw || sb || wb) {
            this.maybeAddNeighbor(x - 1, y - 1, z + 1);
        }
    }

    private boolean maybeAddNeighbor(int x, int y, int z) {
        int sectionX = (x >> 4) - this.sections[0].getPos().method_18674();
        int sectionY = (y >> 4) - this.sections[0].getPos().method_18683();
        int sectionZ = (z >> 4) - this.sections[0].getPos().method_18687();
        assert (sectionX >= 0);
        assert (sectionY >= 0);
        assert (sectionZ >= 0);
        assert (sectionX <= 2);
        assert (sectionY <= 2);
        assert (sectionZ <= 2);
        PathFindingSection section = this.sections[sectionX + sectionY * 3 + sectionZ * 9];
        if (!section.getBlock(x, y, z)) {
            this.neighbors[this.neighborCount++] = new class_2338(x, y, z);
            return true;
        }
        return false;
    }

    private static double neighborsDistance(class_2338 p1, class_2338 p2) {
        int deltaX = Math.abs(p1.method_10263() - p2.method_10263());
        int deltaY = Math.abs(p1.method_10264() - p2.method_10264());
        int deltaZ = Math.abs(p1.method_10260() - p2.method_10260());
        int delta = deltaX + deltaY + deltaZ;
        assert (delta > 0 && delta <= 3);
        return NEIGHBOR_DISTANCE[delta];
    }
}

