/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements;

import com.minenash.customhud.HudElements.interfaces.HudElement;

public class FrequencyElement
implements HudElement {
    private final HudElement element;
    private final int interval;
    private long lastMS = System.currentTimeMillis();
    String strValue;
    Number numValue;
    boolean boolValue;

    public FrequencyElement(HudElement element, int interval) {
        this.element = element;
        this.interval = interval;
    }

    private void update() {
        long currentMs = System.currentTimeMillis();
        long diff = currentMs - this.lastMS;
        if (diff >= (long)this.interval || this.strValue == null) {
            this.lastMS = currentMs;
            this.strValue = this.element.getString();
            this.numValue = this.element.getNumber();
            this.boolValue = this.element.getBoolean();
        }
    }

    @Override
    public String getString() {
        this.update();
        return this.strValue;
    }

    @Override
    public Number getNumber() {
        this.update();
        return this.numValue;
    }

    @Override
    public boolean getBoolean() {
        this.update();
        return this.boolValue;
    }
}

