/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements.list;

import com.minenash.customhud.HudElements.functional.FunctionalElement;
import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.HudElements.interfaces.MultiElement;
import com.minenash.customhud.HudElements.list.ListProvider;
import com.minenash.customhud.complex.ListManager;
import com.minenash.customhud.conditionals.Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class FilteredListElement
extends FunctionalElement
implements HudElement,
MultiElement {
    private final HudElement popList;
    private final HudElement advanceList;
    private final UUID providerID;
    private final ListProvider provider;
    private final List<HudElement> main;
    private final List<HudElement> last;
    private final Operation operation;
    private final boolean multiline;
    private final boolean reverse;

    public FilteredListElement(ListProvider provider, UUID providerID, List<HudElement> format, List<HudElement> separator, Operation operation, boolean multiline, boolean reverse) {
        this.provider = provider;
        this.providerID = providerID;
        this.operation = operation;
        this.popList = new FunctionalElement.PopList(providerID);
        this.advanceList = new FunctionalElement.AdvanceList(providerID);
        this.multiline = multiline;
        this.reverse = reverse;
        this.last = format;
        if (format == null) {
            this.main = null;
        } else {
            this.main = new ArrayList<HudElement>(format);
            if (separator != null) {
                this.main.addAll(separator);
            }
        }
    }

    @Override
    public List<HudElement> expand() {
        if (this.main == null) {
            return Collections.EMPTY_LIST;
        }
        List<?> values = this.provider.get();
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.reverse) {
            Collections.reverse(values);
        }
        ArrayList notFiltered = new ArrayList(values.size());
        ListManager.push(this.providerID, values);
        for (Object value : values) {
            if (this.operation.getBooleanValue()) {
                notFiltered.add(value);
            }
            ListManager.advance(this.providerID);
        }
        ListManager.pop(this.providerID);
        if (notFiltered.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<HudElement> expanded = new ArrayList<HudElement>();
        expanded.add(new FunctionalElement.PushList(this.providerID, notFiltered));
        for (int i = 0; i < notFiltered.size(); ++i) {
            expanded.addAll(i < notFiltered.size() - 1 ? this.main : this.last);
            expanded.add(this.advanceList);
        }
        expanded.set(expanded.size() - 1, this.popList);
        return expanded;
    }

    @Override
    public boolean ignoreNewlineIfEmpty() {
        return !this.multiline;
    }

    @Override
    public String getString() {
        return this.expandIntoString();
    }
}

