/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.complex;

import com.minenash.customhud.CustomHud;
import com.minenash.customhud.complex.MusicAndRecordTracker;
import com.minenash.customhud.complex.SubtitleTracker;
import com.minenash.customhud.data.Profile;
import com.minenash.customhud.mixin.accessors.DebugHudAccessor;
import com.minenash.customhud.registry.CustomHudRegistry;
import com.mojang.datafixers.DataFixUtils;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_10209;
import net.minecraft.class_1132;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1916;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2799;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2824;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3534;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3696;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_746;
import net.minecraft.class_9191;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

public class ComplexData {
    public static class_2818 clientChunk = null;
    public static class_2818 serverChunk = null;
    public static class_3218 serverWorld = null;
    public static class_1266 localDifficulty = null;
    public static class_1937 world = null;
    public static class_2338 targetBlockPos = null;
    public static class_2680 targetBlock = null;
    public static class_2338 targetFluidPos = null;
    public static class_3610 targetFluid = null;
    public static class_1297 targetEntity = null;
    public static class_243 targetEntityHitPos = null;
    public static class_1297 lastHitEntity = null;
    public static double lastHitEntityDist = Double.NaN;
    public static long lastHitEntityTime = -1L;
    public static String[] sounds = null;
    public static String[] clientChunkCache = null;
    public static int timeOfDay = -1;
    public static double x1 = 0.0;
    public static double y1 = 0.0;
    public static double z1 = 0.0;
    public static double velocityXZ = 0.0;
    public static double velocityY = 0.0;
    public static double velocityXYZ = 0.0;
    private static final class_310 client = class_310.method_1551();
    private static final class_2680 AIR_BLOCK_STATE = class_2246.field_10124.method_9564();
    private static class_1923 pos = null;
    private static CompletableFuture<class_2818> chunkFuture;
    private static int velocityWaitCounter;
    private static int cpsWaitCounter;
    public static Object cpu;
    private static long[] prevTicks;
    public static double cpuLoad;
    public static double gpuUsage;
    public static int[] clicksSoFar;
    public static int[] clicksPerSeconds;
    public static ArrayDeque<Integer>[] clicks;
    public static double[] frameTimeMetrics;
    public static double[] tickTimeMetrics;
    public static double[] pingMetrics;
    public static double[] packetSizeMetrics;
    public static double[] tpsMetrics;
    public static int slots_used;
    public static int slots_empty;
    private static long lastStatUpdate;
    public static final Map<UUID, class_1259> bossbars;
    public static class_1916 villagerOffers;
    public static int villagerXP;
    public static UUID villagerUUID;
    public static int fakeVillagerInteract;
    public static long villagerLastRequested;
    public static boolean refreshTimings;
    public static List<ProfilerTimingWithPath> rootEntries;
    public static Map<String, ProfilerTimingWithPath> allEntries;

    public static void update(Profile profile) {
        class_239 hit;
        class_10209.method_64146().method_15396("custom_hud_complex_data");
        if (profile.enabled.serverWorld) {
            class_10209.method_64146().method_15396("serverWorld");
            class_1132 integratedServer2 = client.method_1576();
            serverWorld = integratedServer2 != null ? integratedServer2.method_3847(ComplexData.client.field_1687.method_27983()) : null;
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.clientChunk) {
            class_10209.method_64146().method_15396("clientChunk");
            class_1923 newPos = new class_1923(client.method_1560().method_24515());
            if (!Objects.equals(pos, newPos)) {
                pos = newPos;
                chunkFuture = null;
                clientChunk = null;
            }
            if (clientChunk == null) {
                clientChunk = ComplexData.client.field_1687.method_8497(ComplexData.pos.field_9181, ComplexData.pos.field_9180);
            }
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.serverChunk) {
            class_10209.method_64146().method_15396("serverChunk");
            if (chunkFuture == null) {
                if (serverWorld != null) {
                    chunkFuture = serverWorld.method_14178().method_17299(ComplexData.pos.field_9181, ComplexData.pos.field_9180, class_2806.field_12803, false).thenApply(either -> (class_2818)either.method_57130(null));
                }
                if (chunkFuture == null) {
                    chunkFuture = CompletableFuture.completedFuture(clientChunk);
                }
            }
            serverChunk = chunkFuture.getNow(null);
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.world) {
            class_10209.method_64146().method_15396("world");
            world = (class_1937)DataFixUtils.orElse(Optional.ofNullable(client.method_1576()).flatMap(integratedServer -> Optional.ofNullable(integratedServer.method_3847(ComplexData.client.field_1687.method_27983()))), (Object)ComplexData.client.field_1687);
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.targetBlock) {
            class_10209.method_64146().method_15396("targetBlock");
            hit = ComplexData.client.field_1719.method_5745((double)profile.targetDistance, 0.0f, false);
            if (hit.method_17783() == class_239.class_240.field_1332) {
                targetBlockPos = ((class_3965)hit).method_17777();
                targetBlock = world.method_8320(targetBlockPos);
            } else {
                targetBlockPos = null;
                targetBlock = AIR_BLOCK_STATE;
            }
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.targetFluid) {
            class_10209.method_64146().method_15396("targetFluid");
            hit = ComplexData.client.field_1719.method_5745((double)profile.targetDistance, 0.0f, true);
            if (hit.method_17783() == class_239.class_240.field_1332) {
                targetFluidPos = ((class_3965)hit).method_17777();
                targetFluid = world.method_8316(targetFluidPos);
            } else {
                targetFluidPos = null;
                targetFluid = class_3612.field_15906.method_15785();
            }
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.targetEntity) {
            class_10209.method_64146().method_15396("targetEntity");
            double dist = profile.targetDistance;
            class_243 min = ComplexData.client.field_1719.method_5836(0.0f);
            class_243 rot = ComplexData.client.field_1719.method_5828(1.0f);
            class_243 max = min.method_1031(rot.field_1352 * dist, rot.field_1351 * dist, rot.field_1350 * dist);
            class_238 box = ComplexData.client.field_1719.method_5829().method_18804(rot.method_1021(dist)).method_1009(1.0, 1.0, 1.0);
            class_239 block = ComplexData.client.field_1719.method_5745(dist, 0.0f, false);
            double dist2 = block == null ? dist * dist : block.method_17784().method_1025(min);
            class_3966 result = class_1675.method_18075((class_1297)ComplexData.client.field_1719, (class_243)min, (class_243)max, (class_238)box, en -> !en.method_7325(), (double)dist2);
            targetEntity = result == null ? null : result.method_17782();
            targetEntityHitPos = result == null ? null : result.method_17784();
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.localDifficulty) {
            class_10209.method_64146().method_15396("localDifficulty");
            localDifficulty = new class_1266(world.method_8407(), world.method_8532(), serverChunk == null ? 0L : serverChunk.method_12033(), world.method_30272());
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.sound) {
            class_10209.method_64146().method_15396("sound");
            sounds = client.method_1483().method_20305().substring(8).replace(" + ", "/").split("/");
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.time) {
            class_10209.method_64146().method_15396("time");
            timeOfDay = (int)((ComplexData.client.field_1687.method_8532() + 6000L) % 24000L);
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.velocity) {
            class_10209.method_64146().method_15396("velocity");
            if (velocityWaitCounter > 0) {
                --velocityWaitCounter;
                class_10209.method_64146().method_15407();
            } else {
                velocityWaitCounter = 4;
                class_746 p = ComplexData.client.field_1724;
                double changeXZ = Math.sqrt(Math.pow(Math.abs(p.method_23317() - x1), 2.0) + Math.pow(Math.abs(p.method_23321() - z1), 2.0));
                double changeY = Math.abs(p.method_23318() - y1);
                double changeXYZ = Math.sqrt(changeXZ * changeXZ + changeY * changeY);
                x1 = p.method_23317();
                y1 = p.method_23318();
                z1 = p.method_23321();
                velocityXZ = changeXZ * 4.0;
                velocityY = changeY * 4.0;
                velocityXYZ = changeXYZ * 4.0;
                class_10209.method_64146().method_15407();
            }
        }
        if (profile.enabled.cpu && cpu == null) {
            cpu = new SystemInfo().getHardware().getProcessor();
        }
        if (profile.enabled.cpuUsage) {
            class_10209.method_64146().method_15396("cpu");
            CentralProcessor c = (CentralProcessor)cpu;
            double load = c.getSystemCpuLoadBetweenTicks(prevTicks) * 100.0;
            if (load > 0.0) {
                cpuLoad = load;
            }
            prevTicks = c.getSystemCpuLoadTicks();
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.updateStats) {
            class_10209.method_64146().method_15396("updateStats");
            if (System.currentTimeMillis() - lastStatUpdate >= 500L) {
                client.method_1562().method_52787((class_2596)new class_2799(class_2799.class_2800.field_12775));
                lastStatUpdate = System.currentTimeMillis();
            }
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.clicksPerSeconds) {
            class_10209.method_64146().method_15396("clicksPerSeconds");
            if (clicks == null) {
                clicks = new ArrayDeque[]{new ArrayDeque(20), new ArrayDeque(20)};
                for (int i = 0; i < 20; ++i) {
                    clicks[0].add(0);
                    clicks[1].add(0);
                }
            }
            clicks[0].remove();
            clicks[1].remove();
            clicks[0].add(clicksSoFar[0]);
            clicks[1].add(clicksSoFar[1]);
            ComplexData.clicksSoFar[0] = 0;
            ComplexData.clicksSoFar[1] = 0;
            ComplexData.clicksPerSeconds[0] = clicks[0].stream().reduce(0, Integer::sum);
            ComplexData.clicksPerSeconds[1] = clicks[1].stream().reduce(0, Integer::sum);
            ++cpsWaitCounter;
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.frameMetrics) {
            class_10209.method_64146().method_15396("frameMetrics");
            ComplexData.processLog(((DebugHudAccessor)ComplexData.client.field_1705.method_53531()).getFrameNanosLog(), 1.0E-6, 240, frameTimeMetrics);
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.tickMetrics) {
            class_10209.method_64146().method_15396("tickMetrics");
            ComplexData.processLog(((DebugHudAccessor)ComplexData.client.field_1705.method_53531()).getTickNanosLog(), 1.0E-6, 120, tickTimeMetrics);
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.pingMetrics) {
            class_10209.method_64146().method_15396("pingMetrics");
            ComplexData.processLog(ComplexData.client.field_1705.method_53531().method_53543(), 1.0, 120, pingMetrics);
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.packetMetrics) {
            class_10209.method_64146().method_15396("packetMetrics");
            ComplexData.processLog(ComplexData.client.field_1705.method_53531().method_53544(), 0.01953125, 120, packetSizeMetrics);
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.tpsMetrics) {
            class_10209.method_64146().method_15396("tpsMetrics");
            ComplexData.processTPSLog(((DebugHudAccessor)ComplexData.client.field_1705.method_53531()).getTickNanosLog(), tpsMetrics);
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.slots) {
            class_10209.method_64146().method_15396("slots");
            slots_empty = 0;
            slots_used = 0;
            class_2371 inv = ComplexData.client.field_1724.method_31548().field_7547;
            for (class_1799 itemStack : inv) {
                if (itemStack == class_1799.field_8037) {
                    ++slots_empty;
                    continue;
                }
                ++slots_used;
            }
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.music) {
            class_10209.method_64146().method_15396("music");
            MusicAndRecordTracker.tick();
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.targetVillager) {
            class_10209.method_64146().method_15396("targetVillager");
            if (!(targetEntity instanceof class_1646) && villagerUUID != null) {
                villagerOffers.clear();
                villagerUUID = null;
                villagerLastRequested = Long.MAX_VALUE;
            } else if (targetEntity instanceof class_1646 && (villagerUUID == null || !targetEntity.method_5667().equals(villagerUUID) || System.currentTimeMillis() - villagerLastRequested > 30000L)) {
                villagerUUID = targetEntity.method_5667();
                fakeVillagerInteract = 2;
                CustomHud.CLIENT.method_1562().method_52787((class_2596)class_2824.method_34207((class_1297)targetEntity, (boolean)false, (class_1268)class_1268.field_5810));
                villagerLastRequested = System.currentTimeMillis();
            }
            class_10209.method_64146().method_15407();
        }
        if (profile.enabled.profilerTimings) {
            class_10209.method_64146().method_15396("profilerTimings");
            class_3696 profileResult = CustomHud.CLIENT.method_53526().method_61981().field_52777;
            if (profileResult == null) {
                rootEntries = Collections.EMPTY_LIST;
                allEntries = Collections.EMPTY_MAP;
            } else {
                rootEntries = new ArrayList<ProfilerTimingWithPath>();
                allEntries = new HashMap<String, ProfilerTimingWithPath>();
                List timings = profileResult.method_16067("root");
                timings.remove(0);
                for (class_3534 entry : timings) {
                    rootEntries.add(ComplexData.getEntries(profileResult, entry, "root\u001e" + entry.field_15738));
                }
            }
            class_10209.method_64146().method_15407();
        }
        SubtitleTracker.INSTANCE.setEnable(profile.enabled.subtitles);
        class_10209.method_64146().method_15396("registry");
        CustomHudRegistry.runComplexData(profile.enabled);
        class_10209.method_64146().method_15407();
        class_10209.method_64146().method_15407();
    }

    public static ProfilerTimingWithPath getEntries(class_3696 profileResult, class_3534 timing, String path) {
        ArrayList<ProfilerTimingWithPath> entries = new ArrayList<ProfilerTimingWithPath>();
        List timings = profileResult.method_16067(path);
        timings.remove(0);
        for (class_3534 entry : timings) {
            entries.add(ComplexData.getEntries(profileResult, entry, path + "\u001e" + entry.field_15738));
        }
        ProfilerTimingWithPath entry = new ProfilerTimingWithPath(path, timing.field_15738, timing.field_15739, timing.field_15737, timing.method_15409(), entries);
        allEntries.put(path, entry);
        return entry;
    }

    public static void processLog(class_9191 log, double multiplier, int samples, double[] metrics) {
        if (log.method_56663() == 0) {
            metrics[3] = Double.NaN;
            metrics[2] = Double.NaN;
            metrics[1] = Double.NaN;
            metrics[0] = Double.NaN;
            return;
        }
        metrics[0] = 0.0;
        metrics[1] = 2.147483647E9;
        metrics[2] = -2.147483648E9;
        metrics[3] = Math.min(samples, log.method_56663() - 1);
        double avg = 0.0;
        int r = 0;
        while ((double)r < metrics[3]) {
            double s = (double)log.method_56659(r) * multiplier;
            metrics[1] = Math.min(metrics[1], s);
            metrics[2] = Math.max(metrics[2], s);
            avg += s;
            ++r;
        }
        metrics[0] = avg / metrics[3];
    }

    public static void processTPSLog(class_9191 log, double[] metrics) {
        if (log.method_56663() == 0) {
            metrics[3] = Double.NaN;
            metrics[2] = Double.NaN;
            metrics[1] = Double.NaN;
            metrics[0] = Double.NaN;
            return;
        }
        metrics[0] = 0.0;
        metrics[1] = 2.147483647E9;
        metrics[2] = -2.147483648E9;
        metrics[3] = Math.min(120, log.method_56663() - 1);
        double avg = 0.0;
        int r = 0;
        while ((double)r < metrics[3]) {
            double s = Math.min(20.0, 1000.0 / ((double)log.method_56659(r) * 1.0E-6));
            metrics[1] = Math.min(metrics[1], s);
            metrics[2] = Math.max(metrics[2], s);
            avg += s;
            ++r;
        }
        metrics[0] = avg / metrics[3];
    }

    public static void reset() {
        clientChunk = null;
        serverChunk = null;
        serverWorld = null;
        localDifficulty = null;
        world = null;
        sounds = null;
        clientChunkCache = null;
        clicks = null;
        frameTimeMetrics = new double[4];
        tickTimeMetrics = new double[4];
        pingMetrics = new double[4];
        packetSizeMetrics = new double[4];
        velocityXYZ = 0.0;
        velocityY = 0.0;
        velocityXZ = 0.0;
        z1 = 0.0;
        y1 = 0.0;
        x1 = 0.0;
        slots_empty = 0;
        slots_used = 0;
        ComplexData.clicksSoFar[1] = 0;
        ComplexData.clicksSoFar[0] = 0;
        ComplexData.clicksPerSeconds[1] = 0;
        ComplexData.clicksPerSeconds[0] = 0;
    }

    static {
        velocityWaitCounter = 0;
        cpsWaitCounter = 0;
        prevTicks = new long[CentralProcessor.TickType.values().length];
        cpuLoad = 0.0;
        gpuUsage = 0.0;
        clicksSoFar = new int[]{0, 0};
        clicksPerSeconds = new int[]{0, 0};
        clicks = null;
        frameTimeMetrics = new double[4];
        tickTimeMetrics = new double[4];
        pingMetrics = new double[4];
        packetSizeMetrics = new double[4];
        tpsMetrics = new double[4];
        slots_used = 0;
        slots_empty = 0;
        lastStatUpdate = 0L;
        bossbars = new HashMap<UUID, class_1259>();
        villagerOffers = new class_1916();
        villagerXP = 0;
        villagerUUID = null;
        fakeVillagerInteract = 0;
        villagerLastRequested = Long.MAX_VALUE;
        refreshTimings = false;
        rootEntries = Collections.EMPTY_LIST;
        allEntries = Collections.EMPTY_MAP;
    }

    public static class Enabled {
        public static final Enabled DISABLED = new Enabled();
        public final Map<String, Boolean> custom = new HashMap<String, Boolean>();
        public boolean clientChunk = false;
        public boolean serverChunk = false;
        public boolean serverWorld = false;
        public boolean localDifficulty = false;
        public boolean world = false;
        public boolean sound = false;
        public boolean targetBlock = false;
        public boolean targetFluid = false;
        public boolean targetEntity = false;
        public boolean time = false;
        public boolean velocity = false;
        public boolean cpu = false;
        public boolean cpuUsage = false;
        public boolean updateStats = false;
        public boolean clicksPerSeconds = false;
        public boolean music = false;
        public boolean subtitles = false;
        public boolean gpuMetrics = false;
        public boolean frameMetrics = false;
        public boolean tickMetrics = false;
        public boolean tpsMetrics = false;
        public boolean pingMetrics = false;
        public boolean packetMetrics = false;
        public boolean profilerTimings = false;
        public boolean slots = false;
        public boolean targetVillager = false;

        public void merge(Enabled enabled) {
            for (Field field : this.getClass().getFields()) {
                if (field.getType() != Boolean.TYPE) continue;
                try {
                    field.setBoolean(this, field.getBoolean(this) || field.getBoolean(enabled));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.custom.putAll(enabled.custom);
        }

        public boolean get(String name) {
            return this.custom.getOrDefault(name, false);
        }

        public void set(String name) {
            this.custom.put(name, true);
        }

        public void set(String name, boolean value) {
            this.custom.put(name, value);
        }
    }

    public record ProfilerTimingWithPath(String path, String name, double parent, double total, int color, List<ProfilerTimingWithPath> entries) {
    }
}

