/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements;

import com.minenash.customhud.HudElements.StringElement;
import com.minenash.customhud.HudElements.functional.FunctionalElement;
import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.HudElements.interfaces.MultiElement;
import com.minenash.customhud.HudElements.interfaces.NumElement;
import com.minenash.customhud.data.HudTheme;
import com.minenash.customhud.render.CustomHudRenderer3;
import java.util.List;
import net.minecraft.class_2960;

public class RomanNumeralElement
extends FunctionalElement
implements HudElement,
MultiElement {
    private static final class_2960 ROMAN_NUMERAL_FONT = new class_2960("custom_hud", "roman");
    private final HudElement base;
    private final boolean precision;
    private static final int[] values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final String[] least = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
    private static final String[] most = new String[]{"m\ue001", "c\ue001m\ue001", "d\ue001", "c\ue001d\ue001", "c\ue001", "x\ue001c\ue001", "l\ue001", "x\ue001l\ue001", "x\ue001", "i\ue001x\ue001", "v\ue001", "i\ue001v\ue001", "i\ue001"};

    public RomanNumeralElement(HudElement base) {
        NumElement ne;
        this.base = base;
        this.precision = base instanceof NumElement && (ne = (NumElement)((Object)base)).getPrecision() > 0;
    }

    @Override
    public String getString() {
        return this.base.getString();
    }

    @Override
    public Number getNumber() {
        return this.base.getNumber();
    }

    @Override
    public boolean getBoolean() {
        return this.base.getBoolean();
    }

    @Override
    public List<HudElement> expand() {
        HudTheme copy = CustomHudRenderer3.theme.copy();
        copy.font = ROMAN_NUMERAL_FONT;
        return List.of(new FunctionalElement.ChangeTheme(copy), new StringElement(this.precision ? RomanNumeralElement.convert(this.base.getNumber().intValue()) : RomanNumeralElement.convert(this.base.getNumber().doubleValue())), new FunctionalElement.ChangeTheme(CustomHudRenderer3.theme.copy()));
    }

    @Override
    public boolean ignoreNewlineIfEmpty() {
        return true;
    }

    public static String convert(int num) {
        return num == 0 ? "N" : (num < 0 ? "-" + RomanNumeralElement._convert(-1 * num) : RomanNumeralElement._convert(num));
    }

    private static String _convert(int num) {
        if (num < 4000) {
            return RomanNumeralElement.convertSection(num, true);
        }
        if (num < 4000000) {
            return RomanNumeralElement.convertSection(num / 1000, false) + RomanNumeralElement.convertSection(num % 1000, true);
        }
        return "|\ue001" + RomanNumeralElement.convertSection(num / 1000000, false) + "\ue001:" + (num % 1000000 / 1000 > 0 ? RomanNumeralElement.convertSection(num % 1000000 / 1000, false) : "") + RomanNumeralElement.convertSection(num % 1000, true);
    }

    private static String convertSection(int num, boolean rightmost) {
        String[] letters = rightmost ? least : most;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            while (num >= values[i]) {
                result.append(letters[i]);
                num -= values[i];
            }
        }
        return rightmost ? result.toString() : result.substring(0, result.length() - 1);
    }

    public static String convert(double num) {
        int twelfths;
        boolean neg;
        if (num == 0.0) {
            return "N";
        }
        boolean bl = neg = num < 0.0;
        if (neg) {
            num *= -1.0;
        }
        if ((twelfths = (int)Math.round(num % 1.0 * 12.0)) == 12) {
            num += 1.0;
        }
        String string = neg ? "-" : "";
        String string2 = num < 1.0 ? "" : RomanNumeralElement._convert((int)num);
        return string + string2 + (switch (twelfths) {
            case 1 -> "1";
            case 2 -> "2";
            case 3 -> "3";
            case 4 -> "4";
            case 5 -> "5";
            case 6 -> "S";
            case 7 -> "S1";
            case 8 -> "S2";
            case 9 -> "S3";
            case 10 -> "S4";
            case 11 -> "S5";
            default -> "";
        });
    }
}

