/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements.list;

import com.minenash.customhud.CustomHud;
import com.minenash.customhud.complex.ComplexData;
import com.minenash.customhud.mixin.accessors.AttributeContainerAccessor;
import com.minenash.customhud.mixin.accessors.DefaultAttributeContainerAccessor;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_2240;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3002;
import net.minecraft.class_3288;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_640;
import net.minecraft.class_7417;
import net.minecraft.class_7923;

public class AttributeHelpers {
    public static final Function<String, class_1320> ENTITY_ATTR_READER = src -> (class_1320)class_7923.field_41190.method_10223(class_2960.method_12829((String)src));
    public static final Function<String, class_3288> DATA_PACK_READER = src -> CustomHud.CLIENT.method_1576() == null ? null : CustomHud.CLIENT.method_1576().method_3836().method_14449(src);
    private static final Pattern TIMING_PERIOD_TO_SPECIAL = Pattern.compile("(?<!\\\\)\\.");
    public static final Function<String, String> PROFILER_TIMING_READER = src -> {
        if (!((String)(src = TIMING_PERIOD_TO_SPECIAL.matcher((CharSequence)src).replaceAll("\u001e"))).startsWith("root\u001e")) {
            src = "root\u001e" + (String)src;
        }
        return src;
    };
    public static final Function<String, Integer> SLOT_READER = src -> {
        if (src.isBlank()) {
            return null;
        }
        try {
            class_2240 class_22402 = class_2240.method_9473();
            return class_22402.method_9470(new StringReader((String)(switch (src) {
                case "head", "chest", "legs", "feet" -> "armor." + src;
                case "mainhand", "offhand" -> "weapon." + src;
                case "main", "off" -> "weapon." + src + "hand";
                default -> src.length() < 2 ? src : (src.charAt(0) == 'h' && src.charAt(1) != 'o' ? "hotbar." + src.substring(1) : (src.charAt(0) == 'i' && src.charAt(1) != 'n' ? "inventory." + src.substring(1) : src));
            })));
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    };

    public static class_640 getPlayer(String src) {
        class_640 p = CustomHud.CLIENT.method_1562().method_2874(src);
        if (p != null) {
            return p;
        }
        try {
            return CustomHud.CLIENT.method_1562().method_2871(UUID.fromString(src));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class_1297 getFullEntity(class_1297 entity) {
        return CustomHud.CLIENT.method_1576() == null || entity == null ? entity : CustomHud.CLIENT.method_1576().method_3847(entity.method_37908().method_27983()).method_14190(entity.method_5667());
    }

    public static class_1324 getEntityAttr(class_1297 entity, class_1320 attribute) {
        class_1297 e = AttributeHelpers.getFullEntity(entity);
        if (!(e instanceof class_1309)) {
            return null;
        }
        class_1309 le = (class_1309)e;
        return le.method_5996(attribute);
    }

    public static List<?> getEntityAttributes(class_1297 entity) {
        if (!((entity = AttributeHelpers.getFullEntity(entity)) instanceof class_1309)) {
            return Collections.EMPTY_LIST;
        }
        class_1309 le = (class_1309)entity;
        AttributeContainerAccessor container = (AttributeContainerAccessor)le.method_6127();
        HashMap<class_1320, class_1324> instances = new HashMap<class_1320, class_1324>(((DefaultAttributeContainerAccessor)container.getFallback()).getInstances());
        instances.putAll(container.getCustom());
        return Arrays.asList((entity.method_37908().field_9236 ? instances.values().stream().filter(a -> a.method_6198().method_6168()) : instances.values().stream()).sorted(Comparator.comparing(a -> class_1074.method_4662((String)a.method_6198().method_26830(), (Object[])new Object[0]))).toArray());
    }

    public static List<ItemAttribute> getItemStackAttributes(class_1799 stack) {
        if (!stack.method_7985() || !stack.method_7969().method_10573("AttributeModifiers", 9)) {
            ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
            for (class_1304 slot : class_1304.values()) {
                for (Map.Entry entry : stack.method_7909().method_7844(slot).entries()) {
                    attributes.add(new ItemAttribute((class_1320)entry.getKey(), (class_1322)entry.getValue(), slot.method_5923()));
                }
            }
            return attributes;
        }
        ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
        class_2499 nbtList = stack.method_7969().method_10554("AttributeModifiers", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            class_1322 modifier;
            class_2487 nbtCompound = nbtList.method_10602(i);
            class_1320 attribute = (class_1320)class_7923.field_41190.method_10223(class_2960.method_12829((String)nbtCompound.method_10558("AttributeName")));
            if (attribute == null || (modifier = class_1322.method_26859((class_2487)nbtCompound)) == null || modifier.method_6189().getLeastSignificantBits() == 0L || modifier.method_6189().getMostSignificantBits() == 0L) continue;
            String slot = nbtCompound.method_10558("Slot");
            if (slot.isEmpty()) {
                slot = "all";
            }
            attributes.add(new ItemAttribute(attribute, modifier, slot));
        }
        return attributes;
    }

    public static List<class_2561> getLore(class_1799 stack) {
        class_2487 nbtCompound;
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        if (stack.method_7985() && stack.method_7969().method_10573("display", 10) && (nbtCompound = stack.method_7969().method_10562("display")).method_10540("Lore") == 9) {
            class_2499 nbtList = nbtCompound.method_10554("Lore", 8);
            for (int j = 0; j < nbtList.size(); ++j) {
                try {
                    class_5250 mutableText2 = class_2561.class_2562.method_10877((String)nbtList.method_10608(j));
                    if (mutableText2 == null) continue;
                    lines.add((class_2561)mutableText2);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return lines;
    }

    public static List<class_2248> getCanX(class_1799 stack, String tag) {
        class_2487 nbtCompound = stack.method_7969();
        if (nbtCompound == null || !nbtCompound.method_10573(tag, 9)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<class_2248> items = new ArrayList<class_2248>();
        class_2499 nbtList = nbtCompound.method_10554(tag, 8);
        for (int i = 0; i < nbtList.size(); ++i) {
            String string = nbtList.method_10608(i);
            class_2248 block = (class_2248)class_7923.field_41175.method_10223(class_2960.method_12829((String)string));
            if (block == class_2246.field_10124) continue;
            items.add(block);
        }
        return items;
    }

    public static List<String> getHideFlagStrings(class_1799 stack, boolean shown) {
        ArrayList<String> sections = new ArrayList<String>();
        int flags = stack.method_30266();
        for (class_1799.class_5422 flag : class_1799.class_5422.values()) {
            if (shown != ((flags & flag.method_30269()) == 0)) continue;
            sections.add(flag.name().toLowerCase());
        }
        return sections;
    }

    public static List<class_1799> compactItems(List<class_1799> stacks) {
        ArrayList<class_1799> compact = new ArrayList<class_1799>();
        block0: for (class_1799 stack : stacks) {
            if (stack.method_7960()) continue;
            for (class_1799 cStack : compact) {
                if (!class_1799.method_31577((class_1799)stack, (class_1799)cStack)) continue;
                cStack.method_7939(cStack.method_7947() + stack.method_7947());
                continue block0;
            }
            compact.add(stack.method_7972());
        }
        return compact;
    }

    public static List<class_1799> getItemItems(class_1799 stack, boolean returnStack) {
        class_2487 nbt = stack.method_7969();
        if (stack.method_7960() || nbt == null) {
            return returnStack ? Collections.singletonList(stack) : Collections.EMPTY_LIST;
        }
        if (nbt.method_10573("Items", 9)) {
            return AttributeHelpers.getItemItemsInternal(stack, nbt.method_10554("Items", 10), returnStack);
        }
        if (!nbt.method_10545("BlockEntityTag")) {
            return returnStack ? Collections.singletonList(stack) : Collections.EMPTY_LIST;
        }
        if (!(nbt = nbt.method_10562("BlockEntityTag")).method_10573("Items", 9)) {
            return returnStack ? Collections.singletonList(stack) : Collections.EMPTY_LIST;
        }
        return AttributeHelpers.getItemItemsInternal(stack, nbt.method_10554("Items", 10), returnStack);
    }

    private static List<class_1799> getItemItemsInternal(class_1799 stack, class_2499 list, boolean returnStack) {
        ArrayList<class_1799> items = new ArrayList<class_1799>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            List<class_1799> inner = AttributeHelpers.getItemItems(class_1799.method_7915((class_2487)list.method_10602(i)), true);
            for (class_1799 is : inner) {
                is.method_7939(is.method_7947() * stack.method_7947());
            }
            items.addAll(inner);
        }
        if (items.isEmpty() && returnStack) {
            return Collections.singletonList(stack);
        }
        return items;
    }

    public static class_269 scoreboard() {
        return CustomHud.CLIENT.method_1576() != null ? CustomHud.CLIENT.method_1576().method_3845() : CustomHud.CLIENT.field_1687.method_8428();
    }

    public static boolean entryOnline(String entry) {
        if (null != (CustomHud.CLIENT.method_1576() != null ? CustomHud.CLIENT.method_1576().method_3760().method_14566(entry) : CustomHud.CLIENT.method_1562().method_2874(entry))) {
            return true;
        }
        if (ComplexData.serverWorld == null) {
            return false;
        }
        try {
            return ComplexData.serverWorld.field_26935.method_31827(UUID.fromString(entry));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static List<?> bossbars(boolean all) {
        if (CustomHud.CLIENT.method_1576() == null) {
            return Arrays.asList(CustomHud.CLIENT.field_1705.method_1740().field_2060.entrySet().toArray());
        }
        ArrayList<Object> serverBossbars = new ArrayList<Object>();
        serverBossbars.addAll(CustomHud.CLIENT.method_1576().method_3837().field_13447.values());
        serverBossbars.addAll(ComplexData.bossbars.values());
        if (all) {
            return serverBossbars;
        }
        Set client = CustomHud.CLIENT.field_1705.method_1740().field_2060.keySet();
        return Arrays.asList(serverBossbars.stream().filter(bar -> client.contains(bar.method_5407())).toArray());
    }

    public static class_1259 getBossBar(String input) {
        boolean client = CustomHud.CLIENT.method_1576() == null;
        try {
            UUID uuid = UUID.fromString(input);
            if (client) {
                return (class_1259)CustomHud.CLIENT.field_1705.method_1740().field_2060.get(uuid);
            }
            for (class_1259 bar : CustomHud.CLIENT.method_1576().method_3837().field_13447.values()) {
                if (bar.method_5407() != uuid) continue;
                return bar;
            }
            class_1259 bb = ComplexData.bossbars.get(uuid);
            if (bb != null) {
                return bb;
            }
        }
        catch (Exception uuid) {
            // empty catch block
        }
        if (client) {
            for (class_1259 bar : CustomHud.CLIENT.field_1705.method_1740().field_2060.values()) {
                if (!bar.method_5414().getString().equalsIgnoreCase(input)) continue;
                return bar;
            }
        } else {
            class_3002 bar = CustomHud.CLIENT.method_1576().method_3837().method_12971(class_2960.method_12829((String)input));
            if (bar != null) {
                return bar;
            }
            for (class_1259 bar2 : CustomHud.CLIENT.method_1576().method_3837().field_13447.values()) {
                if (!bar2.method_5414().getString().equalsIgnoreCase(input)) continue;
                return bar2;
            }
            for (class_1259 bar2 : ComplexData.bossbars.values()) {
                if (!bar2.method_5414().getString().equalsIgnoreCase(input)) continue;
                return bar2;
            }
        }
        return null;
    }

    public static int getBossBarColor(class_1259 bar) {
        return switch (bar.method_5420()) {
            default -> throw new IncompatibleClassChangeError();
            case class_1259.class_1260.field_5788 -> 15466680;
            case class_1259.class_1260.field_5780 -> 47084;
            case class_1259.class_1260.field_5784 -> 15480064;
            case class_1259.class_1260.field_5785 -> 1960960;
            case class_1259.class_1260.field_5782 -> 15330304;
            case class_1259.class_1260.field_5783 -> 8061164;
            case class_1259.class_1260.field_5786 -> 0xECECEC;
        };
    }

    public static double getRelativeYaw(class_243 player, class_243 other) {
        return class_3532.method_15338((double)((double)CustomHud.CLIENT.field_1724.method_36454() - Math.toDegrees(class_3532.method_15349((double)(-(other.method_10216() - player.method_10216())), (double)(other.method_10215() - player.method_10215())))));
    }

    public static double getRelativePitch(class_243 player, class_243 other) {
        double xDist = other.method_10216() - player.method_10216();
        double zDist = other.method_10215() - player.method_10215();
        return class_3532.method_15338((double)((double)CustomHud.CLIENT.field_1724.method_36455() + Math.toDegrees(class_3532.method_15349((double)(other.method_10214() - player.method_10214()), (double)Math.sqrt(xDist * xDist + zDist * zDist)))));
    }

    public static boolean isFabricRP(class_3288 pack) {
        class_2588 ttc;
        class_7417 content = pack.method_14457().method_10851();
        return pack.method_14463().equals("fabric") || content instanceof class_2588 && ((ttc = (class_2588)content).method_11022().equals("pack.name.fabricMod") || ttc.method_11022().equals("pack.name.fabricMods"));
    }

    public record ItemAttribute(class_1320 attribute, class_1322 modifier, String slot) {
    }

    public record ReceivedPower(class_2350 direction, int power, int strongPower) {
    }
}

