/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements.list;

import com.minenash.customhud.CustomHud;
import com.minenash.customhud.HudElements.FuncElements;
import com.minenash.customhud.HudElements.functional.FunctionalElement;
import com.minenash.customhud.HudElements.icon.BossbarIcon;
import com.minenash.customhud.HudElements.icon.ItemConvertableIconElement;
import com.minenash.customhud.HudElements.icon.ListRecordIconElement;
import com.minenash.customhud.HudElements.icon.ModBadgeIconElement;
import com.minenash.customhud.HudElements.icon.ModIconElement;
import com.minenash.customhud.HudElements.icon.PackIconElement;
import com.minenash.customhud.HudElements.icon.RichItemSupplierIconElement;
import com.minenash.customhud.HudElements.icon.StatusEffectIconElement;
import com.minenash.customhud.HudElements.icon.SupPlayerHeadIconElement;
import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.HudElements.list.AttributeFunctions;
import com.minenash.customhud.HudElements.list.AttributeHelpers;
import com.minenash.customhud.HudElements.list.ListProvider;
import com.minenash.customhud.HudElements.list.ListProviderSet;
import com.minenash.customhud.HudElements.list.ListSuppliers;
import com.minenash.customhud.HudElements.supplier.NumberSupplierElement;
import com.minenash.customhud.HudElements.supplier.StringSupplierElement;
import com.minenash.customhud.VariableParser;
import com.minenash.customhud.complex.ComplexData;
import com.minenash.customhud.complex.ListManager;
import com.minenash.customhud.complex.MusicAndRecordTracker;
import com.minenash.customhud.data.Flags;
import com.minenash.customhud.data.Profile;
import com.minenash.customhud.errors.ErrorType;
import com.minenash.customhud.registry.ParseContext;
import com.minenash.customhud.render.RenderPiece;
import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_1259;
import net.minecraft.class_1293;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_268;
import net.minecraft.class_2960;
import net.minecraft.class_303;
import net.minecraft.class_3288;
import net.minecraft.class_359;
import net.minecraft.class_640;
import net.minecraft.class_7923;
import net.minecraft.class_9011;

public class Attributers {
    public static final Attributer EFFECT = (pid, sup, name, flags, context) -> switch (name) {
        case "name" -> new FuncElements.Str<class_1293>(sup, AttributeFunctions.STATUS_NAME);
        case "", "id" -> new FuncElements.Id<class_1293>(sup, AttributeFunctions.STATUS_ID, flags);
        case "duration", "dur" -> new FuncElements.Num<class_1293>(sup, AttributeFunctions.STATUS_DURATION, flags);
        case "infinite", "inf" -> new FuncElements.Bool<class_1293>(sup, AttributeFunctions.STATUS_INFINITE);
        case "amplification", "amp" -> new FuncElements.Num<class_1293>(sup, AttributeFunctions.STATUS_AMPLIFICATION, flags);
        case "level", "lvl" -> new FuncElements.Num<class_1293>(sup, AttributeFunctions.STATUS_LEVEL, flags);
        case "ambient" -> new FuncElements.Bool<class_1293>(sup, AttributeFunctions.STATUS_AMBIENT);
        case "show_particles", "particles" -> new FuncElements.Bool<class_1293>(sup, AttributeFunctions.STATUS_SHOW_PARTICLES);
        case "show_icon" -> new FuncElements.Bool<class_1293>(sup, AttributeFunctions.STATUS_SHOW_ICON);
        case "color" -> new FuncElements.Num<class_1293>(sup, AttributeFunctions.STATUS_COLOR, flags);
        case "category", "cat" -> new FuncElements.Special<class_1293>(sup, AttributeFunctions.STATUS_CATEGORY);
        case "icon" -> new StatusEffectIconElement(pid, sup, flags, true);
        case "icon_no_bg" -> new StatusEffectIconElement(pid, sup, flags, false);
        default -> null;
    };
    private static Attributer TEAM2;
    public static final Attributer PLAYER;
    public static final Attributer SUBTITLE;
    public static final Attributer BLOCK_PROPERTY;
    public static final Attributer RECEIVED_POWER;
    public static final Attributer TAG;
    public static final Attributer ENCHANTMENT;
    public static final Attributer ITEM_LORE_LINE;
    public static final Attributer ITEM_INFO_INFO;
    public static final Attributer LOOP_ITEM;
    public static final Attributer ITEM_ATTRIBUTE_MODIFIER;
    public static final Attributer ITEM_CAN_X;
    public static Attributer ITEM2;
    public static final Attributer ITEM;
    public static final Attributer ATTRIBUTE_MODIFIER;
    public static final Attributer ATTRIBUTE;
    public static final Attributer TEAM_MEMBER;
    public static final Attributer TEAM;
    public static final Attributer SCOREBOARD_OBJECTIVE_SCORE;
    public static final Attributer SCOREBOARD_OBJECTIVE;
    public static final Attributer SCOREBOARD_SCORE;
    public static final Attributer BOSSBAR;
    public static Attributer PROFILER_TIMING2;
    public static final Attributer PROFILER_TIMING;
    public static final Attributer MOD_AUTHOR;
    public static final Attributer MOD_CONTRIBUTOR;
    public static final Attributer MOD_CREDIT;
    public static final Attributer MOD_LICENSE;
    public static final Attributer MOD_BADGE;
    private static Attributer MOD2;
    public static final Attributer MOD;
    public static final Attributer PACK;
    public static final Attributer RECORD;
    public static final Attributer OFFER;
    public static final Attributer ITEM_CONVERTABLE_TAG_ENTRY;
    public static final Attributer CHAT_MESSAGE;
    public static final Map<ListProvider, Attributer> ATTRIBUTER_MAP;
    public static final Map<Attributer, String> DEFAULT_PREFIX;

    public static HudElement get(ListProviderSet set, String name, Flags flags, Profile profile, int line) {
        for (int i = set.entries.size() - 1; i >= 0; --i) {
            HudElement e = Attributers.get0(set.entries.get(i), name, flags, profile, line);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public static HudElement getFromPrefix(ListProviderSet set, String part, Flags flags, Profile profile, int line) {
        for (int i = set.entries.size() - 1; i >= 0; --i) {
            ListProviderSet.Entry entry = set.entries.get(i);
            if (entry == null || !part.startsWith(entry.prefix() + ":")) continue;
            return Attributers.get0(entry, part.substring(part.indexOf(58) + 1), flags, profile, line);
        }
        return null;
    }

    public static HudElement get0(ListProviderSet.Entry entry, String part, Flags flags, Profile profile, int line) {
        ParseContext context;
        HudElement element;
        if (entry == null) {
            return null;
        }
        UUID finalProviderID = entry.id();
        switch (part) {
            case "size": 
            case "c": {
                return new NumberSupplierElement(() -> ListManager.getCount(finalProviderID), flags);
            }
            case "index": 
            case "i": {
                return new NumberSupplierElement(() -> ListManager.getIndex(finalProviderID), flags);
            }
            case "raw": {
                return new StringSupplierElement(() -> ListManager.getValue(finalProviderID).toString());
            }
            case "exit": {
                return new FunctionalElement.ExitList(finalProviderID);
            }
            case "continue": {
                return new FunctionalElement.ContinueList(finalProviderID);
            }
        }
        Attributer attributer = ATTRIBUTER_MAP.get(entry.provider());
        if (attributer == null) {
            CustomHud.LOGGER.error("[CustomHud] [FIX ME]: Attributer not in Map!");
            return null;
        }
        String prefix = flags.listPrefix;
        int dotIndex = part.lastIndexOf(46);
        if (dotIndex != -1) {
            part = part.substring(0, dotIndex);
        }
        if ((element = attributer.get(finalProviderID, () -> ListManager.getValue(finalProviderID), part, flags, context = new ParseContext(profile, line, null, null))) instanceof FunctionalElement.CreateListElement) {
            FunctionalElement.CreateListElement cle = (FunctionalElement.CreateListElement)element;
            String attr = dotIndex == -1 ? "" : part.substring(dotIndex + 1);
            cle.attribute = Attributers.get(new ListProviderSet().with(cle.entry), attr, new Flags(), profile, line);
        }
        return element;
    }

    public static String defaultPrefix(ListProvider provider) {
        return DEFAULT_PREFIX.get(ATTRIBUTER_MAP.get(provider));
    }

    private static /* synthetic */ Object lambda$static$48(Supplier sup) {
        return new class_1799((class_1935)((class_1935)sup.get()).method_8389());
    }

    private static /* synthetic */ class_1799 lambda$static$46(Supplier sup) {
        return ((class_1914)sup.get()).method_8250();
    }

    private static /* synthetic */ Object lambda$static$45(Supplier sup) {
        return arg_0 -> Attributers.lambda$static$44((Supplier)sup, arg_0);
    }

    private static /* synthetic */ class_1799 lambda$static$44(Supplier sup, RenderPiece piece) {
        return ((class_1914)(piece == null ? sup.get() : piece.value)).method_8250();
    }

    private static /* synthetic */ class_1799 lambda$static$43(Supplier sup) {
        return ((class_1914)sup.get()).method_8247();
    }

    private static /* synthetic */ Object lambda$static$42(Supplier sup) {
        return arg_0 -> Attributers.lambda$static$41((Supplier)sup, arg_0);
    }

    private static /* synthetic */ class_1799 lambda$static$41(Supplier sup, RenderPiece piece) {
        return ((class_1914)(piece == null ? sup.get() : piece.value)).method_8247();
    }

    private static /* synthetic */ class_1799 lambda$static$40(Supplier sup) {
        return ((class_1914)sup.get()).method_8246();
    }

    private static /* synthetic */ Object lambda$static$39(Supplier sup) {
        return arg_0 -> Attributers.lambda$static$38((Supplier)sup, arg_0);
    }

    private static /* synthetic */ class_1799 lambda$static$38(Supplier sup, RenderPiece piece) {
        return ((class_1914)(piece == null ? sup.get() : piece.value)).method_8246();
    }

    private static /* synthetic */ class_1799 lambda$static$37(Supplier sup) {
        return ((class_1914)sup.get()).method_19272();
    }

    private static /* synthetic */ Object lambda$static$36(Supplier sup) {
        return arg_0 -> Attributers.lambda$static$35((Supplier)sup, arg_0);
    }

    private static /* synthetic */ class_1799 lambda$static$35(Supplier sup, RenderPiece piece) {
        return ((class_1914)(piece == null ? sup.get() : piece.value)).method_19272();
    }

    private static /* synthetic */ Object lambda$static$31(Supplier sup) {
        return ModMenu.MODS.get(((Mod)sup.get()).getParent());
    }

    private static /* synthetic */ Supplier lambda$static$15(Supplier sup, class_1887 enchant) {
        return () -> Attributers.lambda$static$14((Supplier)sup, enchant);
    }

    private static /* synthetic */ Object lambda$static$14(Supplier sup, class_1887 enchant) {
        class_1799 stack = (class_1799)sup.get();
        if (stack.method_7960()) {
            return null;
        }
        Integer lvl = (Integer)class_1890.method_8222((class_1799)((class_1799)sup.get())).get(enchant);
        return lvl == null ? null : Map.entry(enchant, lvl);
    }

    private static /* synthetic */ Object lambda$static$1(Supplier sup) {
        return ((class_640)sup.get()).method_2955();
    }

    static {
        PLAYER = (pid, sup, name, flags, context) -> {
            if (name.startsWith("team:")) {
                String attr = name.substring(5);
                Supplier<Object> sup2 = () -> Attributers.lambda$static$1((Supplier)sup);
                return TEAM2.get(pid, sup2, attr, flags, context);
            }
            return switch (name) {
                case "name", "display_name" -> new FuncElements.Tex<class_640>(sup, AttributeFunctions.PLAYER_ENTRY_DISPLAY_NAME);
                case "", "username" -> new FuncElements.Str<class_640>(sup, AttributeFunctions.PLAYER_ENTRY_NAME);
                case "id", "uuid" -> new FuncElements.Str<class_640>(sup, AttributeFunctions.PLAYER_ENTRY_UUID);
                case "team" -> new FuncElements.Str<class_640>(sup, AttributeFunctions.PLAYER_ENTRY_TEAM);
                case "latency" -> new FuncElements.Num<class_640>(sup, AttributeFunctions.PLAYER_ENTRY_LATENCY, flags);
                case "list_score" -> new FuncElements.Num<class_640>(sup, AttributeFunctions.PLAYER_ENTRY_LIST_SCORE, flags);
                case "gamemode" -> new FuncElements.Special<class_640>(sup, AttributeFunctions.PLAYER_ENTRY_GAMEMODE);
                case "survival" -> new FuncElements.Bool<class_640>(sup, AttributeFunctions.PLAYER_ENTRY_SURVIVAL);
                case "creative" -> new FuncElements.Bool<class_640>(sup, AttributeFunctions.PLAYER_ENTRY_CREATIVE);
                case "adventure" -> new FuncElements.Bool<class_640>(sup, AttributeFunctions.PLAYER_ENTRY_ADVENTURE);
                case "spectator" -> new FuncElements.Bool<class_640>(sup, AttributeFunctions.PLAYER_ENTRY_SPECTATOR);
                case "head" -> new SupPlayerHeadIconElement(pid, sup, flags);
                default -> null;
            };
        };
        SUBTITLE = (pid, sup, name, flags, context) -> switch (name) {
            case "", "id" -> new FuncElements.Id<class_359.class_360>(sup, AttributeFunctions.SUBTITLE_ID, flags);
            case "name" -> new FuncElements.Str<class_359.class_360>(sup, AttributeFunctions.SUBTITLE_NAME);
            case "age" -> new FuncElements.Num<class_359.class_360>(sup, AttributeFunctions.SUBTITLE_AGE, flags);
            case "time" -> new FuncElements.Num<class_359.class_360>(sup, AttributeFunctions.SUBTITLE_TIME, flags);
            case "alpha" -> new FuncElements.Num<class_359.class_360>(sup, AttributeFunctions.SUBTITLE_ALPHA, flags);
            case "x" -> new FuncElements.Num<class_359.class_360>(sup, AttributeFunctions.SUBTITLE_X, flags);
            case "y" -> new FuncElements.Num<class_359.class_360>(sup, AttributeFunctions.SUBTITLE_Y, flags);
            case "z" -> new FuncElements.Num<class_359.class_360>(sup, AttributeFunctions.SUBTITLE_Z, flags);
            case "dist", "distance" -> new FuncElements.Num<class_359.class_360>(sup, AttributeFunctions.SUBTITLE_DISTANCE, flags);
            case "dir", "direction" -> new FuncElements.Str<class_359.class_360>(sup, AttributeFunctions.SUBTITLE_DIRECTION);
            case "left" -> new FuncElements.Bool<class_359.class_360>(sup, AttributeFunctions.SUBTITLE_LEFT);
            case "right" -> new FuncElements.Bool<class_359.class_360>(sup, AttributeFunctions.SUBTITLE_RIGHT);
            case "dir_yaw", "direction_yaw" -> new FuncElements.Num<class_359.class_360>(sup, AttributeFunctions.SUBTITLE_DIRECTION_YAW, flags);
            case "dir_pitch", "direction_pitch" -> new FuncElements.Num<class_359.class_360>(sup, AttributeFunctions.SUBTITLE_DIRECTION_PITCH, flags);
            default -> null;
        };
        BLOCK_PROPERTY = (pid, sup, name, flags, context) -> switch (name) {
            case "", "name" -> new FuncElements.Str(sup, AttributeFunctions.BLOCK_STATE_NAME);
            case "type" -> new FuncElements.Special(sup, AttributeFunctions.BLOCK_STATE_TYPE);
            case "full_type" -> new FuncElements.Str(sup, AttributeFunctions.BLOCK_STATE_FULL_TYPE);
            case "value" -> new FuncElements.Str(sup, AttributeFunctions.BLOCK_STATE_VALUE);
            default -> null;
        };
        RECEIVED_POWER = (pid, sup, name, flags, context) -> switch (name) {
            case "direction", "dir" -> new FuncElements.Str<AttributeHelpers.ReceivedPower>(sup, AttributeFunctions.REC_DIRECTION);
            case "opposite_direction", "odir" -> new FuncElements.Str<AttributeHelpers.ReceivedPower>(sup, AttributeFunctions.REC_DIRECTION);
            case "", "power" -> new FuncElements.Num<AttributeHelpers.ReceivedPower>(sup, AttributeFunctions.REC_POWER, flags);
            case "strong_power", "strong" -> new FuncElements.Num<AttributeHelpers.ReceivedPower>(sup, AttributeFunctions.REC_STRONG_POWER, flags);
            default -> null;
        };
        TAG = (pid, sup, name, flags, context) -> switch (name) {
            case "name" -> new FuncElements.Str(sup, AttributeFunctions.TAG_NAME);
            case "", "id" -> new FuncElements.Id(sup, AttributeFunctions.TAG_ID, flags);
            default -> null;
        };
        ENCHANTMENT = (pid, sup, name, flags, context) -> switch (name) {
            case "name" -> new FuncElements.Str<Map.Entry<class_1887, Integer>>(sup, AttributeFunctions.ENCHANT_NAME);
            case "", "id" -> new FuncElements.Id<Map.Entry<class_1887, Integer>>(sup, AttributeFunctions.ENCHANT_ID, flags);
            case "full" -> new FuncElements.Str<Map.Entry<class_1887, Integer>>(sup, AttributeFunctions.ENCHANT_FULL);
            case "level", "lvl" -> new FuncElements.Special<Map.Entry<class_1887, Integer>>(sup, AttributeFunctions.ENCHANT_LEVEL);
            case "max_level", "max_lvl" -> new FuncElements.Special<Map.Entry<class_1887, Integer>>(sup, AttributeFunctions.ENCHANT_MAX_LEVEL);
            case "num", "number" -> new FuncElements.Num<Map.Entry<class_1887, Integer>>(sup, AttributeFunctions.ENCHANT_NUM, flags);
            case "max_num", "max_number" -> new FuncElements.Num<Map.Entry<class_1887, Integer>>(sup, AttributeFunctions.ENCHANT_MAX_NUM, flags);
            case "rarity" -> new FuncElements.Str<Map.Entry<class_1887, Integer>>(sup, AttributeFunctions.ENCHANT_RARITY);
            default -> null;
        };
        ITEM_LORE_LINE = (pid, sup, name, flags, context) -> name.isEmpty() || name.equals("line") ? new FuncElements.Tex(sup, AttributeFunctions.DIRECT) : null;
        ITEM_INFO_INFO = (pid, sup, name, flags, context) -> name.isEmpty() || name.equals("info") ? new FuncElements.Str(sup, AttributeFunctions.DIRECT) : null;
        LOOP_ITEM = (pid, sup, name, flags, context) -> name.isEmpty() || name.equals("value") ? new FuncElements.Num(sup, AttributeFunctions.DIRECT, flags) : null;
        ITEM_ATTRIBUTE_MODIFIER = (pid, sup, name, flags, context) -> switch (name) {
            case "slot" -> new FuncElements.Str<AttributeHelpers.ItemAttribute>(sup, AttributeFunctions.ITEM_ATTR_SLOT);
            case "attribute", "attr" -> new FuncElements.Str<AttributeHelpers.ItemAttribute>(sup, AttributeFunctions.ITEM_ATTR_NAME);
            case "attribute_id", "attr_id" -> new FuncElements.Id<AttributeHelpers.ItemAttribute>(sup, AttributeFunctions.ITEM_ATTR_ID, flags);
            case "tracked" -> new FuncElements.Bool<AttributeHelpers.ItemAttribute>(sup, AttributeFunctions.ITEM_ATTR_TRACKED);
            case "default_value" -> new FuncElements.Num<AttributeHelpers.ItemAttribute>(sup, AttributeFunctions.ITEM_ATTR_VALUE_DEFAULT, flags);
            case "attribute_value", "attr_value" -> new FuncElements.Num<AttributeHelpers.ItemAttribute>(sup, AttributeFunctions.ITEM_ATTR_VALUE, flags);
            case "", "modifier_name", "mod_name" -> new FuncElements.Str<AttributeHelpers.ItemAttribute>(sup, AttributeFunctions.ITEM_ATTR_MODIFIER_NAME);
            case "modifier_id", "mod_id" -> new FuncElements.Str<AttributeHelpers.ItemAttribute>(sup, AttributeFunctions.ITEM_ATTR_MODIFIER_ID);
            case "mod_amount", "amount" -> new FuncElements.Num<AttributeHelpers.ItemAttribute>(sup, AttributeFunctions.ITEM_ATTR_MODIFIER_VALUE, flags);
            case "op", "operation" -> new FuncElements.Str<AttributeHelpers.ItemAttribute>(sup, AttributeFunctions.ITEM_ATTR_MODIFIER_OPERATION);
            case "op_name", "operation_name" -> new FuncElements.Str<AttributeHelpers.ItemAttribute>(sup, AttributeFunctions.ITEM_ATTR_MODIFIER_OPERATION_NAME);
            default -> null;
        };
        ITEM_CAN_X = (pid, sup, name, flags, context) -> switch (name) {
            case "name" -> new FuncElements.Str<class_2248>(sup, AttributeFunctions.BLOCK_NAME);
            case "", "id" -> new FuncElements.Id<class_2248>(sup, AttributeFunctions.BLOCK_ID, flags);
            case "icon" -> new ItemConvertableIconElement(pid, sup, flags);
            default -> null;
        };
        ITEM2 = ITEM = (pid, sup, name, flags, context) -> {
            if (name.startsWith("enchant:")) {
                return VariableParser.attrElement(name, src -> (class_1887)class_7923.field_41176.method_10223(class_2960.method_12829((String)src)), true, arg_0 -> Attributers.lambda$static$15((Supplier)sup, arg_0), ENCHANTMENT, ErrorType.UNKNOWN_EFFECT_ID, ErrorType.UNKNOWN_EFFECT_METHOD, context.profile(), context.line(), context.enabled(), name);
            }
            return switch (name) {
                case "", "item" -> new FuncElements.Special<class_1799>(sup, AttributeFunctions.ITEM_NAME, AttributeFunctions.ITEM_RAW_ID, AttributeFunctions.ITEM_IS_NOT_EMPTY);
                case "id" -> new FuncElements.SpecialId<class_1799>(sup, AttributeFunctions.ITEM_ID, AttributeFunctions.ITEM_RAW_ID, AttributeFunctions.ITEM_IS_NOT_EMPTY, flags);
                case "name" -> new FuncElements.SpecialText<class_1799>(sup, AttributeFunctions.ITEM_CUSTOM_NAME);
                case "count" -> new FuncElements.NumBool<class_1799>(sup, AttributeFunctions.ITEM_COUNT, AttributeFunctions.ITEM_IS_NOT_EMPTY, flags);
                case "max_count" -> new FuncElements.NumBool<class_1799>(sup, AttributeFunctions.ITEM_MAX_COUNT, AttributeFunctions.ITEM_IS_STACKABLE, flags);
                case "inv_count" -> new FuncElements.NumBool<class_1799>(sup, AttributeFunctions.ITEM_INV_COUNT, AttributeFunctions.ITEM_HAS_MORE_OUT_OF_STACK, flags);
                case "dur", "durability" -> new FuncElements.NumBool<class_1799>(sup, AttributeFunctions.ITEM_DURABILITY, AttributeFunctions.ITEM_HAS_DURABILITY, flags);
                case "max_dur", "max_durability" -> new FuncElements.NumBool<class_1799>(sup, AttributeFunctions.ITEM_MAX_DURABILITY, AttributeFunctions.ITEM_HAS_MAX_DURABILITY, flags);
                case "dur_per", "durability_percentage" -> new FuncElements.NumBool<class_1799>(sup, AttributeFunctions.ITEM_DURABILITY_PERCENT, AttributeFunctions.ITEM_HAS_MAX_DURABILITY, flags);
                case "dur_color", "durability_color" -> new FuncElements.NumBool<class_1799>(sup, AttributeFunctions.ITEM_DURABILITY_COLOR, AttributeFunctions.ITEM_HAS_MAX_DURABILITY, flags);
                case "unbreakable" -> new FuncElements.Bool<class_1799>(sup, AttributeFunctions.ITEM_UNBREAKABLE);
                case "repair_cost" -> new FuncElements.Num<class_1799>(sup, AttributeFunctions.ITEM_REPAIR_COST, flags);
                case "icon" -> new RichItemSupplierIconElement(pid, sup, flags, false);
                case "inv_count_icon" -> new RichItemSupplierIconElement(pid, sup, flags, true);
                case "hide_flags" -> new FuncElements.Num<class_1799>(sup, AttributeFunctions.ITEM_HIDE_FLAGS_NUM, flags);
                case "rarity" -> new FuncElements.Special<class_1799>(sup, AttributeFunctions.ITEM_RARITY);
                case "armor_slot" -> new FuncElements.Special<class_1799>(sup, AttributeFunctions.ITEM_ARMOR_SLOT);
                case "enchants" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.ITEM_ENCHANTS, ENCHANTMENT, flags);
                case "lore" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.ITEM_LORE_LINES, ITEM_LORE_LINE, flags);
                case "attributes", "attrs" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.ITEM_ATTRIBUTES, ITEM_ATTRIBUTE_MODIFIER, flags);
                case "can_destroy" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.ITEM_CAN_DESTROY, ITEM_CAN_X, flags);
                case "can_place_on" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.ITEM_CAN_PLAY_ON, ITEM_CAN_X, flags);
                case "info_shown" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.ITEM_SHOWN, ITEM_INFO_INFO, flags);
                case "info_hidden" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.ITEM_HIDDEN, ITEM_INFO_INFO, flags);
                case "tags" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.ITEM_TAGS, TAG, flags);
                case "items" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.ITEM_ITEMS, ITEM2, flags);
                case "items_compact" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.ITEM_ITEMS_COMPACT, ITEM2, flags);
                default -> null;
            };
        };
        ATTRIBUTE_MODIFIER = (pid, sup, name, flags, context) -> switch (name) {
            case "", "name" -> new FuncElements.Str<class_1322>(sup, AttributeFunctions.ATTRIBUTE_MODIFIER_NAME);
            case "id" -> new FuncElements.Str<class_1322>(sup, AttributeFunctions.ATTRIBUTE_MODIFIER_ID);
            case "value" -> new FuncElements.Num<class_1322>(sup, AttributeFunctions.ATTRIBUTE_MODIFIER_VALUE, flags);
            case "op", "operation" -> new FuncElements.Str<class_1322>(sup, AttributeFunctions.ATTRIBUTE_MODIFIER_OPERATION);
            case "op_name", "operation_name" -> new FuncElements.Str<class_1322>(sup, AttributeFunctions.ATTRIBUTE_MODIFIER_OPERATION_NAME);
            default -> null;
        };
        ATTRIBUTE = (pid, sup, name, flags, context) -> switch (name) {
            case "name" -> new FuncElements.Str<class_1324>(sup, AttributeFunctions.ATTRIBUTE_NAME);
            case "", "id" -> new FuncElements.Id<class_1324>(sup, AttributeFunctions.ATTRIBUTE_ID, flags);
            case "tracked" -> new FuncElements.Bool<class_1324>(sup, AttributeFunctions.ATTRIBUTE_TRACKED);
            case "default_value" -> new FuncElements.Num<class_1324>(sup, AttributeFunctions.ATTRIBUTE_VALUE_DEFAULT, flags);
            case "base_value" -> new FuncElements.Num<class_1324>(sup, AttributeFunctions.ATTRIBUTE_VALUE_BASE, flags);
            case "value" -> new FuncElements.Num<class_1324>(sup, AttributeFunctions.ATTRIBUTE_VALUE, flags);
            case "modifiers" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.ATTRIBUTE_MODIFIERS, ATTRIBUTE_MODIFIER, flags);
            default -> null;
        };
        TEAM_MEMBER = (pid, sup, name, flags, context) -> name.isEmpty() || name.equals("member") ? new FuncElements.Str(sup, AttributeFunctions.DIRECT) : null;
        TEAM2 = TEAM = (pid, sup, name, flags, context) -> switch (name) {
            case "name" -> new FuncElements.Tex<class_268>(sup, AttributeFunctions.TEAM_NAME);
            case "", "id" -> new FuncElements.Str<class_268>(sup, AttributeFunctions.TEAM_ID);
            case "friendly_fire" -> new FuncElements.Bool<class_268>(sup, AttributeFunctions.TEAM_FRIENDLY_FIRE);
            case "see_friendly_invisibility", "friendly_invis" -> new FuncElements.Bool<class_268>(sup, AttributeFunctions.TEAM_FRIENDLY_INVIS);
            case "name_tag_visibility", "name_tag" -> new FuncElements.Special<class_268>(sup, AttributeFunctions.TEAM_NAME_TAG_VISIBILITY);
            case "death_msg_visibility", "death_msg" -> new FuncElements.Special<class_268>(sup, AttributeFunctions.TEAM_DEATH_MGS_VISIBILITY);
            case "collision" -> new FuncElements.Special<class_268>(sup, AttributeFunctions.TEAM_COLLISION);
            case "color" -> new FuncElements.Special<class_268>(sup, AttributeFunctions.TEAM_COLOR);
            case "members" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.TEAM_MEMBERS, TEAM_MEMBER, flags);
            case "online_players", "players" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.TEAM_PLAYERS, PLAYER, flags);
            default -> null;
        };
        SCOREBOARD_OBJECTIVE_SCORE = (pid, sup, name, flags, context) -> switch (name) {
            case "", "name", "holder" -> new FuncElements.Str<class_9011>(sup, AttributeFunctions.OBJECTIVE_SCORE_HOLDER_OWNER);
            case "display_name", "display" -> new FuncElements.Tex<class_9011>(sup, AttributeFunctions.OBJECTIVE_SCORE_HOLDER_DISPLAY);
            case "score", "value" -> new FuncElements.Num<class_9011>(sup, AttributeFunctions.OBJECTIVE_SCORE_VALUE, flags);
            default -> null;
        };
        SCOREBOARD_OBJECTIVE = (pid, sup, name, flags, context) -> switch (name) {
            case "", "name" -> new FuncElements.Tex<class_266>(sup, AttributeFunctions.OBJECTIVE_NAME);
            case "id" -> new FuncElements.Str<class_266>(sup, AttributeFunctions.OBJECTIVE_ID);
            case "criteria", "criterion" -> new FuncElements.Str<class_266>(sup, AttributeFunctions.OBJECTIVE_CRITIERIA);
            case "display_slot" -> new FuncElements.Str<class_266>(sup, AttributeFunctions.OBJECTIVE_DISPLAY_SLOT);
            case "scores" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.SCOREBOARD_OBJECTIVE_SCORES, SCOREBOARD_OBJECTIVE_SCORE, flags);
            case "online_scores" -> {
                context.enabled().serverWorld = true;
                yield new FunctionalElement.CreateListElement(sup, ListSuppliers.SCOREBOARD_OBJECTIVE_SCORES_ONLINE, SCOREBOARD_OBJECTIVE_SCORE, flags);
            }
            default -> null;
        };
        SCOREBOARD_SCORE = (pid, sup, name, flags, context) -> switch (name) {
            case "name" -> new FuncElements.Tex<Map.Entry<class_266, class_267>>(sup, AttributeFunctions.SCORES_OBJECTIVE_NAME);
            case "", "id" -> new FuncElements.Str<Map.Entry<class_266, class_267>>(sup, AttributeFunctions.SCORES_OBJECTIVE_ID);
            case "criteria", "criterion" -> new FuncElements.Str<Map.Entry<class_266, class_267>>(sup, AttributeFunctions.SCORES_OBJECTIVE_CRITIERIA);
            case "display_slot" -> new FuncElements.Str<Map.Entry<class_266, class_267>>(sup, AttributeFunctions.SCORES_OBJECTIVE_DISPLAY_SLOT);
            case "score", "value" -> new FuncElements.Num<Map.Entry<class_266, class_267>>(sup, AttributeFunctions.SCORES_VALUE, flags);
            default -> null;
        };
        BOSSBAR = (pid, sup, name, flags, context) -> switch (name) {
            case "name" -> new FuncElements.Tex<class_1259>(sup, AttributeFunctions.BOSSBAR_NAME);
            case "uuid" -> new FuncElements.Str<class_1259>(sup, AttributeFunctions.BOSSBAR_UUID);
            case "id" -> new FuncElements.Id<class_1259>(sup, AttributeFunctions.BOSSBAR_ID, flags);
            case "percent", "per", "value", "" -> new FuncElements.Num<class_1259>(sup, AttributeFunctions.BOSSBAR_PERCENT, flags);
            case "darken_sky" -> new FuncElements.Bool<class_1259>(sup, AttributeFunctions.BOSSBAR_DARKEN_SKY);
            case "dragon_music" -> new FuncElements.Bool<class_1259>(sup, AttributeFunctions.BOSSBAR_DRAGON_MUSIC);
            case "thickens_fog" -> new FuncElements.Bool<class_1259>(sup, AttributeFunctions.BOSSBAR_THICKENS_FOG);
            case "style" -> new FuncElements.Special<class_1259>(sup, AttributeFunctions.BOSSBAR_STYLE);
            case "color" -> new FuncElements.Special<class_1259>(sup, AttributeFunctions.BOSSBAR_COLOR);
            case "text_color" -> new FuncElements.Special<class_1259>(sup, AttributeFunctions.BOSSBAR_TEXT_COLOR);
            case "enabled", "visible" -> new FuncElements.Bool<class_1259>(sup, AttributeFunctions.BOSSBAR_IS_VISIBLE);
            case "players" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.BOSSBAR_PLAYERS, PLAYER, flags);
            case "icon", "bar" -> new BossbarIcon(pid, sup, flags);
            default -> null;
        };
        PROFILER_TIMING2 = PROFILER_TIMING = (pid, sup, name, flags, context) -> switch (name) {
            case "name" -> new FuncElements.Str<ComplexData.ProfilerTimingWithPath>(sup, AttributeFunctions.TIMING_NAME);
            case "path" -> new FuncElements.Str<ComplexData.ProfilerTimingWithPath>(sup, AttributeFunctions.TIMING_PATH);
            case "", "per_of_parent", "percent_of_parent" -> new FuncElements.Num<ComplexData.ProfilerTimingWithPath>(sup, AttributeFunctions.TIMING_PER_OF_PARENT, flags);
            case "per_of_total", "percent_of_total" -> new FuncElements.Num<ComplexData.ProfilerTimingWithPath>(sup, AttributeFunctions.TIMING_PER_OF_TOTAL, flags);
            case "color" -> new FuncElements.Num<ComplexData.ProfilerTimingWithPath>(sup, AttributeFunctions.TIMING_COLOR, flags);
            case "entries" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.TIMINGS_SUB_ENTRIES, PROFILER_TIMING2, flags);
            default -> null;
        };
        MOD_AUTHOR = (pid, sup, name, flags, context) -> name.isEmpty() || name.equals("name") ? new FuncElements.Str(sup, AttributeFunctions.DIRECT) : null;
        MOD_CONTRIBUTOR = (pid, sup, name, flags, context) -> name.isEmpty() || name.equals("name") ? new FuncElements.Str(sup, AttributeFunctions.DIRECT) : null;
        MOD_CREDIT = (pid, sup, name, flags, context) -> name.isEmpty() || name.equals("name") ? new FuncElements.Str(sup, AttributeFunctions.DIRECT) : null;
        MOD_LICENSE = (pid, sup, name, flags, context) -> name.isEmpty() || name.equals("name") ? new FuncElements.Str(sup, AttributeFunctions.DIRECT) : null;
        MOD_BADGE = (pid, sup, name, flags, context) -> switch (name) {
            case "", "name" -> new FuncElements.Str(sup, AttributeFunctions.BADGE_NAME);
            case "outline_color" -> new FuncElements.Num(sup, AttributeFunctions.BADGE_OUTLINE_COLOR, flags);
            case "fill_color" -> new FuncElements.Num(sup, AttributeFunctions.BADGE_FILL_COLOR, flags);
            case "icon" -> new ModBadgeIconElement(pid, flags);
            default -> null;
        };
        MOD2 = MOD = (pid, sup, name, flags, context) -> {
            if (name.startsWith("parent:")) {
                String attr = name.substring(9);
                Supplier<Object> sup2 = () -> Attributers.lambda$static$31((Supplier)sup);
                return MOD2.get(pid, sup2, attr, flags, context);
            }
            return switch (name) {
                case "", "name" -> new FuncElements.Str(sup, AttributeFunctions.MOD_NAME);
                case "id" -> new FuncElements.Str(sup, AttributeFunctions.MOD_ID);
                case "summary" -> new FuncElements.Str(sup, AttributeFunctions.MOD_SUMMARY);
                case "description", "desc" -> new FuncElements.Str(sup, AttributeFunctions.MOD_DESCRIPTION);
                case "version" -> new FuncElements.Str(sup, AttributeFunctions.MOD_VERSION);
                case "hash" -> new FuncElements.Str(sup, AttributeFunctions.MOD_HASH);
                case "library" -> new FuncElements.Bool(sup, AttributeFunctions.MOD_IS_LIBRARY);
                case "client" -> new FuncElements.Bool(sup, AttributeFunctions.MOD_IS_CLIENT);
                case "deprecated" -> new FuncElements.Bool(sup, AttributeFunctions.MOD_IS_DEPRECATED);
                case "patchwork" -> new FuncElements.Bool(sup, AttributeFunctions.MOD_IS_PATCHWORK);
                case "from_modpack" -> new FuncElements.Bool(sup, AttributeFunctions.MOD_IS_FROM_MODPACK);
                case "minecraft" -> new FuncElements.Bool(sup, AttributeFunctions.MOD_IS_MINECRAFT);
                case "badges" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.MOD_BADGES, MOD_BADGE, flags);
                case "authors" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.MOD_AUTHORS, MOD_AUTHOR, flags);
                case "contributors" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.MOD_CONTRIBUTORS, MOD_CONTRIBUTOR, flags);
                case "credits" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.MOD_CREDITS, MOD_CREDIT, flags);
                case "licenses" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.MOD_LICENSES, MOD_LICENSE, flags);
                case "parent" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.MOD_PARENTS, MOD2, flags);
                case "children" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.MOD_CHILDREN, MOD2, flags);
                case "icon" -> new ModIconElement(pid, flags);
                default -> null;
            };
        };
        PACK = (pid, sup, name, flags, context) -> switch (name) {
            case "", "name" -> new FuncElements.Tex<class_3288>(sup, AttributeFunctions.PACK_NAME);
            case "id" -> new FuncElements.Str<class_3288>(sup, AttributeFunctions.PACK_ID);
            case "description", "desc" -> new FuncElements.Tex<class_3288>(sup, AttributeFunctions.PACK_DESCRIPTION);
            case "version" -> new FuncElements.Num<class_3288>(sup, AttributeFunctions.PACK_VERSION, flags);
            case "always_enabled" -> new FuncElements.Bool<class_3288>(sup, AttributeFunctions.PACK_ALWAYS_ENABLED);
            case "pinned" -> new FuncElements.Bool<class_3288>(sup, AttributeFunctions.PACK_IS_PINNED);
            case "compatible" -> new FuncElements.Bool<class_3288>(sup, AttributeFunctions.PACK_IS_COMPATIBLE);
            case "icon" -> new PackIconElement(pid, flags);
            default -> null;
        };
        RECORD = (pid, sup, name, flags, context) -> switch (name) {
            case "", "name" -> new FuncElements.Tex<MusicAndRecordTracker.RecordInstance>(sup, AttributeFunctions.RECORD_NAME);
            case "id" -> new FuncElements.Id<MusicAndRecordTracker.RecordInstance>(sup, AttributeFunctions.RECORD_ID, flags);
            case "length" -> new FuncElements.Num<MusicAndRecordTracker.RecordInstance>(sup, AttributeFunctions.RECORD_LENGTH, flags);
            case "elapsed" -> new FuncElements.Num<MusicAndRecordTracker.RecordInstance>(sup, AttributeFunctions.RECORD_ELAPSED, flags);
            case "remaining" -> new FuncElements.Num<MusicAndRecordTracker.RecordInstance>(sup, AttributeFunctions.RECORD_REMAINING, flags);
            case "elapsed_percentage", "elapsed_per" -> new FuncElements.Num<MusicAndRecordTracker.RecordInstance>(sup, AttributeFunctions.RECORD_ELAPSED_PER, flags);
            case "icon" -> new ListRecordIconElement(flags);
            default -> null;
        };
        OFFER = (pid, sup, name, flags, context) -> {
            int collinIndex = name.indexOf(":");
            if (collinIndex > 0) {
                Supplier<Object> sup2;
                String attr = name.substring(collinIndex + 1);
                boolean isIcon = attr.equals("icon");
                switch (name.substring(0, collinIndex)) {
                    case "first": {
                        Supplier<Object> supplier;
                        if (isIcon) {
                            supplier = () -> Attributers.lambda$static$36((Supplier)sup);
                            break;
                        }
                        supplier = () -> Attributers.lambda$static$37((Supplier)sup);
                        break;
                    }
                    case "first_base": {
                        Supplier<Object> supplier;
                        if (isIcon) {
                            supplier = () -> Attributers.lambda$static$39((Supplier)sup);
                            break;
                        }
                        supplier = () -> Attributers.lambda$static$40((Supplier)sup);
                        break;
                    }
                    case "second": {
                        Supplier<Object> supplier;
                        if (isIcon) {
                            supplier = () -> Attributers.lambda$static$42((Supplier)sup);
                            break;
                        }
                        supplier = () -> Attributers.lambda$static$43((Supplier)sup);
                        break;
                    }
                    case "result": {
                        Supplier<Object> supplier;
                        if (isIcon) {
                            supplier = () -> Attributers.lambda$static$45((Supplier)sup);
                            break;
                        }
                        supplier = () -> Attributers.lambda$static$46((Supplier)sup);
                        break;
                    }
                    default: {
                        Supplier<Object> supplier = sup2 = null;
                    }
                }
                if (sup2 != null) {
                    return ITEM.get(pid, sup2, attr, flags, context);
                }
            }
            return switch (name) {
                case "uses" -> new FuncElements.Num<class_1914>(sup, AttributeFunctions.OFFER_USES, flags);
                case "max_uses" -> new FuncElements.Num<class_1914>(sup, AttributeFunctions.OFFER_MAX_USES, flags);
                case "special_price" -> new FuncElements.Num<class_1914>(sup, AttributeFunctions.OFFER_SPECIAL_PRICE, flags);
                case "demand_bonus" -> new FuncElements.Num<class_1914>(sup, AttributeFunctions.OFFER_DEMAND_BONUS, flags);
                case "price_multiplier" -> new FuncElements.Num<class_1914>(sup, AttributeFunctions.OFFER_PRICE_MULTIPLIER, flags);
                case "disabled" -> new FuncElements.Bool<class_1914>(sup, AttributeFunctions.OFFER_DISABLED);
                case "can_afford" -> new FuncElements.Bool<class_1914>(sup, AttributeFunctions.OFFER_CAN_AFFORD);
                case "first" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.OFFER_FIRST_ADJUSTED, ITEM, flags);
                case "first_base" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.OFFER_FIRST_BASE, ITEM, flags);
                case "second" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.OFFER_SECOND, ITEM, flags);
                case "", "result" -> new FunctionalElement.CreateListElement(sup, ListSuppliers.OFFER_RESULT, ITEM, flags);
                default -> null;
            };
        };
        ITEM_CONVERTABLE_TAG_ENTRY = (pid, sup, name, flags, context) -> switch (name) {
            case "name" -> new FuncElements.Tex<class_1935>(sup, AttributeFunctions.TAG_ENTRY_NAME);
            case "", "id" -> new FuncElements.Id<class_1935>(sup, AttributeFunctions.TAG_ENTRY_ID, flags);
            case "icon" -> new RichItemSupplierIconElement(pid, () -> Attributers.lambda$static$48((Supplier)sup), flags, false);
            default -> null;
        };
        CHAT_MESSAGE = (pid, sup, name, flags, context) -> switch (name) {
            case "type" -> new FuncElements.Str<class_303>(sup, AttributeFunctions.CHAT_MESSAGE_TYPE);
            case "text" -> new FuncElements.Tex<class_303>(sup, AttributeFunctions.CHAT_MESSAGE_TEXT);
            case "time_ago" -> new FuncElements.Num<class_303>(sup, AttributeFunctions.CHAT_MESSAGE_TIME_AGO, flags);
            default -> null;
        };
        ATTRIBUTER_MAP = new HashMap<ListProvider, Attributer>();
        DEFAULT_PREFIX = new HashMap<Attributer, String>();
        ATTRIBUTER_MAP.put(ListSuppliers.STATUS_EFFECTS, EFFECT);
        ATTRIBUTER_MAP.put(ListSuppliers.STATUS_EFFECTS_POSITIVE, EFFECT);
        ATTRIBUTER_MAP.put(ListSuppliers.STATUS_EFFECTS_POSITIVE, EFFECT);
        ATTRIBUTER_MAP.put(ListSuppliers.STATUS_EFFECTS_NEGATIVE, EFFECT);
        ATTRIBUTER_MAP.put(ListSuppliers.STATUS_EFFECTS_NEUTRAL, EFFECT);
        ATTRIBUTER_MAP.put(ListSuppliers.ONLINE_PLAYERS, PLAYER);
        ATTRIBUTER_MAP.put(ListSuppliers.SUBTITLES, SUBTITLE);
        ATTRIBUTER_MAP.put(ListSuppliers.TARGET_BLOCK_STATES, BLOCK_PROPERTY);
        ATTRIBUTER_MAP.put(ListSuppliers.TARGET_BLOCK_TAGS, TAG);
        ATTRIBUTER_MAP.put(ListSuppliers.TARGET_BLOCK_POWERS, RECEIVED_POWER);
        ATTRIBUTER_MAP.put(ListSuppliers.TARGET_FLUID_STATES, BLOCK_PROPERTY);
        ATTRIBUTER_MAP.put(ListSuppliers.TARGET_FLUID_TAGS, TAG);
        ATTRIBUTER_MAP.put(ListSuppliers.PLAYER_ATTRIBUTES, ATTRIBUTE);
        ATTRIBUTER_MAP.put(ListSuppliers.TARGET_ENTITY_ATTRIBUTES, ATTRIBUTE);
        ATTRIBUTER_MAP.put(ListSuppliers.HOOKED_ENTITY_ATTRIBUTES, ATTRIBUTE);
        ATTRIBUTER_MAP.put(ListSuppliers.TEAMS, TEAM);
        ATTRIBUTER_MAP.put(ListSuppliers.ALL_ITEMS, ITEM);
        ATTRIBUTER_MAP.put(ListSuppliers.INV_ITEMS, ITEM);
        ATTRIBUTER_MAP.put(ListSuppliers.ARMOR_ITEMS, ITEM);
        ATTRIBUTER_MAP.put(ListSuppliers.HOTBAR_ITEMS, ITEM);
        ATTRIBUTER_MAP.put(ListSuppliers.EQUIPPED_ITEMS, ITEM);
        ATTRIBUTER_MAP.put(ListSuppliers.ITEMS, ITEM);
        ATTRIBUTER_MAP.put(ListSuppliers.ITEMS_UNPACKED, ITEM);
        ATTRIBUTER_MAP.put(ListSuppliers.SCOREBOARD_OBJECTIVES, SCOREBOARD_OBJECTIVE);
        ATTRIBUTER_MAP.put(ListSuppliers.PLAYER_SCOREBOARD_SCORES, SCOREBOARD_SCORE);
        ATTRIBUTER_MAP.put(ListSuppliers.BOSSBARS, BOSSBAR);
        ATTRIBUTER_MAP.put(ListSuppliers.ALL_BOSSBARS, BOSSBAR);
        ATTRIBUTER_MAP.put(ListSuppliers.PROFILER_TIMINGS, PROFILER_TIMING);
        ATTRIBUTER_MAP.put(ListSuppliers.MODS, MOD);
        ATTRIBUTER_MAP.put(ListSuppliers.ALL_ROOT_MODS, MOD);
        ATTRIBUTER_MAP.put(ListSuppliers.ALL_MODS, MOD);
        ATTRIBUTER_MAP.put(ListSuppliers.RESOURCE_PACKS, PACK);
        ATTRIBUTER_MAP.put(ListSuppliers.DISABLED_RESOURCE_PACKS, PACK);
        ATTRIBUTER_MAP.put(ListSuppliers.DATA_PACKS, PACK);
        ATTRIBUTER_MAP.put(ListSuppliers.DISABLED_DATA_PACKS, PACK);
        ATTRIBUTER_MAP.put(ListSuppliers.RECORDS, RECORD);
        ATTRIBUTER_MAP.put(ListSuppliers.TARGET_VILLAGER_OFFERS, OFFER);
        ATTRIBUTER_MAP.put(ListSuppliers.CHAT_MESSAGES, CHAT_MESSAGE);
        DEFAULT_PREFIX.put(EFFECT, "e");
        DEFAULT_PREFIX.put(PLAYER, "p");
        DEFAULT_PREFIX.put(SUBTITLE, "s");
        DEFAULT_PREFIX.put(BLOCK_PROPERTY, "p");
        DEFAULT_PREFIX.put(RECEIVED_POWER, "r");
        DEFAULT_PREFIX.put(TAG, "t");
        DEFAULT_PREFIX.put(ENCHANTMENT, "e");
        DEFAULT_PREFIX.put(ITEM_LORE_LINE, "lore");
        DEFAULT_PREFIX.put(ITEM_INFO_INFO, "ii");
        DEFAULT_PREFIX.put(LOOP_ITEM, "loop");
        DEFAULT_PREFIX.put(ITEM_ATTRIBUTE_MODIFIER, "am");
        DEFAULT_PREFIX.put(ITEM_CAN_X, "c");
        DEFAULT_PREFIX.put(ITEM, "i");
        DEFAULT_PREFIX.put(ITEM2, "i");
        DEFAULT_PREFIX.put(ATTRIBUTE_MODIFIER, "am");
        DEFAULT_PREFIX.put(ATTRIBUTE, "a");
        DEFAULT_PREFIX.put(TEAM_MEMBER, "m");
        DEFAULT_PREFIX.put(TEAM, "t");
        DEFAULT_PREFIX.put(SCOREBOARD_OBJECTIVE_SCORE, "os");
        DEFAULT_PREFIX.put(SCOREBOARD_OBJECTIVE, "o");
        DEFAULT_PREFIX.put(SCOREBOARD_SCORE, "ss");
        DEFAULT_PREFIX.put(BOSSBAR, "b");
        DEFAULT_PREFIX.put(PROFILER_TIMING, "pt");
        DEFAULT_PREFIX.put(PROFILER_TIMING2, "pt");
        DEFAULT_PREFIX.put(MOD_AUTHOR, "ma");
        DEFAULT_PREFIX.put(MOD_CONTRIBUTOR, "mc");
        DEFAULT_PREFIX.put(MOD_CREDIT, "mc");
        DEFAULT_PREFIX.put(MOD_LICENSE, "ml");
        DEFAULT_PREFIX.put(MOD_BADGE, "mb");
        DEFAULT_PREFIX.put(MOD, "m");
        DEFAULT_PREFIX.put(MOD2, "m");
        DEFAULT_PREFIX.put(PACK, "p");
        DEFAULT_PREFIX.put(RECORD, "r");
        DEFAULT_PREFIX.put(OFFER, "o");
        DEFAULT_PREFIX.put(ITEM_CONVERTABLE_TAG_ENTRY, "t");
        DEFAULT_PREFIX.put(CHAT_MESSAGE, "cm");
    }

    @FunctionalInterface
    public static interface Attributer {
        public HudElement get(UUID var1, Supplier var2, String var3, Flags var4, ParseContext var5);
    }
}

