/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements.icon;

import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.minenash.customhud.CustomHud;
import com.minenash.customhud.HudElements.icon.IconElement;
import com.minenash.customhud.data.Flags;
import com.minenash.customhud.render.RenderPiece;
import java.io.InputStream;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1060;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_7367;

public class PackIconElement
extends IconElement {
    private final Map<String, class_2960> iconTextures = Maps.newHashMap();
    private static final class_2960 UNKNOWN_PACK = class_2960.method_60654((String)"textures/misc/unknown_pack.png");

    public PackIconElement(UUID providerID, Flags flags) {
        super(flags, 11.0);
        this.providerID = providerID;
    }

    @Override
    public void render(class_332 context, RenderPiece piece) {
        class_3288 pack = (class_3288)piece.value;
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)(piece.x + this.shiftX), (float)(piece.y + this.shiftY - 2), 0.0f);
        if (!this.referenceCorner) {
            matrices.method_46416(0.0f, -(11.0f * this.scale - 11.0f) / 2.0f, 0.0f);
        }
        int width = (int)(11.0f * this.scale);
        this.rotate(matrices, width, width);
        context.method_25290(class_1921::method_62275, this.getPackIconTexture(pack), 0, 0, 0.0f, 0.0f, width, width, width, width);
        matrices.method_22909();
    }

    private class_2960 getPackIconTexture(class_3288 resourcePackProfile) {
        return this.iconTextures.computeIfAbsent(resourcePackProfile.method_14463(), profileName -> PackIconElement.loadPackIcon(CustomHud.CLIENT.method_1531(), resourcePackProfile));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static class_2960 loadPackIcon(class_1060 textureManager, class_3288 resourcePackProfile) {
        try (class_3262 resourcePack = resourcePackProfile.method_14458();){
            class_2960 class_29602;
            block16: {
                class_7367 inputSupplier = resourcePack.method_14410(new String[]{"pack.png"});
                if (inputSupplier == null) {
                    class_2960 class_29603 = UNKNOWN_PACK;
                    return class_29603;
                }
                String name = resourcePackProfile.method_14463();
                String safeName = class_156.method_30309((String)name, class_2960::method_29184);
                class_2960 identifier = class_2960.method_60655((String)"minecraft", (String)("pack/" + safeName + "/" + String.valueOf(Hashing.sha1().hashUnencodedChars((CharSequence)name)) + "/icon"));
                InputStream inputStream = (InputStream)inputSupplier.get();
                try {
                    class_1011 nativeImage = class_1011.method_4309((InputStream)inputStream);
                    textureManager.method_4616(identifier, (class_1044)new class_1043(() -> ((class_2960)identifier).toString(), nativeImage));
                    class_29602 = identifier;
                    if (inputStream == null) break block16;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return class_29602;
        }
        catch (Exception var14) {
            CustomHud.LOGGER.warn("[CustomHud] Failed to load icon from pack {}", (Object)resourcePackProfile.method_14463(), (Object)var14);
            return UNKNOWN_PACK;
        }
    }
}

