/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements.list;

import com.minenash.customhud.CustomHud;
import com.minenash.customhud.complex.ComplexData;
import com.minenash.customhud.mixin.accessors.AttributeContainerAccessor;
import com.minenash.customhud.mixin.accessors.BlockPredicatesCheckerAccessor;
import com.minenash.customhud.mixin.accessors.DefaultAttributeContainerAccessor;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_2240;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_3002;
import net.minecraft.class_3288;
import net.minecraft.class_3532;
import net.minecraft.class_4550;
import net.minecraft.class_640;
import net.minecraft.class_6538;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import net.minecraft.class_9276;
import net.minecraft.class_9285;
import net.minecraft.class_9288;
import net.minecraft.class_9290;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class AttributeHelpers {
    public static final Function<String, class_1320> ENTITY_ATTR_READER = src -> (class_1320)class_7923.field_41190.method_63535(class_2960.method_12829((String)src));
    public static final Function<String, class_3288> DATA_PACK_READER = src -> CustomHud.CLIENT.method_1576() == null ? null : CustomHud.CLIENT.method_1576().method_3836().method_14449(src);
    private static final Pattern TIMING_PERIOD_TO_SPECIAL = Pattern.compile("(?<!\\\\)\\.");
    public static final Function<String, String> PROFILER_TIMING_READER = src -> {
        if (!((String)(src = TIMING_PERIOD_TO_SPECIAL.matcher((CharSequence)src).replaceAll("\u001e"))).startsWith("root\u001e")) {
            src = "root\u001e" + (String)src;
        }
        return src;
    };
    public static final Function<String, Integer> SLOT_READER = src -> {
        if (src.isBlank()) {
            return null;
        }
        try {
            class_2240 class_22402 = class_2240.method_9473();
            return class_22402.method_9470(new StringReader((String)(switch (src) {
                case "head", "chest", "legs", "feet" -> "armor." + src;
                case "mainhand", "offhand" -> "weapon." + src;
                case "main", "off" -> "weapon." + src + "hand";
                default -> src.length() < 2 ? src : (src.charAt(0) == 'h' && src.charAt(1) != 'o' ? "hotbar." + src.substring(1) : (src.charAt(0) == 'i' && src.charAt(1) != 'n' ? "inventory." + src.substring(1) : src));
            })));
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    };

    public static class_640 getPlayer(String src) {
        class_640 p = CustomHud.CLIENT.method_1562().method_2874(src);
        if (p != null) {
            return p;
        }
        try {
            return CustomHud.CLIENT.method_1562().method_2871(UUID.fromString(src));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static class_1297 getFullEntity(class_1297 entity) {
        return CustomHud.CLIENT.method_1576() == null || entity == null ? entity : CustomHud.CLIENT.method_1576().method_3847(entity.method_37908().method_27983()).method_66347(entity.method_5667());
    }

    public static class_1324 getEntityAttr(class_1297 entity, class_1320 attribute) {
        class_1297 e = AttributeHelpers.getFullEntity(entity);
        if (!(e instanceof class_1309)) {
            return null;
        }
        class_1309 le = (class_1309)e;
        return le.method_5996(class_7923.field_41190.method_47983((Object)attribute));
    }

    public static List<?> getEntityAttributes(class_1297 entity) {
        if (!((entity = AttributeHelpers.getFullEntity(entity)) instanceof class_1309)) {
            return Collections.EMPTY_LIST;
        }
        class_1309 le = (class_1309)entity;
        AttributeContainerAccessor container = (AttributeContainerAccessor)le.method_6127();
        HashMap<class_1320, class_1324> instances = new HashMap<class_1320, class_1324>(((DefaultAttributeContainerAccessor)container.getFallback()).getInstances());
        instances.putAll(container.getCustom());
        return Arrays.asList((entity.method_37908().field_9236 ? instances.values().stream().filter(a -> ((class_1320)a.method_6198().comp_349()).method_6168()) : instances.values().stream()).sorted(Comparator.comparing(a -> class_1074.method_4662((String)((class_1320)a.method_6198().comp_349()).method_26830(), (Object[])new Object[0]))).toArray());
    }

    public static List<ItemAttribute> getItemStackAttributes(class_1799 stack) {
        ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
        class_9285 component = (class_9285)stack.method_58694(class_9334.field_49636);
        if (component != null) {
            for (class_9285.class_9287 entry : component.comp_2393()) {
                attributes.add(new ItemAttribute((class_1320)entry.comp_2395().comp_349(), entry.comp_2396(), entry.comp_2397().method_15434()));
            }
        }
        return attributes;
    }

    public static List<class_2561> getLore(class_1799 stack) {
        class_9290 component = (class_9290)stack.method_58694(class_9334.field_49632);
        return component != null ? component.comp_2400() : new ArrayList();
    }

    public static List<class_2248> getCanX(class_1799 stack, class_9331<class_6538> type) {
        class_6538 component = (class_6538)stack.method_58694(type);
        HashSet<class_2248> blocks = new HashSet<class_2248>();
        if (component != null) {
            for (class_4550 e : ((BlockPredicatesCheckerAccessor)component).getPredicates()) {
                if (!e.comp_1732().isPresent()) continue;
                for (class_6880 ee : (class_6885)e.comp_1732().get()) {
                    blocks.add((class_2248)ee.comp_349());
                }
            }
        }
        return new ArrayList<class_2248>(blocks);
    }

    public static List<class_1799> compactItems(List<class_1799> stacks) {
        ArrayList<class_1799> compact = new ArrayList<class_1799>();
        block0: for (class_1799 stack : stacks) {
            if (stack.method_7960()) continue;
            for (class_1799 cStack : compact) {
                if (!class_1799.method_31577((class_1799)stack, (class_1799)cStack)) continue;
                cStack.method_7939(cStack.method_7947() + stack.method_7947());
                continue block0;
            }
            compact.add(stack.method_7972());
        }
        return compact;
    }

    public static List<class_1799> getItemItems(class_1799 stack, boolean returnStack) {
        if (stack.method_7960()) {
            return returnStack ? Collections.singletonList(stack) : Collections.EMPTY_LIST;
        }
        Iterator iter = null;
        class_9276 bundle = (class_9276)stack.method_58694(class_9334.field_49650);
        if (bundle != null) {
            iter = bundle.method_57421().iterator();
        } else {
            class_9288 container = (class_9288)stack.method_58694(class_9334.field_49622);
            if (container != null) {
                iter = container.method_59714().iterator();
            }
        }
        if (iter == null || !iter.hasNext()) {
            return returnStack ? Collections.singletonList(stack) : Collections.EMPTY_LIST;
        }
        int count = stack.method_7947();
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        while (iter.hasNext()) {
            class_1799 item = (class_1799)iter.next();
            items.add(item.method_46651(item.method_7947() * count));
        }
        return items;
    }

    public static class_269 scoreboard() {
        return CustomHud.CLIENT.method_1576() != null ? CustomHud.CLIENT.method_1576().method_3845() : CustomHud.CLIENT.field_1687.method_8428();
    }

    public static boolean entryOnline(String entry) {
        if (null != (CustomHud.CLIENT.method_1576() != null ? CustomHud.CLIENT.method_1576().method_3760().method_14566(entry) : CustomHud.CLIENT.method_1562().method_2874(entry))) {
            return true;
        }
        if (ComplexData.serverWorld == null) {
            return false;
        }
        try {
            return ComplexData.serverWorld.field_26935.method_31827(UUID.fromString(entry));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static List<?> bossbars(boolean all) {
        if (CustomHud.CLIENT.method_1576() == null) {
            return Arrays.asList(CustomHud.CLIENT.field_1705.method_1740().field_2060.entrySet().toArray());
        }
        ArrayList<Object> serverBossbars = new ArrayList<Object>();
        serverBossbars.addAll(CustomHud.CLIENT.method_1576().method_3837().field_13447.values());
        serverBossbars.addAll(ComplexData.bossbars.values());
        if (all) {
            return serverBossbars;
        }
        Set client = CustomHud.CLIENT.field_1705.method_1740().field_2060.keySet();
        return Arrays.asList(serverBossbars.stream().filter(bar -> client.contains(bar.method_5407())).toArray());
    }

    public static class_1259 getBossBar(String input) {
        boolean client = CustomHud.CLIENT.method_1576() == null;
        try {
            UUID uuid = UUID.fromString(input);
            if (client) {
                return (class_1259)CustomHud.CLIENT.field_1705.method_1740().field_2060.get(uuid);
            }
            for (class_1259 bar : CustomHud.CLIENT.method_1576().method_3837().field_13447.values()) {
                if (bar.method_5407() != uuid) continue;
                return bar;
            }
            class_1259 bb = ComplexData.bossbars.get(uuid);
            if (bb != null) {
                return bb;
            }
        }
        catch (Exception uuid) {
            // empty catch block
        }
        if (client) {
            for (class_1259 bar : CustomHud.CLIENT.field_1705.method_1740().field_2060.values()) {
                if (!bar.method_5414().getString().equalsIgnoreCase(input)) continue;
                return bar;
            }
        } else {
            class_3002 bar = CustomHud.CLIENT.method_1576().method_3837().method_12971(class_2960.method_12829((String)input));
            if (bar != null) {
                return bar;
            }
            for (class_1259 bar2 : CustomHud.CLIENT.method_1576().method_3837().field_13447.values()) {
                if (!bar2.method_5414().getString().equalsIgnoreCase(input)) continue;
                return bar2;
            }
            for (class_1259 bar2 : ComplexData.bossbars.values()) {
                if (!bar2.method_5414().getString().equalsIgnoreCase(input)) continue;
                return bar2;
            }
        }
        return null;
    }

    public static int getBossBarColor(class_1259 bar) {
        return switch (bar.method_5420()) {
            default -> throw new IncompatibleClassChangeError();
            case class_1259.class_1260.field_5788 -> 15466680;
            case class_1259.class_1260.field_5780 -> 47084;
            case class_1259.class_1260.field_5784 -> 15480064;
            case class_1259.class_1260.field_5785 -> 1960960;
            case class_1259.class_1260.field_5782 -> 15330304;
            case class_1259.class_1260.field_5783 -> 8061164;
            case class_1259.class_1260.field_5786 -> 0xECECEC;
        };
    }

    public static double getRelativeYaw(class_243 player, class_243 other) {
        return class_3532.method_15338((double)((double)CustomHud.CLIENT.field_1724.method_36454() - Math.toDegrees(class_3532.method_15349((double)(-(other.method_10216() - player.method_10216())), (double)(other.method_10215() - player.method_10215())))));
    }

    public static double getRelativePitch(class_243 player, class_243 other) {
        double xDist = other.method_10216() - player.method_10216();
        double zDist = other.method_10215() - player.method_10215();
        return class_3532.method_15338((double)((double)CustomHud.CLIENT.field_1724.method_36455() + Math.toDegrees(class_3532.method_15349((double)(other.method_10214() - player.method_10214()), (double)Math.sqrt(xDist * xDist + zDist * zDist)))));
    }

    public static boolean isFabricRP(class_3288 pack) {
        class_2588 ttc;
        class_7417 content = pack.method_56933().comp_2330().method_10851();
        return pack.method_14463().equals("fabric") || content instanceof class_2588 && ((ttc = (class_2588)content).method_11022().equals("pack.name.fabricMod") || ttc.method_11022().equals("pack.name.fabricMods"));
    }

    public record ItemAttribute(class_1320 attribute, class_1322 modifier, String slot) {
    }

    public record ReceivedPower(class_2350 direction, int power, int strongPower) {
    }
}

