/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements.supplier;

import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.HudElements.interfaces.NumElement;
import com.minenash.customhud.data.Flags;
import com.minenash.customhud.data.NumberFlags;
import java.util.function.Supplier;
import net.minecraft.class_3446;

public class NumberSupplierElement
implements HudElement,
NumElement {
    private final Supplier<Number> supplier;
    private final NumberFlags flags;

    public static Entry of(Supplier<Number> supplier, int precision) {
        return new Entry(supplier, precision, null);
    }

    public static Entry of(Supplier<Number> supplier, int precision, class_3446 formatter) {
        return new Entry(supplier, precision, formatter);
    }

    public NumberSupplierElement(Entry entry, Flags flags) {
        this.supplier = entry.supplier;
        this.flags = NumberFlags.of(flags, entry.precision, entry.formatter);
    }

    public NumberSupplierElement(Supplier<Number> supplier, Flags flags) {
        this.supplier = supplier;
        this.flags = NumberFlags.of(flags);
    }

    @Override
    public int getPrecision() {
        return this.flags.precision();
    }

    @Override
    public String getString() {
        try {
            return this.flags.formatString(this.supplier.get().doubleValue());
        }
        catch (Exception _e) {
            return "-";
        }
    }

    @Override
    public Number getNumber() {
        return this.sanitize(this.supplier, Double.NaN);
    }

    @Override
    public boolean getBoolean() {
        return ((Number)this.sanitize(this.supplier, Double.NaN)).doubleValue() > 0.0;
    }

    public record Entry(Supplier<Number> supplier, int precision, class_3446 formatter) {
    }
}

