/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.minenash.customhud.ConfigManager;
import com.minenash.customhud.CustomHud;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;

public class UpdateChecker {
    private static final String mcVersion = class_310.method_1551().method_1515();
    private static final String currentVersion;
    public static String[] latestKnownVersion;
    public static class_2561 updateMessage;

    public static void check() {
        JsonObject updateInfo;
        if (currentVersion.contains("beta") || currentVersion.contains("alpha")) {
            return;
        }
        String[] modVersion = currentVersion.split("\\.");
        if (latestKnownVersion == null) {
            latestKnownVersion = modVersion;
        }
        if ((updateInfo = UpdateChecker.getUpdateData()) == null) {
            return;
        }
        CustomHud.logInDebugMode("VERSION: " + mcVersion);
        JsonObject info = updateInfo.getAsJsonObject(mcVersion);
        if (info == null) {
            return;
        }
        String versionRaw = info.get("version").getAsString();
        Object[] version = versionRaw.split("\\.");
        if (version.length != latestKnownVersion.length || Arrays.equals(latestKnownVersion, version)) {
            return;
        }
        if (!UpdateChecker.compareVersions(latestKnownVersion, (String[])version)) {
            return;
        }
        latestKnownVersion = version;
        updateMessage = class_2561.method_43470((String)("\u00a7eCustomHUD v" + versionRaw + " is available! ")).method_10852((class_2561)class_2561.method_43470((String)"[Modrinth]").method_10862(class_2583.field_24360.method_27705(new class_124[]{class_124.field_1060, class_124.field_1073}).method_10958((class_2558)new class_2558.class_10608(URI.create(info.get("link").getAsString()))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Download on Modrinth"))))).method_27693("\nWhat's New:\n \u00a77" + info.get("msg").getAsString());
        ConfigManager.save();
    }

    public static boolean compareVersions(String[] known, String[] latest) {
        for (int i = 0; i < 3; ++i) {
            if (Integer.parseInt(latest[i]) <= Integer.parseInt(known[i])) continue;
            return true;
        }
        return false;
    }

    public static JsonObject getUpdateData() {
        try {
            URL url = new URL("https://customhud.dev/updateInfo.json");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                throw new RuntimeException("HttpResponseCode: " + responseCode);
            }
            return JsonParser.parseString((String)new String(conn.getInputStream().readAllBytes())).getAsJsonObject();
        }
        catch (Exception e) {
            CustomHud.LOGGER.error("[CustomHUD] Could not get update info");
            CustomHud.LOGGER.catching((Throwable)e);
            return null;
        }
    }

    public static String getLatestKnownVersionAsString() {
        if (latestKnownVersion == null) {
            return currentVersion;
        }
        StringBuilder version = new StringBuilder();
        for (String part : latestKnownVersion) {
            version.append(part).append(".");
        }
        return version.substring(0, version.length() - 1);
    }

    static {
        String modVersionRaw = ((ModContainer)FabricLoader.getInstance().getModContainer("custom_hud").get()).getMetadata().getVersion().getFriendlyString();
        currentVersion = modVersionRaw.substring(0, modVersionRaw.indexOf("+"));
        latestKnownVersion = null;
        updateMessage = null;
    }
}

