/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.data;

import com.minenash.customhud.CustomHud;
import com.minenash.customhud.data.CHFormatting;
import com.minenash.customhud.errors.ErrorType;
import com.minenash.customhud.errors.Errors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2960;

public class HudTheme {
    public int bgColor = 0x44000000;
    public CHFormatting fgColor = new CHFormatting().color(-1, -1);
    public int lineSpacing = 2;
    public class_2960 font = null;
    public boolean textShadow = true;
    public boolean persistentFormatting = false;
    private float scale = 1.0f;
    private ScaleMethod scaleMethod = ScaleMethod.DIRECT;
    public Integer hudScale = null;
    public boolean hudScaleRelative = false;
    public Padding padding = new Padding(2, 1, 2, 2);
    private boolean lineSpaced = false;
    private boolean padded = false;
    public boolean convertLineBreaks = true;
    public boolean ignoreBlankLines = false;
    public boolean ignoreLeadingSpace = false;
    public boolean fitItemIconsToLine = true;
    private static final Pattern SPACING_FLAG_PATTERN = Pattern.compile("linespacing: ?([-+]?\\d+)");
    private static final Pattern SCALE_FLAG_PATTERN = Pattern.compile("scale: ?(\\d+.?\\d*|.?\\d+)");
    private static final Pattern NICESCALE_FLAG_PATTERN = Pattern.compile("nicescale: ?(\\+)? ?(-?\\d+)");
    private static final Pattern HUDSCALE_FLAG_PATTERN = Pattern.compile("hudscale: ?(\\+)? ?(-?\\d+)");
    private static final Pattern COLOR_FLAG_PATTERN = Pattern.compile("(back|fore)groundcolou?r: ?(0x|#)?([0-9a-fA-F]+|none)");
    private static final Pattern COLOR_FLAG_PATTERN_STR = Pattern.compile("(back|fore)groundcolou?r: ?(.*)");
    private static final Pattern PERSISTEMT_FORMATTING_FLAG_PATTERN = Pattern.compile("persistentformatting: ?(true|false)");
    private static final Pattern FONT_FLAG_PATTERN = Pattern.compile("font: ?(\\w*:?\\w+)");
    private static final Pattern TEXT_SHADOW_FLAG_PATTERN = Pattern.compile("textshadow: ?(true|false)");
    private static final Pattern ROTATION_FLAG_PATTERN = Pattern.compile("rotate: ?(-?\\d+), ?(-?\\d+), ?(-?\\d+)");
    private static final Pattern TRANSLATE_FLAG_PATTERN = Pattern.compile("translate: ?(-?\\d+), ?(-?\\d+), ?(-?\\d+)");
    private static final Pattern PADDING_FLAG_PATTERN = Pattern.compile("padding: ?(-?\\d+)?(, ?(-?\\d+)?)?(, ?(-?\\d+)?)?(, ?(-?\\d+)?)?");
    private static final Pattern ITEM_ICON_SIZE = Pattern.compile("itemiconsize?: ?(line|full)");
    private static final Pattern CONVERT_LINE_BREAKS_PATTERN = Pattern.compile("convertlinebreaks?: ?(true|false)");
    private static final Pattern IGNORE_BLANK_LINES_PATTERN = Pattern.compile("ignoreblanklines?: ?(true|false)");
    private static final Pattern IGNORE_LEADING_SPACES = Pattern.compile("ignoreleadingspaces?: ?(true|false)");

    private HudTheme() {
    }

    public static HudTheme defaults() {
        return new HudTheme();
    }

    public HudTheme copy() {
        HudTheme newTheme = new HudTheme();
        newTheme.bgColor = this.bgColor;
        newTheme.fgColor = this.fgColor;
        newTheme.lineSpacing = this.lineSpacing;
        newTheme.font = this.font;
        newTheme.textShadow = this.textShadow;
        newTheme.scale = this.scale;
        newTheme.scaleMethod = this.scaleMethod;
        newTheme.hudScale = this.hudScale;
        newTheme.hudScaleRelative = this.hudScaleRelative;
        newTheme.padding = this.padding;
        newTheme.lineSpaced = this.lineSpaced;
        newTheme.padded = this.padded;
        newTheme.convertLineBreaks = this.convertLineBreaks;
        newTheme.ignoreBlankLines = this.ignoreBlankLines;
        newTheme.ignoreLeadingSpace = this.ignoreLeadingSpace;
        newTheme.persistentFormatting = this.persistentFormatting;
        newTheme.fitItemIconsToLine = this.fitItemIconsToLine;
        return newTheme;
    }

    public boolean parse(boolean global, String line, String profileName, int lineNum) {
        Matcher matcher = COLOR_FLAG_PATTERN.matcher(line = line.toLowerCase());
        if (matcher.matches() && matcher.group(1).length() <= 8) {
            if (matcher.group(1).equals("fore")) {
                this.fgColor.apply(HudTheme.parseHexNumber(matcher.group(3)), this);
            } else {
                this.bgColor = new CHFormatting().color(this.bgColor, -1).apply(HudTheme.parseHexNumber(matcher.group(3)), this).getColor();
            }
        } else {
            matcher = COLOR_FLAG_PATTERN_STR.matcher(line);
            if (matcher.matches()) {
                Integer color = HudTheme.parseColorName(matcher.group(2).trim());
                if (color == null) {
                    Errors.addError(profileName, lineNum, line, ErrorType.UNKNOWN_THEME_FLAG, matcher.group(2));
                    return true;
                }
                if (matcher.group(1).equals("fore")) {
                    this.fgColor.apply(color, 0xFFFFFF);
                } else {
                    this.bgColor = 0x44000000 + color;
                }
            } else {
                matcher = SPACING_FLAG_PATTERN.matcher(line);
                if (matcher.matches()) {
                    if (this.padded) {
                        Errors.addError(profileName, lineNum, line, ErrorType.LINE_SPACING_AND_PADDING, "");
                        return true;
                    }
                    this.lineSpacing = Integer.parseInt(matcher.group(1));
                    this.lineSpaced = true;
                } else if (global && (matcher = SCALE_FLAG_PATTERN.matcher(line)).matches()) {
                    float scale = Float.parseFloat(matcher.group(1));
                    if (scale == 0.0f) {
                        Errors.addError(profileName, lineNum, line, ErrorType.ZERO_SCALE, "");
                        return true;
                    }
                    this.scale = scale;
                    this.scaleMethod = ScaleMethod.DIRECT;
                } else if (global && (matcher = NICESCALE_FLAG_PATTERN.matcher(line)).matches()) {
                    float scale = Integer.parseInt(matcher.group(2));
                    if (matcher.group(1) != null || scale < 0.0f) {
                        this.scaleMethod = ScaleMethod.RELATIVE_GUI;
                        this.scale = scale;
                    } else {
                        if (scale == 0.0f) {
                            Errors.addError(profileName, lineNum, line, ErrorType.ZERO_SCALE, "");
                            return true;
                        }
                        this.scaleMethod = ScaleMethod.GUI;
                        this.scale = scale;
                    }
                } else if (global && (matcher = HUDSCALE_FLAG_PATTERN.matcher(line)).matches()) {
                    this.hudScale = Integer.parseInt(matcher.group(2));
                    this.hudScaleRelative = matcher.group(1) != null || this.scale < 0.0f;
                } else {
                    matcher = FONT_FLAG_PATTERN.matcher(line);
                    if (matcher.matches()) {
                        this.font = class_2960.method_60654((String)matcher.group(1));
                    } else {
                        matcher = TEXT_SHADOW_FLAG_PATTERN.matcher(line);
                        if (matcher.matches()) {
                            this.textShadow = Boolean.parseBoolean(matcher.group(1));
                        } else {
                            matcher = PADDING_FLAG_PATTERN.matcher(line);
                            if (matcher.matches()) {
                                if (this.lineSpaced) {
                                    Errors.addError(profileName, lineNum, line, ErrorType.LINE_SPACING_AND_PADDING, "");
                                    return true;
                                }
                                this.padded = true;
                                if (!HudTheme.empty(matcher, 4)) {
                                    this.padding = new Padding(HudTheme.empty(matcher, 1) ? this.padding.top : Integer.parseInt(matcher.group(1)), HudTheme.empty(matcher, 3) ? this.padding.bottom : Integer.parseInt(matcher.group(3)), HudTheme.empty(matcher, 5) ? this.padding.left : Integer.parseInt(matcher.group(5)), HudTheme.empty(matcher, 7) ? this.padding.right : Integer.parseInt(matcher.group(7)));
                                } else if (!HudTheme.empty(matcher, 2)) {
                                    this.padding = new Padding(HudTheme.empty(matcher, 1) ? this.padding.top : Integer.parseInt(matcher.group(1)), HudTheme.empty(matcher, 1) ? this.padding.bottom : Integer.parseInt(matcher.group(1)), HudTheme.empty(matcher, 3) ? this.padding.left : Integer.parseInt(matcher.group(3)), HudTheme.empty(matcher, 3) ? this.padding.right : Integer.parseInt(matcher.group(3)));
                                } else if (!HudTheme.empty(matcher, 1)) {
                                    int p = Integer.parseInt(matcher.group(1));
                                    this.padding = new Padding(p, p, p, p);
                                }
                            } else {
                                matcher = CONVERT_LINE_BREAKS_PATTERN.matcher(line);
                                if (matcher.matches()) {
                                    this.convertLineBreaks = Boolean.parseBoolean(matcher.group(1));
                                } else {
                                    matcher = IGNORE_BLANK_LINES_PATTERN.matcher(line);
                                    if (matcher.matches()) {
                                        this.ignoreBlankLines = Boolean.parseBoolean(matcher.group(1));
                                    } else {
                                        matcher = IGNORE_LEADING_SPACES.matcher(line);
                                        if (matcher.matches()) {
                                            this.ignoreLeadingSpace = Boolean.parseBoolean(matcher.group(1));
                                        } else {
                                            matcher = PERSISTEMT_FORMATTING_FLAG_PATTERN.matcher(line);
                                            if (matcher.matches()) {
                                                this.persistentFormatting = Boolean.parseBoolean(matcher.group(1));
                                            } else {
                                                matcher = ITEM_ICON_SIZE.matcher(line);
                                                if (matcher.matches()) {
                                                    this.fitItemIconsToLine = matcher.group(1).equals("line");
                                                } else {
                                                    return false;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }

    private static boolean empty(Matcher matcher, int group) {
        return matcher.group(group) == null || matcher.group(group).isEmpty();
    }

    public float getScale() {
        if (this.scaleMethod == ScaleMethod.DIRECT) {
            return this.scale;
        }
        float gui = CustomHud.CLIENT.method_22683().method_4495();
        float target = this.scaleMethod == ScaleMethod.GUI ? this.scale : gui + this.scale;
        return target / gui;
    }

    public int getTargetGuiScale() {
        if (this.hudScale == null) {
            return CustomHud.CLIENT.method_22683().method_4495();
        }
        int gS = this.hudScaleRelative ? (Integer)CustomHud.CLIENT.field_1690.method_42474().method_41753() + this.hudScale : this.hudScale;
        return CustomHud.CLIENT.method_1573() && gS % 2 != 0 ? gS + 1 : gS;
    }

    public static CHFormatting parseHexNumber(String str) {
        if (((String)str).equals("none")) {
            return new CHFormatting().color(0, -16777216);
        }
        int length = ((String)str).length();
        str = switch (length) {
            case 1 -> "" + ((String)str).charAt(0) + ((String)str).charAt(0) + "000000";
            case 2 -> "" + ((String)str).charAt(0) + ((String)str).charAt(1) + "000000";
            case 3 -> "00" + ((String)str).charAt(0) + ((String)str).charAt(0) + ((String)str).charAt(1) + ((String)str).charAt(1) + ((String)str).charAt(2) + ((String)str).charAt(2);
            case 4 -> "" + ((String)str).charAt(0) + ((String)str).charAt(0) + ((String)str).charAt(1) + ((String)str).charAt(1) + ((String)str).charAt(2) + ((String)str).charAt(2) + ((String)str).charAt(3) + ((String)str).charAt(3);
            case 5 -> "" + ((String)str).charAt(0) + ((String)str).charAt(1) + ((String)str).charAt(2) + ((String)str).charAt(2) + ((String)str).charAt(3) + ((String)str).charAt(3) + ((String)str).charAt(4) + ((String)str).charAt(4);
            case 6 -> "00" + (String)str;
            case 7 -> "" + ((String)str).charAt(0) + ((String)str).charAt(0) + ((String)str).substring(1);
            default -> str;
        };
        long colorL = Long.parseLong((String)str, 16);
        int color = (int)(colorL >= 0x100000000L ? colorL - 0x100000000L : colorL);
        int bitmask = switch (length) {
            case 1, 2 -> -16777216;
            case 3, 6 -> 0xFFFFFF;
            default -> -1;
        };
        return new CHFormatting().color(color, bitmask);
    }

    public static Integer parseColorName(String str) {
        return switch (str) {
            case "black" -> 0;
            case "dark_blue" -> 170;
            case "dark_green" -> 43520;
            case "dark_aqua" -> 43690;
            case "dark_red" -> 0xAA0000;
            case "dark_purple" -> 0xAA00AA;
            case "gold", "orange" -> 0xFFAA00;
            case "gray" -> 0xAAAAAA;
            case "dark_gray" -> 0x555555;
            case "blue" -> 0x5555FF;
            case "green" -> 0x55FF55;
            case "aqua" -> 0x55FFFF;
            case "red" -> 0xFF5555;
            case "light_purple", "purple" -> 0xFF55FF;
            case "yellow" -> 0xFFFF55;
            case "white" -> 0xFFFFFF;
            case "minecoin_gold", "minecoin" -> 14538245;
            case "material_quartz", "quartz" -> 14931153;
            case "material_iron", "iron" -> 0xCECACA;
            case "material_netherite", "netherite" -> 4471355;
            case "material_redstone", "redstone" -> 9901575;
            case "material_copper", "copper" -> 11823181;
            case "material_gold", "mgold" -> 14594349;
            case "material_emerald", "emerald" -> 4694070;
            case "material_diamond", "diamond" -> 2931368;
            case "material_lapis", "lapis" -> 2181499;
            case "material_amethyst", "amethyst" -> 10116294;
            default -> null;
        };
    }

    public static CHFormatting parseFormattingName(String str) {
        byte formatting;
        switch (str) {
            case "bold": {
                byte by = 16;
                break;
            }
            case "italic": {
                byte by = 8;
                break;
            }
            case "underline": {
                byte by = 4;
                break;
            }
            case "strikethrough": 
            case "strike": {
                byte by = 2;
                break;
            }
            case "obfuscated": {
                byte by = 1;
                break;
            }
            case "reset": {
                byte by = 64;
                break;
            }
            default: {
                byte by = formatting = 31;
            }
        }
        if (formatting == 31) {
            return null;
        }
        return new CHFormatting().format(formatting);
    }

    public static CHFormatting parseColorCode(String str) {
        Integer color;
        switch (str) {
            case "\u00a70": {
                Integer n = 0;
                break;
            }
            case "\u00a71": {
                Integer n = 170;
                break;
            }
            case "\u00a72": {
                Integer n = 43520;
                break;
            }
            case "\u00a73": {
                Integer n = 43690;
                break;
            }
            case "\u00a74": {
                Integer n = 0xAA0000;
                break;
            }
            case "\u00a75": {
                Integer n = 0xAA00AA;
                break;
            }
            case "\u00a76": {
                Integer n = 0xFFAA00;
                break;
            }
            case "\u00a77": {
                Integer n = 0xAAAAAA;
                break;
            }
            case "\u00a78": {
                Integer n = 0x555555;
                break;
            }
            case "\u00a79": {
                Integer n = 0x5555FF;
                break;
            }
            case "\u00a7a": {
                Integer n = 0x55FF55;
                break;
            }
            case "\u00a7b": {
                Integer n = 0x55FFFF;
                break;
            }
            case "\u00a7c": {
                Integer n = 0xFF5555;
                break;
            }
            case "\u00a7d": {
                Integer n = 0xFF55FF;
                break;
            }
            case "\u00a7e": {
                Integer n = 0xFFFF55;
                break;
            }
            case "\u00a7f": {
                Integer n = 0xFFFFFF;
                break;
            }
            case "\u00a7g": {
                Integer n = 14538245;
                break;
            }
            case "\u00a7h": {
                Integer n = 14931153;
                break;
            }
            case "\u00a7i": {
                Integer n = 0xCECACA;
                break;
            }
            case "\u00a7j": {
                Integer n = 4471355;
                break;
            }
            case "\u00a7zm": {
                Integer n = 9901575;
                break;
            }
            case "\u00a7zn": {
                Integer n = 11823181;
                break;
            }
            case "\u00a7p": {
                Integer n = 14594349;
                break;
            }
            case "\u00a7q": {
                Integer n = 4694070;
                break;
            }
            case "\u00a7s": {
                Integer n = 2931368;
                break;
            }
            case "\u00a7t": {
                Integer n = 2181499;
                break;
            }
            case "\u00a7u": {
                Integer n = 10116294;
                break;
            }
            default: {
                Integer n = color = null;
            }
        }
        if (color != null) {
            return new CHFormatting().color(color, 0xFFFFFF);
        }
        Byte formatting = switch (str) {
            case "\u00a7k" -> (byte)1;
            case "\u00a7l" -> (byte)16;
            case "\u00a7m" -> (byte)2;
            case "\u00a7n" -> (byte)4;
            case "\u00a7o" -> (byte)8;
            case "\u00a7r" -> (byte)64;
            default -> null;
        };
        return formatting == null ? null : new CHFormatting().format(formatting);
    }

    public static enum ScaleMethod {
        DIRECT,
        GUI,
        RELATIVE_GUI;

    }

    public record Padding(int top, int bottom, int left, int right) {
    }
}

