/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements.functional;

import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.HudElements.interfaces.NumElement;
import com.minenash.customhud.ProfileManager;
import com.minenash.customhud.data.Flags;
import com.minenash.customhud.data.NumberFlags;

public class GetValueElement
implements HudElement,
NumElement {
    private final String valueName;
    private final NumberFlags flags;

    public GetValueElement(String valueName, Flags flags) {
        this.valueName = valueName;
        this.flags = NumberFlags.of(flags);
    }

    @Override
    public String getString() {
        String strValue = ProfileManager.getActive().strValues.get(this.valueName);
        return strValue != null ? strValue : this.flags.formatString(this.getNum());
    }

    @Override
    public Number getNumber() {
        String strValue = ProfileManager.getActive().strValues.get(this.valueName);
        return strValue != null ? (double)strValue.length() : this.getNum();
    }

    @Override
    public boolean getBoolean() {
        String strValue = ProfileManager.getActive().strValues.get(this.valueName);
        return strValue != null ? strValue.isEmpty() : this.getNum() > 0.0;
    }

    @Override
    public int getPrecision() {
        return this.flags.precision();
    }

    private double getNum() {
        return ProfileManager.getActive().numValues.getOrDefault(this.valueName, Double.NaN);
    }
}

