/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.data;

import com.minenash.customhud.data.HudTheme;
import java.util.HashMap;
import java.util.Map;

public class CHFormatting {
    public static final byte NONE = 0;
    public static final byte FULL_RESET = 64;
    public static final byte RESET = 32;
    public static final byte BOLD = 16;
    public static final byte ITALIC = 8;
    public static final byte UNDERLINE = 4;
    public static final byte STRIKE = 2;
    public static final byte OBFUSCATED = 1;
    private static final int INVERT = -1;
    private int color = 0;
    private int colorMask = 0;
    private byte formatting = 0;
    private static final Map<Byte, String> FORMAT_MAP = new HashMap<Byte, String>(32);

    public CHFormatting color(int color, int bitmask) {
        this.color = color;
        this.colorMask = bitmask;
        this.formatting = (byte)32;
        return this;
    }

    public CHFormatting format(byte format) {
        this.formatting = (byte)(this.formatting | format);
        return this;
    }

    public CHFormatting apply(CHFormatting f, HudTheme theme) {
        if ((f.formatting & 0x40) != 0) {
            this.color = theme.fgColor.color;
            this.colorMask = theme.fgColor.colorMask;
            this.formatting = 0;
            return this;
        }
        this.color &= ~f.colorMask;
        this.color |= f.color & f.colorMask;
        this.colorMask |= f.colorMask;
        this.formatting = (f.formatting & 0x20) != 0 && !theme.persistentFormatting ? (byte)0 : (byte)(this.formatting | f.formatting);
        return this;
    }

    public CHFormatting apply(int color, int mask) {
        this.color &= ~mask;
        this.color |= color & mask;
        this.colorMask |= mask;
        return this;
    }

    public CHFormatting copy() {
        CHFormatting f = new CHFormatting();
        f.color = this.color;
        f.colorMask = this.colorMask;
        f.formatting = this.formatting;
        return f;
    }

    public int getColor() {
        return this.color;
    }

    public String getFormatting() {
        return FORMAT_MAP.getOrDefault((byte)(this.formatting & 0x1F), "");
    }

    static {
        for (byte b = 0; b <= 31; b = (byte)(b + 1)) {
            Object format = "";
            if ((b & 0x10) != 0) {
                format = (String)format + "\u00a7l";
            }
            if ((b & 8) != 0) {
                format = (String)format + "\u00a7o";
            }
            if ((b & 4) != 0) {
                format = (String)format + "\u00a7n";
            }
            if ((b & 2) != 0) {
                format = (String)format + "\u00a7m";
            }
            if ((b & 1) != 0) {
                format = (String)format + "\u00a7k";
            }
            FORMAT_MAP.put(b, (String)format);
        }
    }
}

