/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.minenash.customhud.CustomHud;
import com.minenash.customhud.ProfileManager;
import com.minenash.customhud.UpdateChecker;
import com.minenash.customhud.data.Profile;
import com.minenash.customhud.data.Toggle;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_304;
import net.minecraft.class_3675;

public class ConfigManager {
    public static final Path CONFIG = CustomHud.CONFIG_FOLDER.resolve("config.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static boolean readProfiles = false;

    public static void load() {
        try {
            Files.createDirectories(CustomHud.PROFILE_FOLDER, new FileAttribute[0]);
        }
        catch (Exception e) {
            CustomHud.LOGGER.info("[CustomHud] Can't write to config dir");
            CustomHud.readProfiles();
            return;
        }
        if (!Files.exists(CONFIG, new LinkOption[0])) {
            CustomHud.LOGGER.info("[CustomHud] Couldn't find the config File, creating one");
            if (ConfigManager.isDirEmpty(CustomHud.PROFILE_FOLDER)) {
                ConfigManager.populate();
            }
            CustomHud.readProfiles();
            ConfigManager.save();
            return;
        }
        readProfiles = false;
        try {
            ConfigManager.read((JsonObject)GSON.fromJson((Reader)Files.newBufferedReader(CONFIG), JsonObject.class));
        }
        catch (JsonSyntaxException | NullPointerException e) {
            CustomHud.LOGGER.warn("[CustomHud] Malformed Json, Fixing");
            if (!readProfiles) {
                CustomHud.readProfiles();
            }
            ConfigManager.save();
        }
        catch (IOException e) {
            if (!readProfiles) {
                CustomHud.readProfiles();
            }
            CustomHud.LOGGER.error("[CustomHud] Couldn't read the config");
        }
    }

    private static boolean isDirEmpty(Path path) {
        boolean bl;
        block8: {
            Stream<Path> files = Files.list(path);
            try {
                bl = files.findAny().isEmpty();
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            files.close();
        }
        return bl;
    }

    private static void populate() {
        URL folder = Profile.class.getClassLoader().getResource("assets/custom_hud/profiles");
        try (Stream<Path> files = Files.list(Path.of(folder.toURI()));){
            files.forEach(file -> {
                try (OutputStream writer = Files.newOutputStream(CustomHud.PROFILE_FOLDER.resolve(file.getFileName().toString()), new OpenOption[0]);
                     InputStream input = Files.newInputStream(file, new OpenOption[0]);){
                    input.transferTo(writer);
                }
                catch (Exception e) {
                    CustomHud.LOGGER.error("[CustomHud] Can't write default profiles");
                    CustomHud.LOGGER.catching((Throwable)e);
                }
            });
        }
        catch (Exception e) {
            CustomHud.LOGGER.error("[CustomHud] Can't write default profiles");
            CustomHud.LOGGER.catching((Throwable)e);
        }
    }

    public static void read(JsonObject json) {
        JsonElement lastVersion = json.get("latestKnownVersion");
        if (lastVersion != null) {
            UpdateChecker.latestKnownVersion = lastVersion.getAsString().split("\\.");
        }
        if (!json.has("configVersion")) {
            ConfigManager.readV1AndConvert(json);
            return;
        }
        int version = json.get("configVersion").getAsInt();
        if (version == 2) {
            ConfigManager.readV2(json);
        } else if (version == 3) {
            ConfigManager.readV3(json);
        } else {
            CustomHud.LOGGER.warn("[CustomHud] Unknown Config Version. Not loading it");
        }
    }

    public static void readV1AndConvert(JsonObject json) {
        CustomHud.LOGGER.info("[CustomHud] Config Version Not Found, Assuming Version 1, Converting");
        ProfileManager.enabled = json.get("enabled").getAsBoolean();
        try (Stream<Path> pathsStream = Files.list(CustomHud.CONFIG_FOLDER);){
            for (Path path : pathsStream.collect(Collectors.toSet())) {
                String fileName;
                if (Files.isDirectory(path, new LinkOption[0]) || !(fileName = path.getFileName().toString()).endsWith(".txt")) continue;
                String outName = switch (fileName) {
                    case "profile1.txt" -> "Profile 1.txt";
                    case "profile2.txt" -> "Profile 2.txt";
                    case "profile3.txt" -> "Profile 3.txt";
                    default -> fileName;
                };
                try {
                    Files.move(path, CustomHud.PROFILE_FOLDER.resolve(outName), new CopyOption[0]);
                }
                catch (IOException e) {
                    CustomHud.LOGGER.catching((Throwable)e);
                }
            }
        }
        catch (IOException e) {
            CustomHud.LOGGER.catching((Throwable)e);
        }
        CustomHud.readProfiles();
        readProfiles = true;
        ProfileManager.fallback();
        ConfigManager.save();
    }

    public static void readV2(JsonObject json) {
        String activeProfileName = json.get("activeProfile").getAsString();
        json.remove("activeProfile");
        json.addProperty("activeProfileName", activeProfileName);
        ConfigManager.readV3(json);
    }

    public static void readV3(JsonObject json) {
        CustomHud.readProfiles();
        readProfiles = true;
        JsonElement lastVersion = json.get("latestKnownVersion");
        if (lastVersion != null) {
            UpdateChecker.latestKnownVersion = lastVersion.getAsString().split("\\.");
        }
        Map<String, Profile> profiles = ProfileManager.getProfiles().stream().collect(Collectors.toMap(p -> p.name, p -> p));
        if (json.has("debugMode")) {
            CustomHud.DEBUG_MODE = json.get("debugMode").getAsBoolean();
        }
        ProfileManager.enabled = json.get("enabled").getAsBoolean();
        JsonArray jsonProfiles = json.get("profiles").getAsJsonArray();
        ArrayList<Profile> order = new ArrayList<Profile>();
        for (JsonElement element : jsonProfiles) {
            JsonObject obj = element.getAsJsonObject();
            String name = obj.get("name").getAsString();
            Profile p2 = profiles.get(name);
            if (p2 == null || order.contains(p2)) continue;
            String keyTranslation = obj.get("key").getAsString();
            p2.keyBinding.method_1422(class_3675.method_15981((String)keyTranslation));
            p2.cycle = obj.get("cycle").getAsBoolean();
            order.add(p2);
        }
        ProfileManager.reorder(order, false);
        String activeProfileName = json.get("activeProfileName").getAsString();
        if (activeProfileName == null) {
            ProfileManager.setActive(null);
        } else {
            Profile profile = profiles.get(activeProfileName);
            if (profile != null) {
                ProfileManager.setActive(profile);
            }
        }
        JsonArray toggleBinds = json.get("toggleBinds").getAsJsonArray();
        for (JsonElement element : toggleBinds) {
            String modifierTranslation;
            JsonObject obj = element.getAsJsonObject();
            String profileName = obj.get("profile").getAsString();
            Profile p3 = profiles.get(profileName);
            if (p3 == null) continue;
            String name = obj.get("name").getAsString();
            String keyTranslation = obj.get("key").getAsString();
            String string = modifierTranslation = obj.has("modifier") ? obj.get("modifier").getAsString() : null;
            if (p3.toggles.containsKey(name)) {
                p3.toggles.get((Object)name).key.method_1422(class_3675.method_15981((String)keyTranslation));
                continue;
            }
            class_304 key = new class_304("customhud_toggle_" + String.valueOf(UUID.randomUUID()), -1, CustomHud.TOGGLES_KB_CAT);
            key.method_1422(class_3675.method_15981((String)keyTranslation));
            class_304 modifier = new class_304("customhud_toggle_" + String.valueOf(UUID.randomUUID()), -1, CustomHud.TOGGLES_KB_CAT);
            if (modifierTranslation != null) {
                modifier.method_1422(class_3675.method_15981((String)modifierTranslation));
            }
            p3.toggles.put(name, new Toggle(name, false, -1, false, modifier, key));
        }
    }

    public static void save() {
        if (!Files.exists(CONFIG, new LinkOption[0])) {
            try {
                Files.createFile(CONFIG, new FileAttribute[0]);
            }
            catch (IOException e) {
                CustomHud.LOGGER.error("[CustomHud] Couldn't create the config file");
                return;
            }
        }
        JsonObject config = new JsonObject();
        config.addProperty("configVersion", (Number)3);
        config.addProperty("debugMode", Boolean.valueOf(CustomHud.DEBUG_MODE));
        config.addProperty("enabled", Boolean.valueOf(ProfileManager.enabled));
        config.addProperty("activeProfileName", ProfileManager.getActive() == null ? "" : ProfileManager.getActive().name);
        config.addProperty("latestKnownVersion", UpdateChecker.getLatestKnownVersionAsString());
        JsonArray profiles = new JsonArray();
        for (Profile profile : ProfileManager.getProfiles()) {
            JsonObject obj = new JsonObject();
            obj.addProperty("name", profile.name);
            obj.addProperty("key", profile.keyBinding.method_1428());
            obj.addProperty("cycle", Boolean.valueOf(profile.cycle));
            profiles.add((JsonElement)obj);
        }
        config.add("profiles", (JsonElement)profiles);
        JsonArray toggleBinds = new JsonArray();
        for (Profile profile : ProfileManager.getProfiles()) {
            for (Toggle toggle : profile.toggles.values()) {
                if (toggle.direct || toggle.key.method_1415()) continue;
                JsonObject obj = new JsonObject();
                obj.addProperty("profile", profile.name);
                obj.addProperty("name", toggle.name);
                obj.addProperty("key", toggle.key.method_1428());
                obj.addProperty("modifier", toggle.modifier.method_1428());
                obj.addProperty("value", Boolean.valueOf(toggle.value));
                toggleBinds.add((JsonElement)obj);
            }
        }
        config.add("toggleBinds", (JsonElement)toggleBinds);
        try {
            Files.write(CONFIG, GSON.toJson((JsonElement)config).getBytes(), new OpenOption[0]);
        }
        catch (IOException iOException) {
            CustomHud.LOGGER.error("[CustomHud] Couldn't save the config file");
        }
    }
}

