/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements;

import com.minenash.customhud.CustomHud;
import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.HudElements.interfaces.IdElement;
import com.minenash.customhud.HudElements.interfaces.NumElement;
import com.minenash.customhud.HudElements.text.TextElement;
import com.minenash.customhud.data.Flags;
import com.minenash.customhud.data.NumberFlags;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3446;
import net.minecraft.class_5348;

public abstract class FuncElements<T>
implements HudElement {
    Supplier<T> supplier;

    protected FuncElements(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public static <T, E> E sanitize(Supplier<T> supplier, Function<T, E> function, E onFail) {
        try {
            T input = supplier.get();
            if (input == null) {
                return onFail;
            }
            E output = function.apply(input);
            return output == null ? onFail : output;
        }
        catch (Exception _e) {
            return onFail;
        }
    }

    public static class SpecialText<T>
    extends TextElement {
        private final Supplier<T> supplier;
        private final TextEntry<T> entry;

        public SpecialText(Supplier<T> supplier, TextEntry<T> entry) {
            this.supplier = supplier;
            this.entry = entry;
        }

        @Override
        public String getString() {
            return this.getText().getString();
        }

        @Override
        public Number getNumber() {
            return FuncElements.sanitize(this.supplier, this.entry.num, Double.NaN);
        }

        @Override
        public boolean getBoolean() {
            return FuncElements.sanitize(this.supplier, this.entry.bool, false);
        }

        @Override
        public int getTextWidth() {
            return CustomHud.CLIENT.field_1772.method_27525((class_5348)this.getText());
        }

        @Override
        public class_2561 getText() {
            return (class_2561)FuncElements.sanitize(this.supplier, this.entry.text, class_2561.method_43470((String)"-"));
        }

        public record TextEntry<T>(Function<T, class_2561> text, Function<T, Number> num, Function<T, Boolean> bool) {
        }
    }

    public static class SpecialId<T>
    extends Id<T> {
        private final Entry<T> entry;

        public SpecialId(Supplier<T> supplier, Function<T, class_2960> id, Function<T, Number> num, Function<T, Boolean> bool, Flags flags) {
            super(supplier, id, flags);
            this.entry = new Entry<T>(id, num, bool);
        }

        @Override
        public Number getNumber() {
            return SpecialId.sanitize(this.supplier, this.entry.num, Double.NaN);
        }

        @Override
        public boolean getBoolean() {
            return SpecialId.sanitize(this.supplier, this.entry.bool, false);
        }

        public record Entry<T>(Function<T, class_2960> id, Function<T, Number> num, Function<T, Boolean> bool) {
        }
    }

    public static class Special<T>
    extends FuncElements<T> {
        private final Entry<T> entry;

        public Special(Supplier<T> supplier, Entry<T> entry) {
            super(supplier);
            this.entry = entry;
        }

        public Special(Supplier<T> supplier, Function<T, String> str, Function<T, Number> num, Function<T, Boolean> bool) {
            super(supplier);
            this.entry = new Entry<T>(str, num, bool);
        }

        @Override
        public String getString() {
            return Special.sanitize(this.supplier, this.entry.str, "-");
        }

        @Override
        public Number getNumber() {
            return Special.sanitize(this.supplier, this.entry.num, Double.NaN);
        }

        @Override
        public boolean getBoolean() {
            return Special.sanitize(this.supplier, this.entry.bool, false);
        }

        public record Entry<T>(Function<T, String> str, Function<T, Number> num, Function<T, Boolean> bool) {
        }
    }

    public static class NumBool<T>
    extends Num<T> {
        private final Function<T, Boolean> bool;

        public NumBool(Supplier<T> supplier, Function<T, Number> num, Function<T, Boolean> bool, Flags flags) {
            super(supplier, num, flags);
            this.bool = bool;
        }

        @Override
        public boolean getBoolean() {
            return NumBool.sanitize(this.supplier, this.bool, false);
        }
    }

    public static class Num<T>
    extends FuncElements<T>
    implements NumElement {
        private final Function<T, Number> function;
        private final NumberFlags flags;

        public static <T> NumEntry<T> of(int p, Function<T, Number> func) {
            return new NumEntry<T>(func, p, null);
        }

        public static <T> NumEntry<T> of(int p, class_3446 f, Function<T, Number> func) {
            return new NumEntry<T>(func, p, f);
        }

        public static <T> NumEntry<T> of(class_3446 f, Function<T, Number> func) {
            return new NumEntry<T>(func, 0, f);
        }

        public Num(Supplier<T> supplier, Function<T, Number> func, Flags flags) {
            super(supplier);
            this.function = func;
            this.flags = NumberFlags.of(flags);
        }

        public Num(Supplier<T> supplier, NumEntry<T> entry, Flags flags) {
            super(supplier);
            this.function = entry.function;
            this.flags = NumberFlags.of(flags, entry.precision, entry.formatter);
        }

        @Override
        public int getPrecision() {
            return this.flags.precision();
        }

        @Override
        public Number getNumber() {
            return Num.sanitize(this.supplier, this.function, Double.NaN);
        }

        @Override
        public boolean getBoolean() {
            return ((Number)Num.sanitize(this.supplier, this.function, Double.NaN)).doubleValue() > 0.0;
        }

        @Override
        public String getString() {
            try {
                return this.flags.formatString(this.getNumber().doubleValue());
            }
            catch (Exception e) {
                return "-";
            }
        }

        public record NumEntry<T>(Function<T, Number> function, int precision, class_3446 formatter) {
        }
    }

    public static class Tex<T>
    extends TextElement {
        private final Function<T, class_2561> function;
        private final Supplier<T> supplier;

        public Tex(Supplier<T> supplier, Function<T, class_2561> func) {
            this.supplier = supplier;
            this.function = func;
        }

        @Override
        public String getString() {
            return this.getText().getString();
        }

        @Override
        public boolean getBoolean() {
            return this.getNumber().intValue() > 0;
        }

        @Override
        public Number getNumber() {
            try {
                T sup = this.supplier.get();
                if (sup == null) {
                    return Double.NaN;
                }
                class_2561 text = this.function.apply(sup);
                return text == null ? Double.NaN : (double)text.getString().length();
            }
            catch (Exception e) {
                return Double.NaN;
            }
        }

        @Override
        public int getTextWidth() {
            return CustomHud.CLIENT.field_1772.method_27525((class_5348)this.getText());
        }

        @Override
        public class_2561 getText() {
            return (class_2561)FuncElements.sanitize(this.supplier, this.function, class_2561.method_43470((String)"-"));
        }
    }

    public static class Id<T>
    extends FuncElements<T>
    implements IdElement {
        private final Function<T, class_2960> function;
        private final Flags.IdPart idPart;

        public Id(Supplier<T> supplier, Function<T, class_2960> func, Flags flags) {
            super(supplier);
            this.function = func;
            this.idPart = flags.idPart;
        }

        @Override
        public class_2960 getIdentifier() {
            return Id.sanitize(this.supplier, this.function, null);
        }

        @Override
        public String getString() {
            return IdElement.getString(this.getIdentifier(), this.idPart);
        }

        @Override
        public Number getNumber() {
            class_2960 id = this.getIdentifier();
            return id == null ? 0 : id.toString().length();
        }

        @Override
        public boolean getBoolean() {
            class_2960 id = this.getIdentifier();
            return id != null && !id.toString().isEmpty();
        }
    }

    public static class Str<T>
    extends FuncElements<T> {
        private final Function<T, String> function;

        public Str(Supplier<T> supplier, Function<T, String> func) {
            super(supplier);
            this.function = func;
        }

        @Override
        public String getString() {
            return Str.sanitize(this.supplier, this.function, "-");
        }

        @Override
        public boolean getBoolean() {
            return this.getNumber().doubleValue() > 0.0;
        }

        @Override
        public Number getNumber() {
            try {
                return this.function.apply(this.supplier.get()).length();
            }
            catch (Exception ignored) {
                return 0;
            }
        }
    }

    public static class Bool<T>
    extends FuncElements<T> {
        private final Function<T, Boolean> function;

        public Bool(Supplier<T> supplier, Function<T, Boolean> func) {
            super(supplier);
            this.function = func;
        }

        @Override
        public String getString() {
            return Bool.sanitize(this.supplier, this.function, false) != false ? "true" : "false";
        }

        @Override
        public Number getNumber() {
            return Bool.sanitize(this.supplier, this.function, false) != false ? 1 : 0;
        }

        @Override
        public boolean getBoolean() {
            return Bool.sanitize(this.supplier, this.function, false);
        }
    }
}

