/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements.icon;

import com.minenash.customhud.HudElements.functional.FunctionalElement;
import com.minenash.customhud.data.Flags;
import com.minenash.customhud.render.RenderPiece;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import org.joml.Matrix3x2fStack;

public abstract class IconElement
extends FunctionalElement {
    protected final float scale;
    protected final int shiftX;
    protected final int shiftY;
    protected final int width;
    protected final float rotation;
    protected final boolean referenceCorner;
    protected UUID providerID = null;

    protected IconElement(Flags flags, double defaultWidth) {
        this.scale = (float)flags.scale;
        this.shiftX = flags.iconShiftX;
        this.shiftY = flags.iconShiftY;
        this.width = (int)Math.ceil(flags.iconWidth != -1 ? (double)flags.iconWidth : defaultWidth * (double)this.scale);
        this.rotation = flags.rotation;
        this.referenceCorner = flags.iconReferenceCorner;
    }

    public abstract void render(class_332 var1, RenderPiece var2);

    public int getTextWidth() {
        return this.width;
    }

    public UUID getProviderID() {
        return this.providerID;
    }

    @Override
    public String getString() {
        return "\ufffe";
    }

    protected void rotate(Matrix3x2fStack matrices, float renderWidth, float renderHeight) {
        matrices.translate(renderWidth / 2.0f, renderHeight / 2.0f);
        matrices.rotate(this.rotation);
        matrices.translate(-renderWidth / 2.0f, -renderHeight / 2.0f);
    }

    public void renderItemStack(class_332 context, int x, int y, class_1799 stack, boolean fitInLine) {
        int size;
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate((float)(x + this.shiftX), (float)(y + this.shiftY - 2));
        int n = size = fitInLine ? 11 : 16;
        if (!this.referenceCorner) {
            matrices.translate(0.0f, -((float)size * this.scale - 11.0f) / 2.0f);
        }
        matrices.scale((float)size / 16.0f * this.scale, (float)size / 16.0f * this.scale);
        this.rotate(matrices, 16.0f, 16.0f);
        this.rotate(matrices, 16.0f, 16.0f);
        context.method_51427(stack, 0, 0);
        matrices.popMatrix();
    }
}

