/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud;

import com.minenash.customhud.ConfigManager;
import com.minenash.customhud.CustomHud;
import com.minenash.customhud.data.Profile;
import com.minenash.customhud.data.Toggle;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_7919;

public class ProfileManager {
    private static List<Profile> profiles = new ArrayList<Profile>();
    private static Profile active = null;
    public static boolean enabled = true;
    public static final String openTooltipStr = "Open in your text editor";
    public static final class_7919 openTooltip = class_7919.method_47407((class_2561)class_2561.method_43470((String)"Open in your text editor"));

    public static Profile getActive() {
        if (!enabled) {
            return null;
        }
        ProfileManager.fallback();
        return active;
    }

    public static Profile setActive(Profile active) {
        ProfileManager.active = active;
        return ProfileManager.active;
    }

    public static void add(Profile profile) {
        profiles.add(profile);
    }

    public static void remove(Profile profile, boolean deleteFile) {
        if (active == profile) {
            active = null;
        }
        profiles.remove(profile);
        if (deleteFile) {
            try {
                Files.delete(CustomHud.PROFILE_FOLDER.resolve(profile.name + ".txt"));
            }
            catch (Exception e) {
                CustomHud.LOGGER.error("Couldn't delete profile, IO Error");
            }
        }
    }

    public static void replace(Profile profile) {
        for (int i = 0; i < profiles.size(); ++i) {
            Profile p = profiles.get(i);
            if (!p.name.equals(profile.name)) continue;
            profile.cycle = p.cycle;
            profile.keyBinding = p.keyBinding;
            for (Map.Entry<String, Toggle> entry : p.toggles.entrySet()) {
                Toggle tt;
                Toggle t = entry.getValue();
                if (!(t.direct || t.key.method_1415() || profile.toggles.containsKey(entry.getKey()))) {
                    entry.getValue().inProfile = false;
                    profile.toggles.put(entry.getKey(), t);
                }
                if ((tt = profile.toggles.get(entry.getKey())) == null) continue;
                Toggle oldT = entry.getValue();
                tt.value = oldT.getValue();
                tt.key = oldT.key;
                tt.modifier = oldT.modifier;
            }
            profiles.set(i, profile);
            if (p == active) {
                active = profile;
            }
            ConfigManager.save();
            return;
        }
    }

    public static void fallback() {
        if (active == null && !profiles.isEmpty()) {
            active = profiles.get(0);
        }
    }

    public static void open(Profile profile) {
        if (profile != null) {
            new Thread(() -> class_156.method_668().method_672(CustomHud.PROFILE_FOLDER.resolve(profile.name + ".txt").toFile())).start();
        }
    }

    public static List<Profile> getProfiles() {
        return profiles;
    }

    public static void reorder(List<Profile> order, boolean save) {
        for (Profile p : profiles) {
            if (order.contains(p)) continue;
            order.add(p);
        }
        profiles = order;
        if (save) {
            ConfigManager.save();
        }
    }

    public static void rename(Profile profile, String name) {
        Path oldPath = CustomHud.PROFILE_FOLDER.resolve(profile.name + ".txt");
        profile.name = name;
        try {
            Path newPath = CustomHud.PROFILE_FOLDER.resolve(name + ".txt");
            Files.move(oldPath, newPath, new CopyOption[0]);
            ConfigManager.save();
        }
        catch (IOException e) {
            CustomHud.LOGGER.error("Can't rename profile, IO Exception");
            CustomHud.LOGGER.catching((Throwable)e);
            CustomHud.CLIENT.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43470((String)"\u00a7cUnable to Rename Profile"), (class_2561)class_2561.method_43470((String)"\u00a7eIO Exception")));
        }
    }

    public static Profile createBlank() {
        String name;
        List<String> profiles = ProfileManager.getProfiles().stream().map(p -> p.name).toList();
        int index = 1;
        while (profiles.contains(name = "New Profile " + index)) {
            ++index;
        }
        try {
            Files.createFile(CustomHud.PROFILE_FOLDER.resolve(name + ".txt"), new FileAttribute[0]);
        }
        catch (Exception e) {
            CustomHud.LOGGER.error("Can't create profile file, IO Error");
            return null;
        }
        Profile p2 = Profile.create(name);
        ProfileManager.add(p2);
        return p2;
    }

    public static void cycle() {
        Profile p;
        int i;
        int index = profiles.indexOf(active);
        for (i = index + 1; i < profiles.size(); ++i) {
            p = profiles.get(i);
            if (!p.cycle) continue;
            ProfileManager.setActive(p);
            return;
        }
        for (i = 0; i <= index; ++i) {
            p = profiles.get(i);
            if (!p.cycle) continue;
            ProfileManager.setActive(p);
            return;
        }
    }
}

