/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.errors;

import com.minenash.customhud.errors.ErrorContext;
import com.minenash.customhud.errors.ErrorType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Errors {
    private static final Map<String, List<Error>> errors = new HashMap<String, List<Error>>();

    public static List<Error> getErrors(String profileName) {
        return errors.computeIfAbsent(profileName, str -> new ArrayList());
    }

    public static boolean hasErrors(String profileName) {
        return !Errors.getErrors(profileName).isEmpty();
    }

    public static void clearErrors(String profileName) {
        Errors.getErrors(profileName).clear();
    }

    public static Error addError(String profileName, int line, String source, ErrorType type, String context) {
        return Errors.addError(profileName, Integer.toString(line + 1), source, type, context);
    }

    public static Error addError(String profileName, String line, String source, ErrorType type, String context) {
        Error e = new Error(line, source, type, context == null ? "" : context);
        Errors.getErrors(profileName).add(e);
        return e;
    }

    public static Error addError(ErrorContext context, ErrorType type, String value) {
        return Errors.addError(context.profileName(), Integer.toString(context.line()), context.src(), type, value);
    }

    public record Error(String line, String source, ErrorType type, String context) {
    }
}

