/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.render;

import com.minenash.customhud.HudElements.functional.FunctionalElement;
import com.minenash.customhud.data.Section;
import com.minenash.customhud.render.BgRenderPiece;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_332;

public class BackgroundBuilder {
    public final int sectionWidth;
    public final Section.Align textAlign;
    public final boolean isDynamic;
    public final boolean isMax;
    public final boolean isSet;
    public int maxWidth = 0;
    List<BgRenderPiece> bgPieces = new ArrayList<BgRenderPiece>();
    BgRenderPiece nonDynamicBgPiece = null;

    public BackgroundBuilder(Section section) {
        this.sectionWidth = section.width;
        this.textAlign = section.textAlign;
        this.isDynamic = this.sectionWidth == -1;
        this.isMax = this.sectionWidth == -2;
        this.isSet = this.sectionWidth >= 0;
    }

    public void addLine(int yOffset, int width, int height, int color) {
        this.maxWidth = Math.max(this.maxWidth, width);
        if (this.isDynamic) {
            this.bgPieces.add(new BgRenderPiece(0, yOffset, width, height, color));
        } else if (this.nonDynamicBgPiece == null) {
            this.nonDynamicBgPiece = new BgRenderPiece(0, yOffset, width, height, color);
        } else {
            this.nonDynamicBgPiece.height += height;
        }
    }

    public void onThemeChange(FunctionalElement.ChangeTheme cte) {
        if (!this.isDynamic && this.nonDynamicBgPiece != null && this.nonDynamicBgPiece.color != cte.theme.bgColor) {
            int yOffset = this.nonDynamicBgPiece.y + this.nonDynamicBgPiece.height;
            this.bgPieces.add(this.nonDynamicBgPiece);
            this.nonDynamicBgPiece = new BgRenderPiece(0, yOffset, 0, 0, cte.theme.bgColor);
        }
    }

    public void finalizeBg(class_332 context, int x, int y) {
        if (this.isDynamic) {
            if (this.textAlign == Section.Align.RIGHT) {
                for (BgRenderPiece bgRenderPiece : this.bgPieces) {
                    bgRenderPiece.x = this.maxWidth - bgRenderPiece.width;
                }
            } else if (this.textAlign == Section.Align.CENTER) {
                for (BgRenderPiece bgRenderPiece : this.bgPieces) {
                    bgRenderPiece.x = this.maxWidth / 2 - bgRenderPiece.width / 2;
                }
            }
        } else {
            if (this.nonDynamicBgPiece != null) {
                this.bgPieces.add(this.nonDynamicBgPiece);
            }
            int width = this.isSet ? this.sectionWidth : this.maxWidth;
            for (BgRenderPiece piece : this.bgPieces) {
                piece.width = width;
            }
        }
        for (BgRenderPiece bgRenderPiece : this.bgPieces) {
            context.method_25294(x + bgRenderPiece.x, y + bgRenderPiece.y, x + bgRenderPiece.x + bgRenderPiece.width, y + bgRenderPiece.y + bgRenderPiece.height, bgRenderPiece.color);
        }
    }
}

