/*
 * Decompiled with CFR 0.152.
 */
package com.minenash.customhud.HudElements;

import com.minenash.customhud.HudElements.functional.FunctionalElement;
import com.minenash.customhud.HudElements.interfaces.HudElement;
import com.minenash.customhud.HudElements.interfaces.MultiElement;
import com.minenash.customhud.conditionals.Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ConditionalElement
extends FunctionalElement
implements HudElement,
MultiElement {
    private final List<ConditionalPair> pairs;
    private final boolean multiline;

    public ConditionalElement(List<ConditionalPair> pairs, boolean multiline) {
        this.pairs = pairs;
        this.multiline = multiline;
    }

    @Override
    public List<HudElement> expand() {
        for (ConditionalPair pair : this.pairs) {
            if (pair.conditional.getValue() == 0.0) continue;
            return pair.ifTrue;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean ignoreNewlineIfEmpty() {
        return !this.multiline;
    }

    @Override
    public String getString() {
        return this.expandIntoString();
    }

    public record ConditionalPair(Operation conditional, List<HudElement> ifTrue) {
    }

    public static class MultiLineBuilder {
        private final List<ConditionalPair> pairs = new ArrayList<ConditionalPair>();
        private Operation conditional = null;
        private List<HudElement> elements = new ArrayList<HudElement>();

        public MultiLineBuilder(Operation conditional) {
            this.setConditional(conditional);
        }

        public void setConditional(Operation conditional) {
            if (this.conditional != null) {
                this.pairs.add(new ConditionalPair(this.conditional, this.elements));
                this.elements = new ArrayList<HudElement>();
            }
            this.conditional = conditional;
        }

        public void add(HudElement element) {
            this.elements.add(element);
        }

        public void addAll(List<HudElement> elements) {
            this.elements.addAll(elements);
        }

        public ConditionalElement build() {
            this.pairs.add(new ConditionalPair(this.conditional, this.elements));
            return new ConditionalElement(this.pairs, true);
        }
    }
}

